/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.mixin;

import dev.hybridlabs.aquatic.access.CustomPlayerEntityData;
import dev.hybridlabs.aquatic.effect.HybridAquaticStatusEffects;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3486;
import net.minecraft.class_4051;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
implements CustomPlayerEntityData {
    @Shadow
    protected boolean field_7490;
    @Unique
    private int haHurtTime = 0;
    @Unique
    private boolean isWearingDivingBoots;

    @Shadow
    public abstract boolean method_5681();

    @Override
    public void hybrid_aquatic$setHurtTime(int value) {
        this.haHurtTime = value;
    }

    @Override
    public int hybrid_aquatic$getHurtTime() {
        return this.haHurtTime;
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        this.hybrid_aquatic$setHurtTime(nbt.method_10550("haHurtTime"));
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("haHurtTime", this.hybrid_aquatic$getHurtTime());
    }

    @Inject(method={"shouldSwimInFluids"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideShouldSwimInFluids(CallbackInfoReturnable<Boolean> ci) {
        if (this.isWearingDivingBoots && !this.method_5681() && this.field_7490) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getWorld()Lnet/minecraft/world/World;", ordinal=0, shift=At.Shift.BEFORE)})
    private void setCustomHurtTimeOnDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 foundEntity;
        class_1657 object = (class_1657)this;
        if (object.method_5799() && (foundEntity = object.method_37908().method_21726(HybridAquaticSharkEntity.class, class_4051.method_36626().method_18418(32.0).method_18420(class_1297::method_5869), (class_1309)object, object.method_23317(), object.method_23320(), object.method_23321(), object.method_5829().method_1014(16.0))) != null) {
            this.hybrid_aquatic$setHurtTime(200);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickDownCustomHurtTime(CallbackInfo ci) {
        int cHurtTime = this.hybrid_aquatic$getHurtTime();
        if (cHurtTime > 0) {
            this.hybrid_aquatic$setHurtTime(cHurtTime - 1);
        }
        this.updateDivingHelmet();
        this.updateTurtleChestplate();
        this.updateDivingBoots();
    }

    @Unique
    private void updateDivingHelmet() {
        class_1657 player = (class_1657)this;
        class_1799 itemStack = player.method_6118(class_1304.field_6169);
        if (itemStack.method_31574(HybridAquaticItems.INSTANCE.getDIVING_HELMET())) {
            if (!player.method_5777(class_3486.field_15517)) {
                player.method_6092(new class_1293(class_1294.field_5923, 600, 0, false, false, false));
            } else {
                player.method_6092(new class_1293(HybridAquaticStatusEffects.INSTANCE.getCLARITY(), 600, 0, false, false, false));
            }
        }
    }

    @Unique
    private void updateDivingBoots() {
        class_1657 player = (class_1657)this;
        class_1799 itemStack = player.method_6118(class_1304.field_6166);
        this.isWearingDivingBoots = itemStack.method_31574(HybridAquaticItems.INSTANCE.getDIVING_BOOTS());
        if (this.isWearingDivingBoots && player.method_5777(class_3486.field_15517)) {
            player.method_49477(1.0f);
        } else {
            player.method_49477(0.6f);
        }
    }

    @Unique
    private void updateTurtleChestplate() {
        class_1657 player = (class_1657)this;
        class_1799 itemStack = player.method_6118(class_1304.field_6174);
        if (itemStack.method_31574(HybridAquaticItems.INSTANCE.getTURTLE_CHESTPLATE())) {
            player.method_6092(new class_1293(class_1294.field_5907, 200, 0, false, false, true));
            player.method_6092(new class_1293(class_1294.field_5909, 200, 0, false, false, true));
        }
    }
}

