/*
 * Decompiled with CFR 0.152.
 */
package com.va11halla.casualness_delight.enity;

import com.va11halla.casualness_delight.block.DeepFryingPan;
import com.va11halla.casualness_delight.recipe.DeepFryingRecipe;
import com.va11halla.casualness_delight.registry.BlockEntityTypesRegistry;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class DeepFryingPanEntity
extends SyncedBlockEntity
implements HeatableBlockEntity {
    private final ItemStackHandlerContainer inventory = this.createHandler();
    private int cookingTime;
    private int cookingTimeTotal;
    private class_2960 lastRecipeID;
    private class_1799 DeepFryingPanStack = class_1799.field_8037;
    private int fireAspectLevel;
    public long lastFlippedTime = 0L;

    public DeepFryingPanEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityTypesRegistry.DEEPFRYINGPAN.get(), pos, state);
    }

    public static void cookingTick(class_1937 level, class_2338 pos, class_2680 state, DeepFryingPanEntity deepFryingPan) {
        boolean isHeated = deepFryingPan.isHeated(level, pos);
        if (isHeated) {
            class_1799 cookingStack = deepFryingPan.getStoredStack();
            if (cookingStack.method_7960()) {
                deepFryingPan.cookingTime = 0;
            } else {
                deepFryingPan.cookAndOutputItems(cookingStack, level);
            }
        } else if (deepFryingPan.cookingTime > 0) {
            deepFryingPan.cookingTime = class_3532.method_15340((int)(deepFryingPan.cookingTime - 2), (int)0, (int)deepFryingPan.cookingTimeTotal);
        }
    }

    public static void animationTick(class_1937 level, class_2338 pos, class_2680 state, DeepFryingPanEntity deepFryingPan) {
        if (deepFryingPan.isHeated(level, pos) && deepFryingPan.hasStoredStack()) {
            double z;
            double y;
            double x;
            class_5819 random = level.field_9229;
            if (random.method_43057() < 0.2f) {
                x = (double)pos.method_10263() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                y = (double)pos.method_10264() + 0.1;
                z = (double)pos.method_10260() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                double motionY = random.method_43056() ? 0.015 : 0.005;
                level.method_8406((class_2394)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
            }
            if (deepFryingPan.fireAspectLevel > 0 && random.method_43057() < (float)deepFryingPan.fireAspectLevel * 0.05f) {
                x = (double)pos.method_10263() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                y = (double)pos.method_10264() + 0.1;
                z = (double)pos.method_10260() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                double motionX = level.field_9229.method_43057() - 0.5f;
                double motionY = level.field_9229.method_43057() * 0.5f + 0.2f;
                double motionZ = level.field_9229.method_43057() - 0.5f;
                level.method_8406((class_2394)class_2398.field_11208, x, y, z, motionX, motionY, motionZ);
            }
            if ((float)(level.method_8510() - deepFryingPan.lastFlippedTime) == 20.0f) {
                x = (double)pos.method_10263() + 0.5;
                y = (double)pos.method_10264() + 0.1;
                z = (double)pos.method_10260() + 0.5;
                level.method_8486(x, y, z, (class_3414)ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), class_3419.field_15245, 0.4f, level.field_9229.method_43057() * 0.2f + 0.9f, false);
            }
        }
    }

    private void cookAndOutputItems(class_1799 cookingStack, class_1937 level) {
        class_1277 wrapper;
        Optional<DeepFryingRecipe> recipe;
        if (level == null) {
            return;
        }
        ++this.cookingTime;
        if (this.cookingTime >= this.cookingTimeTotal && (recipe = this.getMatchingRecipe((class_1263)(wrapper = new class_1277(new class_1799[]{cookingStack})))).isPresent()) {
            class_1799 resultStack = recipe.get().method_8116((class_1263)wrapper, level.method_30349());
            class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)DeepFryingPan.FACING)).method_10170();
            ItemUtils.spawnItemEntity((class_1937)level, (class_1799)resultStack.method_7972(), (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 0.3), (double)((double)this.field_11867.method_10260() + 0.5), (double)((float)direction.method_10148() * 0.08f), (double)0.25, (double)((float)direction.method_10165() * 0.08f));
            this.cookingTime = 0;
            this.inventory.method_5434(0, 1);
        }
    }

    public boolean isCooking() {
        return this.isHeated() && this.hasStoredStack();
    }

    public boolean isHeated() {
        if (this.field_11863 != null) {
            return this.isHeated(this.field_11863, this.field_11867);
        }
        return false;
    }

    private Optional<DeepFryingRecipe> getMatchingRecipe(class_1263 recipeWrapper) {
        Optional recipe;
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (class_1860)((RecipeManagerAccessor)this.field_11863.method_8433()).getRecipeMap(DeepFryingRecipe.DEEP_FRYING_TYPE).get(this.lastRecipeID)) instanceof DeepFryingRecipe && recipe.method_8115(recipeWrapper, this.field_11863)) {
            return Optional.of((DeepFryingRecipe)((Object)recipe));
        }
        recipe = this.field_11863.method_8433().method_8132(DeepFryingRecipe.DEEP_FRYING_TYPE, recipeWrapper, this.field_11863);
        if (recipe.isPresent()) {
            this.lastRecipeID = ((DeepFryingRecipe)((Object)recipe.get())).method_8114();
            return recipe;
        }
        return Optional.empty();
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.inventory.deserializeNBT(compound.method_10562("Inventory"));
        this.cookingTime = compound.method_10550("CookTime");
        this.cookingTimeTotal = compound.method_10550("CookTimeTotal");
        this.DeepFryingPanStack = class_1799.method_7915((class_2487)compound.method_10562("Skillet"));
        this.fireAspectLevel = class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)this.DeepFryingPanStack);
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        compound.method_10569("CookTime", this.cookingTime);
        compound.method_10569("CookTimeTotal", this.cookingTimeTotal);
        compound.method_10566("Skillet", (class_2520)this.DeepFryingPanStack.method_7953(new class_2487()));
    }

    public class_2487 writeDeepFryingPanItem(class_2487 compound) {
        compound.method_10566("DeepFryingPan", (class_2520)this.DeepFryingPanStack.method_7953(new class_2487()));
        return compound;
    }

    public void setSkilletItem(class_1799 stack) {
        this.DeepFryingPanStack = stack.method_7972();
        this.fireAspectLevel = class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)stack);
        this.inventoryChanged();
    }

    public class_1799 addItemToCook(class_1799 addedStack, @Nullable class_1657 player) {
        Optional<DeepFryingRecipe> recipe = this.getMatchingRecipe((class_1263)new class_1277(new class_1799[]{addedStack}));
        if (recipe.isPresent()) {
            this.cookingTimeTotal = DeepFryingPan.getDeepFryingPanCookingTime(recipe.get().method_8167(), this.fireAspectLevel);
            boolean wasEmpty = this.getStoredStack().method_7960();
            class_1799 remainderStack = ItemUtils.insertItem((ItemStackHandlerContainer)this.inventory, (int)0, (class_1799)addedStack.method_7972(), (boolean)false);
            if (!class_1799.method_7973((class_1799)remainderStack, (class_1799)addedStack)) {
                this.lastRecipeID = recipe.get().method_8114();
                this.cookingTime = 0;
                if (wasEmpty && this.field_11863 != null && this.isHeated(this.field_11863, this.field_11867)) {
                    this.field_11863.method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), (class_3414)ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), class_3419.field_15245, 0.8f, 1.0f);
                }
                return remainderStack;
            }
        } else if (player != null) {
            player.method_7353((class_2561)TextUtils.getTranslation((String)"block.skillet.invalid_item", (Object[])new Object[0]), true);
        }
        return addedStack;
    }

    public class_1799 removeItem() {
        return this.inventory.method_5434(0, this.getStoredStack().method_7914());
    }

    public ItemStackHandlerContainer getInventory() {
        return this.inventory;
    }

    public class_1799 getStoredStack() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean hasStoredStack() {
        return !this.getStoredStack().method_7960();
    }

    private ItemStackHandlerContainer createHandler() {
        return new ItemStackHandlerContainer(){

            protected void onContentsChanged(int slot) {
                DeepFryingPanEntity.this.inventoryChanged();
            }
        };
    }

    public void method_11012() {
        super.method_11012();
    }
}

