/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder;

import java.util.ArrayList;
import java.util.List;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.util.Location;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.platform.util.Vector3;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.ShapeUtil;
import org.popcraft.chunkyborder.BorderData;
import org.popcraft.chunkyborder.BorderWrapType;
import org.popcraft.chunkyborder.ChunkyBorder;
import org.popcraft.chunkyborder.PlayerData;
import org.popcraft.chunkyborder.event.border.BorderWrapEvent;

public class BorderCheckTask
implements Runnable {
    private final ChunkyBorder chunkyBorder;

    public BorderCheckTask(ChunkyBorder chunkyBorder) {
        this.chunkyBorder = chunkyBorder;
    }

    @Override
    public void run() {
        for (Player player : this.chunkyBorder.getChunky().getServer().getPlayers()) {
            PlayerData playerData = this.chunkyBorder.getPlayerData(player.getUUID());
            if (player.hasPermission("chunkyborder.bypass.move") || playerData.isBypassing()) continue;
            this.chunkyBorder.getBorder(player.getWorld().getName()).ifPresent(borderData -> {
                Location location = player.getLocation();
                if (borderData.getBorder().isBounding(location.getX(), location.getZ())) {
                    playerData.setLastLocation(location);
                } else {
                    Location redirect;
                    BorderWrapType borderWrapType = borderData.getWrapType();
                    if (!BorderWrapType.NONE.equals((Object)borderWrapType)) {
                        redirect = this.wrap((BorderData)borderData, borderWrapType, player, playerData);
                        playerData.setLastLocation(redirect);
                        this.chunkyBorder.getChunky().getEventBus().call((Object)new BorderWrapEvent(player, location, redirect));
                    } else {
                        redirect = playerData.getLastLocation().orElse(location.getWorld().getSpawn());
                        redirect.setYaw(location.getYaw());
                        redirect.setPitch(location.getPitch());
                    }
                    location.getWorld().playEffect(player, this.chunkyBorder.getConfig().effect());
                    location.getWorld().playSound(player, this.chunkyBorder.getConfig().sound());
                    player.teleport(redirect);
                    if (this.chunkyBorder.getConfig().useActionBar()) {
                        player.sendActionBar("custom_border_message");
                    } else {
                        player.sendMessage("custom_border_message", new Object[0]);
                    }
                }
            });
        }
    }

    private Location wrap(BorderData borderData, BorderWrapType borderWrapType, Player player, PlayerData playerData) {
        boolean wrapped;
        Location location = player.getLocation();
        boolean rectangle = "square".equals(borderData.getShape()) || "rectangle".equals(borderData.getShape());
        switch (borderWrapType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                boolean bl = false;
                break;
            }
            case DEFAULT: {
                boolean bl;
                if (rectangle) {
                    bl = this.wrapBoth(borderData, location);
                    break;
                }
                bl = this.wrapRadial(borderData, location);
                break;
            }
            case BOTH: {
                boolean bl = this.wrapBoth(borderData, location);
                break;
            }
            case RADIAL: {
                boolean bl = this.wrapRadial(borderData, location);
                break;
            }
            case X: {
                boolean bl = this.wrapX(borderData, location);
                break;
            }
            case Z: {
                boolean bl = this.wrapZ(borderData, location);
                break;
            }
            case EARTH: {
                boolean bl = wrapped = rectangle && this.wrapEarth(borderData, location);
            }
        }
        if (wrapped) {
            int elevation = location.getWorld().getElevation((int)location.getX(), (int)location.getZ());
            if (elevation >= location.getWorld().getMaxElevation()) {
                return location.getWorld().getSpawn();
            }
            location.setY((double)elevation);
        } else {
            Location lastLocation = playerData.getLastLocation().orElse(location.getWorld().getSpawn());
            location.setX(lastLocation.getX());
            location.setY(lastLocation.getY());
            location.setZ(lastLocation.getZ());
        }
        return location;
    }

    private boolean wrapBoth(BorderData borderData, Location location) {
        this.wrapX(borderData, location);
        this.wrapZ(borderData, location);
        return true;
    }

    private boolean wrapRadial(BorderData borderData, Location location) {
        Vector2 center = Vector2.of((double)borderData.getCenterX(), (double)borderData.getCenterZ());
        Vector2 from = Vector2.of((double)location.getX(), (double)location.getZ());
        Shape border = borderData.getBorder();
        ArrayList<Vector2> intersections = new ArrayList<Vector2>();
        if (border instanceof AbstractPolygon) {
            AbstractPolygon polygon = (AbstractPolygon)border;
            List points = polygon.points();
            int size = points.size();
            for (int i = 0; i < size; ++i) {
                Vector2 p1 = (Vector2)points.get(i);
                Vector2 p2 = (Vector2)points.get(i == size - 1 ? 0 : i + 1);
                ShapeUtil.intersection((double)center.getX(), (double)center.getZ(), (double)from.getX(), (double)from.getZ(), (double)p1.getX(), (double)p1.getZ(), (double)p2.getX(), (double)p2.getZ()).ifPresent(intersections::add);
            }
        } else if (border instanceof AbstractEllipse) {
            AbstractEllipse ellipse = (AbstractEllipse)border;
            Vector2 radii = ellipse.radii();
            double angle = Math.PI + Math.atan2(from.getZ() - center.getX(), from.getX() - center.getZ());
            intersections.add(ShapeUtil.pointOnEllipse((double)center.getX(), (double)center.getZ(), (double)radii.getX(), (double)radii.getZ(), (double)angle));
        }
        if (intersections.isEmpty()) {
            return false;
        }
        Vector3 centerDirection = new Vector3(from.getX() - center.getX(), 0.0, from.getZ() - center.getZ()).normalize().multiply(3.0);
        Vector2 closest = (Vector2)intersections.get(0);
        double longestDistance = Double.MIN_VALUE;
        for (Vector2 intersection : intersections) {
            double distance = from.distanceSquared(intersection);
            if (!(distance > longestDistance) || !border.isBounding(intersection.getX() + centerDirection.getX(), intersection.getZ() + centerDirection.getZ())) continue;
            closest = intersection;
            longestDistance = distance;
        }
        if (longestDistance == Double.MIN_VALUE) {
            return false;
        }
        location.setX(closest.getX());
        location.setZ(closest.getZ());
        location.add(centerDirection);
        location.setDirection(centerDirection);
        return true;
    }

    private boolean wrapX(BorderData borderData, Location location) {
        double minX = borderData.getCenterX() - borderData.getRadiusX();
        double maxX = borderData.getCenterX() + borderData.getRadiusX();
        if (location.getX() <= minX) {
            location.setX(maxX - 3.0);
        } else if (location.getX() >= maxX) {
            location.setX(minX + 3.0);
        }
        double minZ = borderData.getCenterZ() - borderData.getRadiusZ();
        double maxZ = borderData.getCenterZ() + borderData.getRadiusZ();
        return location.getZ() > minZ && location.getZ() < maxZ;
    }

    private boolean wrapZ(BorderData borderData, Location location) {
        double minZ = borderData.getCenterZ() - borderData.getRadiusZ();
        double maxZ = borderData.getCenterZ() + borderData.getRadiusZ();
        if (location.getZ() <= minZ) {
            location.setZ(maxZ - 3.0);
        } else if (location.getZ() >= maxZ) {
            location.setZ(minZ + 3.0);
        }
        double minX = borderData.getCenterX() - borderData.getRadiusX();
        double maxX = borderData.getCenterX() + borderData.getRadiusX();
        return location.getX() > minX && location.getX() < maxX;
    }

    private boolean wrapEarth(BorderData borderData, Location location) {
        this.wrapX(borderData, location);
        double minZ = borderData.getCenterZ() - borderData.getRadiusZ();
        double maxZ = borderData.getCenterZ() + borderData.getRadiusZ();
        double centerX = borderData.getCenterX();
        double meridianDistance = centerX - location.getX();
        if (location.getZ() <= minZ) {
            location.setX(centerX + meridianDistance);
            location.setZ(minZ + 3.0);
            location.setYaw(0.0f);
        } else if (location.getZ() >= maxZ) {
            location.setX(centerX + meridianDistance);
            location.setZ(maxZ - 3.0);
            location.setYaw(180.0f);
        }
        return true;
    }
}

