/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.event.EventBus;
import org.popcraft.chunky.event.command.ReloadCommandEvent;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Location;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.platform.util.Vector3;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.ShapeUtil;
import org.popcraft.chunky.util.Translator;
import org.popcraft.chunky.util.Version;
import org.popcraft.chunkyborder.BorderData;
import org.popcraft.chunkyborder.ChunkyBorderProvider;
import org.popcraft.chunkyborder.PlayerData;
import org.popcraft.chunkyborder.event.server.BlockPlaceEvent;
import org.popcraft.chunkyborder.event.server.CreatureSpawnEvent;
import org.popcraft.chunkyborder.event.server.PlayerQuitEvent;
import org.popcraft.chunkyborder.event.server.PlayerTeleportEvent;
import org.popcraft.chunkyborder.event.server.WorldLoadEvent;
import org.popcraft.chunkyborder.event.server.WorldUnloadEvent;
import org.popcraft.chunkyborder.integration.MapIntegration;
import org.popcraft.chunkyborder.platform.Config;
import org.popcraft.chunkyborder.platform.MapIntegrationLoader;

public class ChunkyBorder {
    private static final Logger LOGGER = LogManager.getLogger((String)ChunkyBorder.class.getSimpleName());
    private final Chunky chunky;
    private final Config config;
    private final MapIntegrationLoader mapIntegrationLoader;
    private final List<MapIntegration> mapIntegrations = new ArrayList<MapIntegration>();
    private final Map<String, BorderData> borders;
    private final Map<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();
    private final Version version;
    private final Version targetVersion;

    public ChunkyBorder(Chunky chunky, Config config, MapIntegrationLoader mapIntegrationLoader) {
        this.chunky = chunky;
        this.config = config;
        this.mapIntegrationLoader = mapIntegrationLoader;
        this.borders = this.loadBorders();
        this.version = this.loadVersion();
        this.targetVersion = this.loadTargetVersion();
        this.subscribeEvents();
        ChunkyBorderProvider.register(this);
    }

    public void disable() {
        List<MapIntegration> maps = this.getMapIntegrations();
        maps.forEach(MapIntegration::removeAllShapeMarkers);
        maps.clear();
        this.saveBorders();
        ChunkyBorderProvider.unregister();
    }

    private void subscribeEvents() {
        EventBus eventBus = this.chunky.getEventBus();
        eventBus.subscribe(ReloadCommandEvent.class, e -> this.getConfig().reload());
        eventBus.subscribe(PlayerTeleportEvent.class, e -> {
            Optional<BorderData> borderData = this.getBorder(e.getLocation().getWorld().getName());
            e.redirect(borderData.map(BorderData::getBorder).filter(border -> !border.isBounding(e.getLocation().getX(), e.getLocation().getZ())).filter(border -> !e.getPlayer().hasPermission("chunkyborder.bypass.move")).filter(border -> !this.getPlayerData(e.getPlayer().getUUID()).isBypassing()).map(border -> {
                Vector2 center = Vector2.of((double)((BorderData)borderData.get()).getCenterX(), (double)((BorderData)borderData.get()).getCenterZ());
                World world = e.getLocation().getWorld();
                Vector3 locationVector = e.getLocation().toVector();
                Vector2 to = Vector2.of((double)locationVector.getX(), (double)locationVector.getZ());
                ArrayList<Vector2> intersections = new ArrayList<Vector2>();
                if (border instanceof AbstractPolygon) {
                    AbstractPolygon polygon = (AbstractPolygon)border;
                    List points = polygon.points();
                    int size = points.size();
                    for (int i = 0; i < size; ++i) {
                        Vector2 p1 = (Vector2)points.get(i);
                        Vector2 p2 = (Vector2)points.get(i == size - 1 ? 0 : i + 1);
                        ShapeUtil.intersection((double)center.getX(), (double)center.getZ(), (double)to.getX(), (double)to.getZ(), (double)p1.getX(), (double)p1.getZ(), (double)p2.getX(), (double)p2.getZ()).ifPresent(intersections::add);
                    }
                } else if (border instanceof AbstractEllipse) {
                    AbstractEllipse ellipse = (AbstractEllipse)border;
                    Vector2 radii = ellipse.radii();
                    double angle = Math.atan2(to.getZ() - center.getX(), to.getX() - center.getZ());
                    intersections.add(ShapeUtil.pointOnEllipse((double)center.getX(), (double)center.getZ(), (double)radii.getX(), (double)radii.getZ(), (double)angle));
                }
                if (intersections.isEmpty()) {
                    return world.getSpawn();
                }
                Vector3 centerDirection = new Vector3(center.getX() - to.getX(), 0.0, center.getZ() - to.getZ()).normalize().multiply(3.0);
                Vector2 closest = (Vector2)intersections.get(0);
                double shortestDistance = Double.MAX_VALUE;
                for (Vector2 intersection : intersections) {
                    double distance = to.distanceSquared(intersection);
                    if (!(distance < shortestDistance) || !border.isBounding(intersection.getX() + centerDirection.getX(), intersection.getZ() + centerDirection.getZ())) continue;
                    closest = intersection;
                    shortestDistance = distance;
                }
                if (shortestDistance == Double.MAX_VALUE) {
                    return world.getSpawn();
                }
                Location insideBorder = new Location(world, closest.getX(), 0.0, closest.getZ());
                insideBorder.add(centerDirection);
                insideBorder.setDirection(centerDirection);
                int elevation = world.getElevation((int)insideBorder.getX(), (int)insideBorder.getZ());
                if (elevation >= world.getMaxElevation()) {
                    return world.getSpawn();
                }
                insideBorder.setY((double)elevation);
                Player player = e.getPlayer();
                if (this.config.useActionBar()) {
                    player.sendActionBar("custom_border_message");
                } else {
                    player.sendMessage("custom_border_message", new Object[0]);
                }
                this.getPlayerData(player.getUUID()).setLastLocation(insideBorder);
                return insideBorder;
            }).orElse(null));
        });
        eventBus.subscribe(WorldLoadEvent.class, e -> this.getBorder(e.world().getName()).map(BorderData::getBorder).ifPresent(border -> this.mapIntegrations.forEach(mapIntegration -> mapIntegration.addShapeMarker(e.world(), (Shape)border))));
        eventBus.subscribe(WorldUnloadEvent.class, e -> this.getBorder(e.world().getName()).map(BorderData::getBorder).ifPresent(border -> this.mapIntegrations.forEach(mapIntegration -> mapIntegration.removeShapeMarker(e.world()))));
        eventBus.subscribe(CreatureSpawnEvent.class, e -> e.setCancelled(this.getBorder(e.getLocation().getWorld().getName()).map(BorderData::getBorder).map(border -> !border.isBounding(e.getLocation().getX(), e.getLocation().getZ())).orElse(false)));
        eventBus.subscribe(BlockPlaceEvent.class, e -> {
            Location location = e.getLocation();
            e.setCancelled(this.getBorder(location.getWorld().getName()).map(BorderData::getBorder).map(border -> {
                double z;
                double x = (double)((int)location.getX()) + 0.5;
                return !border.isBounding(x, z = (double)((int)location.getZ()) + 0.5) && !e.getPlayer().hasPermission("chunkyborder.bypass.place");
            }).orElse(false));
        });
        eventBus.subscribe(PlayerQuitEvent.class, e -> this.players.remove(e.player().getUUID()));
    }

    public boolean hasCompatibleChunkyVersion() {
        Version currentVersion = this.chunky.getVersion();
        Version requiredVersion = this.getTargetVersion();
        return currentVersion.isValid() && requiredVersion.isValid() && currentVersion.isHigherThanOrEqualTo(requiredVersion);
    }

    private Version loadVersion() {
        Version version;
        block8: {
            InputStream input = this.getClass().getClassLoader().getResourceAsStream("version.properties");
            try {
                Properties properties = new Properties();
                properties.load(input);
                version = new Version(properties.getProperty("version"));
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Version.INVALID;
                }
            }
            input.close();
        }
        return version;
    }

    private Version loadTargetVersion() {
        Version version;
        block8: {
            InputStream input = this.getClass().getClassLoader().getResourceAsStream("version.properties");
            try {
                Properties properties = new Properties();
                properties.load(input);
                version = new Version(properties.getProperty("target"));
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Version.INVALID;
                }
            }
            input.close();
        }
        return version;
    }

    public Chunky getChunky() {
        return this.chunky;
    }

    public Config getConfig() {
        return this.config;
    }

    public MapIntegrationLoader getMapIntegrationLoader() {
        return this.mapIntegrationLoader;
    }

    public List<MapIntegration> getMapIntegrations() {
        return this.mapIntegrations;
    }

    public Optional<BorderData> getBorder(String world) {
        return Optional.ofNullable(this.borders.get(world));
    }

    public Map<String, BorderData> getBorders() {
        return this.borders;
    }

    public Map<UUID, PlayerData> getPlayers() {
        return this.players;
    }

    public PlayerData getPlayerData(UUID uuid) {
        return this.players.computeIfAbsent(uuid, x -> new PlayerData(uuid));
    }

    public Version getVersion() {
        return this.version;
    }

    public Version getTargetVersion() {
        return this.targetVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, BorderData> loadBorders() {
        try (FileReader fileReader = new FileReader(new File(this.config.getDirectory().toFile(), "borders.json"));){
            Map loadedBorders = (Map)new Gson().fromJson((Reader)fileReader, new TypeToken<Map<String, BorderData>>(){}.getType());
            if (loadedBorders == null) return new HashMap<String, BorderData>();
            Map map = loadedBorders;
            return map;
        }
        catch (IOException e) {
            LOGGER.warn(() -> Translator.translate((String)"border_load_failed", (Object[])new Object[0]));
        }
        return new HashMap<String, BorderData>();
    }

    public void saveBorders() {
        if (this.borders == null) {
            return;
        }
        try (FileWriter fileWriter = new FileWriter(new File(this.config.getDirectory().toFile(), "borders.json"));){
            fileWriter.write(new GsonBuilder().setPrettyPrinting().create().toJson(this.borders));
        }
        catch (IOException e) {
            LOGGER.warn(() -> Translator.translate((String)"border_save_failed", (Object[])new Object[0]));
        }
    }

    public void addBorders() {
        for (BorderData border : this.borders.values()) {
            Optional world;
            if (border.getWorld() == null || (world = this.chunky.getServer().getWorld(border.getWorld())).isEmpty()) continue;
            this.mapIntegrations.forEach(mapIntegration -> mapIntegration.addShapeMarker((World)world.get(), border.getBorder()));
        }
    }
}

