/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.S2CPlayChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.joml.Vector3f;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.ChunkyProvider;
import org.popcraft.chunky.platform.FabricPlayer;
import org.popcraft.chunky.platform.FabricWorld;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Vector3;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.util.Translator;
import org.popcraft.chunkyborder.BorderCheckTask;
import org.popcraft.chunkyborder.BorderData;
import org.popcraft.chunkyborder.BorderInitializationTask;
import org.popcraft.chunkyborder.ChunkyBorder;
import org.popcraft.chunkyborder.FabricConfig;
import org.popcraft.chunkyborder.FabricMapIntegrationLoader;
import org.popcraft.chunkyborder.command.BorderCommand;
import org.popcraft.chunkyborder.event.border.BorderChangeEvent;
import org.popcraft.chunkyborder.util.BorderColor;
import org.popcraft.chunkyborder.util.Particles;
import org.popcraft.chunkyborder.util.PluginMessage;

public class ChunkyBorderFabric
implements ModInitializer {
    private static final class_2960 PLAY_BORDER_PACKET_ID = new class_2960("chunky", "border");
    private ChunkyBorder chunkyBorder;
    private boolean registered;

    public void onInitialize() {
        Chunky chunky = ChunkyProvider.get();
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("chunkyborder/config.json");
        FabricConfig config = new FabricConfig(configPath);
        FabricMapIntegrationLoader mapIntegrationLoader = new FabricMapIntegrationLoader();
        this.chunkyBorder = new ChunkyBorder(chunky, config, mapIntegrationLoader);
        Translator.addCustomTranslation((String)"custom_border_message", (String)config.message());
        BorderColor.parseColor(config.visualizerColor());
        new BorderInitializationTask(this.chunkyBorder).run();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            for (World world : this.chunkyBorder.getChunky().getServer().getWorlds()) {
                Shape shape = this.chunkyBorder.getBorder(world.getName()).map(BorderData::getBorder).orElse(null);
                this.sendBorderPacket(List.of(handler.field_14140), world, shape);
            }
        });
        S2CPlayChannelEvents.REGISTER.register((handler, sender, server, channels) -> {
            if (!this.registered) {
                this.chunkyBorder.getChunky().getEventBus().subscribe(BorderChangeEvent.class, e -> this.sendBorderPacket(server.method_3760().method_14571(), e.world(), e.shape()));
                this.registered = true;
            }
            if (channels.contains(PLAY_BORDER_PACKET_ID)) {
                this.chunkyBorder.getPlayerData(handler.field_14140.method_5667()).setUsingMod(true);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(minecraftServer -> this.chunkyBorder.disable());
        long checkInterval = Math.max(1L, this.chunkyBorder.getConfig().checkInterval());
        BorderCheckTask borderCheckTask = new BorderCheckTask(this.chunkyBorder);
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if ((long)server.method_3780() % checkInterval == 0L) {
                borderCheckTask.run();
            }
        });
        this.chunkyBorder.getChunky().getCommands().put("border", new BorderCommand(this.chunkyBorder));
        this.startVisualizer();
    }

    private void startVisualizer() {
        boolean visualizerEnabled = this.chunkyBorder.getConfig().visualizerEnabled();
        if (!visualizerEnabled) {
            return;
        }
        int maxRange = this.chunkyBorder.getConfig().visualizerRange();
        Particles.setMaxDistance(maxRange);
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            long tick = server.method_3780();
            server.method_3760().method_14571().forEach(fabricPlayer -> {
                class_3218 serverWorld = fabricPlayer.method_51469();
                FabricWorld world = new FabricWorld(serverWorld);
                FabricPlayer player = new FabricPlayer(fabricPlayer);
                Shape border = this.chunkyBorder.getBorder(world.getName()).map(BorderData::getBorder).orElse(null);
                boolean isUsingMod = this.chunkyBorder.getPlayerData(player.getUUID()).isUsingMod();
                if (border != null && !isUsingMod) {
                    List<Vector3> particleLocations = Particles.at((Player)player, border, (double)(tick % 20L) / 20.0);
                    Vector3f visualizerColor = new Vector3f(BorderColor.getRGB());
                    for (Vector3 location : particleLocations) {
                        class_2338 pos = class_2338.method_49637((double)location.getX(), (double)location.getY(), (double)location.getZ());
                        boolean fullyOccluded = serverWorld.method_8320(pos).method_26216((class_1922)serverWorld, pos) && serverWorld.method_8320(pos.method_10095()).method_26216((class_1922)serverWorld, pos.method_10095()) && serverWorld.method_8320(pos.method_10078()).method_26216((class_1922)serverWorld, pos.method_10078()) && serverWorld.method_8320(pos.method_10072()).method_26216((class_1922)serverWorld, pos.method_10072()) && serverWorld.method_8320(pos.method_10067()).method_26216((class_1922)serverWorld, pos.method_10067());
                        if (fullyOccluded) continue;
                        serverWorld.method_14166(fabricPlayer, (class_2394)new class_2390(visualizerColor, 1.0f), false, location.getX(), location.getY(), location.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            });
        });
    }

    private void sendBorderPacket(Collection<class_3222> players, World world, Shape shape) {
        class_2540 data;
        try {
            data = new class_2540(Unpooled.wrappedBuffer((byte[])PluginMessage.writeBorderData(world, shape)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        for (class_3222 player : players) {
            player.field_13987.method_14364((class_2596)new class_2658(PLAY_BORDER_PACKET_ID, data));
        }
    }
}

