/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.popcraft.chunkyborder.FabricConfig;
import org.popcraft.chunkyborder.platform.Config;
import org.popcraft.chunkyborder.shape.BorderShape;
import org.popcraft.chunkyborder.shape.EllipseBorderShape;
import org.popcraft.chunkyborder.shape.PolygonBorderShape;
import org.popcraft.chunkyborder.util.BorderColor;

@Environment(value=EnvType.CLIENT)
public class ChunkyBorderFabricClient
implements ClientModInitializer {
    private static final class_2960 PLAY_BORDER_PACKET_ID = new class_2960("chunky", "border");
    private static final Map<class_2960, BorderShape> borderShapes = new ConcurrentHashMap<class_2960, BorderShape>();
    private static Config config;

    public static void setBorderShape(String id, BorderShape borderShape) {
        class_2960 identifier = class_2960.method_12829((String)id);
        if (identifier != null) {
            if (borderShape == null) {
                borderShapes.remove(identifier);
            } else {
                borderShapes.put(identifier, borderShape);
            }
        }
    }

    public static BorderShape getBorderShape(class_2960 identifier) {
        return borderShapes.get(identifier);
    }

    public static Config getConfig() {
        return config;
    }

    public static void setConfig(Config config) {
        ChunkyBorderFabricClient.config = config;
    }

    public void onInitializeClient() {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("chunkyborder/config.json");
        ChunkyBorderFabricClient.setConfig(new FabricConfig(configPath));
        BorderColor.parseColor(config.visualizerColor());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PLAY_BORDER_PACKET_ID, (client, handler, buf, responseSender) -> {
            try (ByteBufInputStream in = new ByteBufInputStream((ByteBuf)buf);
                 DataInputStream data = new DataInputStream((InputStream)in);){
                int version = data.readInt();
                String worldKey = data.readUTF();
                if (version != 0) return;
                byte type = data.readByte();
                switch (type) {
                    case 1: {
                        int numPoints = data.readInt();
                        double[] pointsX = new double[numPoints];
                        double[] pointsZ = new double[numPoints];
                        for (int i = 0; i < numPoints; ++i) {
                            pointsX[i] = data.readDouble();
                            pointsZ[i] = data.readDouble();
                        }
                        ChunkyBorderFabricClient.setBorderShape(worldKey, new PolygonBorderShape(pointsX, pointsZ));
                        return;
                    }
                    case 2: {
                        double centerX = data.readDouble();
                        double centerZ = data.readDouble();
                        double radiusX = data.readDouble();
                        double radiusZ = data.readDouble();
                        ChunkyBorderFabricClient.setBorderShape(worldKey, new EllipseBorderShape(centerX, centerZ, radiusX, radiusZ));
                        return;
                    }
                    default: {
                        ChunkyBorderFabricClient.setBorderShape(worldKey, null);
                        return;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

