/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.popcraft.chunkyborder.platform.Config;

public class FabricConfig
implements Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path savePath;
    private ConfigModel configModel = new ConfigModel();

    public FabricConfig(Path savePath) {
        this.savePath = savePath;
        this.reload();
    }

    @Override
    public Path getDirectory() {
        return this.savePath.getParent();
    }

    @Override
    public int version() {
        return Optional.ofNullable(this.configModel.version).orElse(0);
    }

    @Override
    public long checkInterval() {
        return Optional.ofNullable(this.configModel.borderOptions.checkInterval).orElse(20).intValue();
    }

    @Override
    public String message() {
        return Optional.ofNullable(this.configModel.borderOptions.message).orElse("&cYou have reached the edge of this world.");
    }

    @Override
    public boolean useActionBar() {
        return Optional.ofNullable(this.configModel.borderOptions.useActionBar).orElse(true);
    }

    @Override
    public String effect() {
        return Optional.ofNullable(this.configModel.borderOptions.effect).orElse("2003");
    }

    @Override
    public String sound() {
        return Optional.ofNullable(this.configModel.borderOptions.sound).orElse("entity.enderman.teleport");
    }

    @Override
    public boolean preventMobSpawns() {
        return Optional.ofNullable(this.configModel.borderOptions.preventMobSpawns).orElse(false);
    }

    @Override
    public boolean preventEnderpearl() {
        return Optional.ofNullable(this.configModel.borderOptions.preventEnderpearl).orElse(false);
    }

    @Override
    public boolean preventChorusFruit() {
        return Optional.ofNullable(this.configModel.borderOptions.preventChorusFruit).orElse(false);
    }

    @Override
    public boolean visualizerEnabled() {
        return Optional.ofNullable(this.configModel.borderOptions.visualizerEnabled).orElse(false);
    }

    @Override
    public int visualizerRange() {
        return Optional.ofNullable(this.configModel.borderOptions.visualizerRange).orElse(8);
    }

    @Override
    public String visualizerColor() {
        return Optional.ofNullable(this.configModel.borderOptions.visualizerColor).orElse("20A0FF");
    }

    @Override
    public boolean blueMapEnabled() {
        return this.configModel.mapOptions.enable.getOrDefault("bluemap", true);
    }

    @Override
    public boolean dynmapEnabled() {
        return this.configModel.mapOptions.enable.getOrDefault("dynmap", true);
    }

    @Override
    public boolean pl3xmapEnabled() {
        return this.configModel.mapOptions.enable.getOrDefault("pl3xmap", true);
    }

    @Override
    public boolean squaremapEnabled() {
        return this.configModel.mapOptions.enable.getOrDefault("squaremap", true);
    }

    @Override
    public String label() {
        return Optional.ofNullable(this.configModel.mapOptions.label).orElse("World Border");
    }

    @Override
    public boolean hideByDefault() {
        return Optional.ofNullable(this.configModel.mapOptions.hideByDefault).orElse(false);
    }

    @Override
    public String color() {
        return Optional.ofNullable(this.configModel.mapOptions.color).orElse("FF0000");
    }

    @Override
    public int weight() {
        return Optional.ofNullable(this.configModel.mapOptions.weight).orElse(3);
    }

    @Override
    public int priority() {
        return Optional.ofNullable(this.configModel.mapOptions.priority).orElse(0);
    }

    @Override
    public void reload() {
        if (!Files.exists(this.savePath, new LinkOption[0])) {
            this.save();
        }
        try (BufferedReader reader = Files.newBufferedReader(this.savePath);){
            this.configModel = (ConfigModel)GSON.fromJson((Reader)reader, ConfigModel.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void save() {
        try {
            Files.createDirectories(this.savePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.savePath, new OpenOption[0]);){
            GSON.toJson((Object)this.configModel, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ConfigModel {
        private Integer version = 1;
        private BorderOptions borderOptions = new BorderOptions();
        private MapOptions mapOptions = new MapOptions(List.of("bluemap", "dynmap", "squaremap"));

        private ConfigModel() {
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public BorderOptions getBorderOptions() {
            return this.borderOptions;
        }

        public void setBorderOptions(BorderOptions borderOptions) {
            this.borderOptions = borderOptions;
        }

        public MapOptions getMapOptions() {
            return this.mapOptions;
        }

        public void setMapOptions(MapOptions mapOptions) {
            this.mapOptions = mapOptions;
        }
    }

    private static class BorderOptions {
        private Integer checkInterval = 20;
        private String message = "&cYou have reached the edge of this world.";
        private Boolean useActionBar = true;
        private String effect = "2003";
        private String sound = "entity.enderman.teleport";
        private Boolean preventMobSpawns = false;
        private Boolean preventEnderpearl = false;
        private Boolean preventChorusFruit = false;
        private Boolean visualizerEnabled = false;
        private Integer visualizerRange = 8;
        private String visualizerColor = "20A0FF";

        private BorderOptions() {
        }

        public Integer getCheckInterval() {
            return this.checkInterval;
        }

        public void setCheckInterval(Integer checkInterval) {
            this.checkInterval = checkInterval;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getUseActionBar() {
            return this.useActionBar;
        }

        public void setUseActionBar(Boolean useActionBar) {
            this.useActionBar = useActionBar;
        }

        public String getEffect() {
            return this.effect;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }

        public String getSound() {
            return this.sound;
        }

        public void setSound(String sound) {
            this.sound = sound;
        }

        public Boolean getPreventMobSpawns() {
            return this.preventMobSpawns;
        }

        public void setPreventMobSpawns(Boolean preventMobSpawns) {
            this.preventMobSpawns = preventMobSpawns;
        }

        public Boolean getPreventEnderpearl() {
            return this.preventEnderpearl;
        }

        public void setPreventEnderpearl(Boolean preventEnderpearl) {
            this.preventEnderpearl = preventEnderpearl;
        }

        public Boolean getPreventChorusFruit() {
            return this.preventChorusFruit;
        }

        public void setPreventChorusFruit(Boolean preventChorusFruit) {
            this.preventChorusFruit = preventChorusFruit;
        }

        public Boolean getVisualizerEnabled() {
            return this.visualizerEnabled;
        }

        public void setVisualizerEnabled(Boolean visualizerEnabled) {
            this.visualizerEnabled = visualizerEnabled;
        }

        public Integer getVisualizerRange() {
            return this.visualizerRange;
        }

        public void setVisualizerRange(Integer visualizerRange) {
            this.visualizerRange = visualizerRange;
        }

        public String getVisualizerColor() {
            return this.visualizerColor;
        }

        public void setVisualizerColor(String visualizerColor) {
            this.visualizerColor = visualizerColor;
        }
    }

    private static class MapOptions {
        private Map<String, Boolean> enable = new HashMap<String, Boolean>();
        private String label = "World Border";
        private Boolean hideByDefault = false;
        private String color = "FF0000";
        private Integer weight = 3;
        private Integer priority = 0;

        public MapOptions() {
        }

        public MapOptions(List<String> enabled) {
            for (String toEnable : enabled) {
                this.enable.put(toEnable, true);
            }
        }

        public Map<String, Boolean> getEnable() {
            return this.enable;
        }

        public void setEnable(Map<String, Boolean> enable) {
            this.enable = enable;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public Boolean getHideByDefault() {
            return this.hideByDefault;
        }

        public void setHideByDefault(Boolean hideByDefault) {
            this.hideByDefault = hideByDefault;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public Integer getWeight() {
            return this.weight;
        }

        public void setWeight(Integer weight) {
            this.weight = weight;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }
    }
}

