/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunkyborder.BorderData;
import org.popcraft.chunkyborder.ChunkyBorder;

public class LoadCommand
implements ChunkyCommand {
    private final ChunkyBorder chunkyBorder;

    public LoadCommand(ChunkyBorder chunkyBorder) {
        this.chunkyBorder = chunkyBorder;
    }

    public void execute(Sender sender, CommandArguments arguments) {
        Selection selection;
        World world;
        Map<String, BorderData> borders;
        BorderData currentBorder;
        Chunky chunky = this.chunkyBorder.getChunky();
        if (arguments.size() > 1) {
            Optional world2 = arguments.next().flatMap(arg -> Input.tryWorld((Chunky)chunky, (String)arg));
            if (world2.isPresent()) {
                chunky.getSelection().world((World)world2.get());
            } else {
                sender.sendMessage("help_border", new Object[0]);
                return;
            }
        }
        if ((currentBorder = (borders = this.chunkyBorder.getBorders()).get((world = (selection = chunky.getSelection().build()).world()).getName())) != null) {
            Selection.Builder newSelection = chunky.getSelection();
            newSelection.world(world);
            newSelection.shape(currentBorder.getShape());
            newSelection.center(currentBorder.getCenterX(), currentBorder.getCenterZ());
            newSelection.radiusX(currentBorder.getRadiusX());
            newSelection.radiusZ(currentBorder.getRadiusZ());
            sender.sendMessagePrefixed("format_border_load", new Object[]{world.getName()});
        } else {
            sender.sendMessagePrefixed("format_border_no_border", new Object[]{world.getName()});
        }
    }

    public List<String> suggestions(CommandArguments commandArguments) {
        if (commandArguments.size() == 2) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunkyBorder.getChunky().getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        return List.of();
    }
}

