/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.integration;

import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.ShapeMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.ArrayList;
import java.util.List;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunkyborder.ChunkyBorderProvider;
import org.popcraft.chunkyborder.integration.AbstractMapIntegration;

public class BlueMapIntegration
extends AbstractMapIntegration {
    private static final String MARKER_SET_ID = "chunky";
    private final List<Runnable> pendingMarkers = new ArrayList<Runnable>();
    private BlueMapAPI blueMapAPI;
    private boolean reloading;

    public BlueMapIntegration() {
        BlueMapAPI.onEnable(blueMap -> {
            this.blueMapAPI = blueMap;
            this.pendingMarkers.forEach(Runnable::run);
            this.pendingMarkers.clear();
            if (this.reloading) {
                ChunkyBorderProvider.get().addBorders();
            }
        });
        BlueMapAPI.onDisable(blueMap -> {
            this.blueMapAPI = null;
            this.reloading = true;
        });
    }

    @Override
    public void addShapeMarker(World world, Shape shape) {
        de.bluecolored.bluemap.api.math.Shape blueShape;
        if (this.blueMapAPI == null) {
            this.pendingMarkers.add(() -> this.addShapeMarker(world, shape));
            return;
        }
        MarkerSet markerSet = MarkerSet.builder().label(this.label).build();
        if (shape instanceof AbstractPolygon) {
            AbstractPolygon polygon = (AbstractPolygon)shape;
            Shape.Builder shapeBuilder = de.bluecolored.bluemap.api.math.Shape.builder();
            polygon.points().forEach(p -> shapeBuilder.addPoint(Vector2d.from((double)p.getX(), (double)p.getZ())));
            blueShape = shapeBuilder.build();
        } else if (shape instanceof AbstractEllipse) {
            AbstractEllipse ellipse = (AbstractEllipse)shape;
            Vector2 center = ellipse.center();
            Vector2 radii = ellipse.radii();
            Vector2d centerPos = Vector2d.from((double)center.getX(), (double)center.getZ());
            blueShape = de.bluecolored.bluemap.api.math.Shape.createEllipse((Vector2d)centerPos, (double)radii.getX(), (double)radii.getZ(), (int)100);
        } else {
            return;
        }
        ShapeMarker marker = ((ShapeMarker.Builder)ShapeMarker.builder().label(this.label)).shape(blueShape, (float)world.getSeaLevel()).lineColor(new Color(this.color, 1.0f)).fillColor(new Color(0)).lineWidth(this.weight).depthTestEnabled(false).build();
        markerSet.getMarkers().put(MARKER_SET_ID, marker);
        this.blueMapAPI.getWorld((Object)world.getName()).map(BlueMapWorld::getMaps).ifPresent(maps -> maps.forEach(map -> map.getMarkerSets().put(MARKER_SET_ID, markerSet)));
    }

    @Override
    public void removeShapeMarker(World world) {
        if (this.blueMapAPI == null) {
            return;
        }
        this.blueMapAPI.getWorld((Object)world.getName()).map(BlueMapWorld::getMaps).ifPresent(maps -> maps.forEach(map -> map.getMarkerSets().remove(MARKER_SET_ID)));
    }

    @Override
    public void removeAllShapeMarkers() {
        if (this.blueMapAPI == null) {
            return;
        }
        this.blueMapAPI.getMaps().forEach(map -> map.getMarkerSets().remove(MARKER_SET_ID));
    }
}

