/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.integration;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.layer.Layer;
import net.pl3x.map.core.markers.layer.SimpleLayer;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.World;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Circle;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunkyborder.integration.AbstractMapIntegration;

public class Pl3xMapIntegration
extends AbstractMapIntegration {
    private static final String CHUNKY_KEY = "chunky";
    private final Map<World, Layer> defaultLayers = new HashMap<World, Layer>();
    private boolean hideByDefault;
    private int priority;
    private Options markerOptions;

    @Override
    public void addShapeMarker(org.popcraft.chunky.platform.World world, Shape shape) {
        this.getWorld(world).ifPresent(pl3xmapWorld -> {
            Object marker;
            if (shape instanceof AbstractPolygon) {
                AbstractPolygon polygon = (AbstractPolygon)shape;
                marker = Marker.polyline((String)CHUNKY_KEY, polygon.points().stream().map(point -> Point.of((double)point.getX(), (double)point.getZ())).toList()).loop();
            } else if (shape instanceof AbstractEllipse) {
                AbstractEllipse ellipse = (AbstractEllipse)shape;
                Vector2 center = ellipse.center();
                Vector2 radii = ellipse.radii();
                marker = ellipse instanceof Circle ? Marker.circle((String)CHUNKY_KEY, (double)center.getX(), (double)center.getZ(), (double)radii.getX()) : Marker.ellipse((String)CHUNKY_KEY, (double)center.getX(), (double)center.getZ(), (double)radii.getX(), (double)radii.getZ());
            } else {
                return;
            }
            this.getLayer((World)pl3xmapWorld).clearMarkers().addMarker(marker.setOptions(this.markerOptions));
        });
    }

    @Override
    public void removeShapeMarker(org.popcraft.chunky.platform.World world) {
        this.getWorld(world).ifPresent(this::resetLayer);
    }

    @Override
    public void removeAllShapeMarkers() {
        Pl3xMap.api().getWorldRegistry().values().forEach(this::resetLayer);
    }

    @Override
    public void setOptions(String label, String color, boolean hideByDefault, int priority, int weight) {
        super.setOptions(label, color, hideByDefault, priority, weight);
        this.hideByDefault = hideByDefault;
        this.priority = priority;
        this.markerOptions = Options.builder().strokeWeight(Integer.valueOf(this.weight)).strokeColor(Integer.valueOf(Colors.setAlpha((int)255, (int)this.color))).fill(Boolean.valueOf(false)).tooltipContent(this.label).tooltipSticky(Boolean.valueOf(true)).build();
    }

    private SimpleLayer getLayer(World world) {
        Layer chunkyLayer;
        Layer defaultLayer = (Layer)world.getLayerRegistry().unregister("worldborder");
        if (!this.defaultLayers.containsKey(world)) {
            this.defaultLayers.put(world, defaultLayer);
        }
        if ((chunkyLayer = (Layer)world.getLayerRegistry().get(CHUNKY_KEY)) == null) {
            chunkyLayer = new SimpleLayer(CHUNKY_KEY, () -> this.label).setDefaultHidden(this.hideByDefault).setPriority(1).setZIndex(Integer.valueOf(this.priority));
            world.getLayerRegistry().register((Keyed)chunkyLayer);
        }
        return (SimpleLayer)chunkyLayer;
    }

    private void resetLayer(World world) {
        world.getLayerRegistry().unregister(CHUNKY_KEY);
        Layer defaultLayer = this.defaultLayers.get(world);
        if (defaultLayer != null) {
            world.getLayerRegistry().register((Keyed)defaultLayer);
            this.defaultLayers.remove(world);
        }
    }

    private Optional<World> getWorld(org.popcraft.chunky.platform.World world) {
        return Optional.ofNullable((World)Pl3xMap.api().getWorldRegistry().get(world.getName())).filter(World::isEnabled);
    }
}

