/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.shape.ShapeUtil;
import org.popcraft.chunkyborder.ChunkyBorderFabricClient;
import org.popcraft.chunkyborder.shape.BorderShape;
import org.popcraft.chunkyborder.shape.EllipseBorderShape;
import org.popcraft.chunkyborder.shape.PolygonBorderShape;
import org.popcraft.chunkyborder.util.BorderColor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public class WorldRendererMixin {
    @Shadow
    @Final
    private static class_2960 field_4071;
    @Shadow
    @Final
    private class_310 field_4088;
    @Shadow
    private class_638 field_4085;

    @Inject(method={"renderWorldBorder"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderWorldBorder(class_4184 camera, CallbackInfo ci) {
        BorderShape borderShape = ChunkyBorderFabricClient.getBorderShape(this.field_4085.method_44013().method_29177());
        if (borderShape == null) {
            return;
        }
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        double renderDistanceBlocks = (double)this.field_4088.field_1690.method_38521() * 16.0;
        double posX = camera.method_19326().field_1352;
        double posZ = camera.method_19326().field_1350;
        double height = this.field_4088.field_1773.method_32796();
        double distanceInsideBorder = Double.MAX_VALUE;
        if (borderShape instanceof PolygonBorderShape) {
            PolygonBorderShape polygon = (PolygonBorderShape)borderShape;
            double[] pointsX = polygon.getPointsX();
            double[] pointsZ = polygon.getPointsZ();
            for (int i = 0; i < pointsX.length; ++i) {
                double p2z;
                double p1x = pointsX[i];
                double p1z = pointsZ[i];
                double p2x = pointsX[i + 1 == pointsX.length ? 0 : i + 1];
                Vector2 closestPoint = ShapeUtil.closestPointOnLine((double)posX, (double)posZ, (double)p1x, (double)p1z, (double)p2x, (double)(p2z = pointsZ[i + 1 == pointsZ.length ? 0 : i + 1]));
                double distanceToBorder = ShapeUtil.distanceBetweenPoints((double)posX, (double)posZ, (double)closestPoint.getX(), (double)closestPoint.getZ());
                if (!(distanceToBorder < distanceInsideBorder)) continue;
                distanceInsideBorder = distanceToBorder;
            }
        } else if (borderShape instanceof EllipseBorderShape) {
            EllipseBorderShape ellipse = (EllipseBorderShape)borderShape;
            double centerX = ellipse.getCenterX();
            double centerZ = ellipse.getCenterZ();
            double radiusX = ellipse.getRadiusX();
            double radiusZ = ellipse.getRadiusZ();
            double cameraAngle = Math.atan2(radiusX * (posZ - centerZ), radiusZ * (posX - centerX));
            Vector2 pointOnBorder = ShapeUtil.pointOnEllipse((double)centerX, (double)centerZ, (double)radiusX, (double)radiusZ, (double)cameraAngle);
            distanceInsideBorder = ShapeUtil.distanceBetweenPoints((double)posX, (double)posZ, (double)pointOnBorder.getX(), (double)pointOnBorder.getZ());
        }
        if (distanceInsideBorder < renderDistanceBlocks) {
            double alpha = 1.0 - distanceInsideBorder / renderDistanceBlocks;
            alpha = Math.pow(alpha, 4.0);
            alpha = this.clamp(alpha, 0.0, 1.0);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            RenderSystem.setShaderTexture((int)0, (class_2960)field_4071);
            RenderSystem.depthMask((boolean)class_310.method_29611());
            class_4587 matrixStack = RenderSystem.getModelViewStack();
            matrixStack.method_22903();
            RenderSystem.applyModelViewMatrix();
            int color = BorderColor.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)((float)alpha));
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
            RenderSystem.enablePolygonOffset();
            RenderSystem.disableCull();
            float offset = (float)(class_156.method_658() % 3000L) / 3000.0f;
            float textureVertical = (float)(height - class_3532.method_15385((double)camera.method_19326().field_1351));
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            float textureSize = 0.5f;
            if (borderShape instanceof PolygonBorderShape) {
                PolygonBorderShape polygon = (PolygonBorderShape)borderShape;
                double[] pointsX = polygon.getPointsX();
                double[] pointsZ = polygon.getPointsZ();
                block1: for (int i = 0; i < pointsX.length; ++i) {
                    double p2z;
                    double p1x = pointsX[i];
                    double p1z = pointsZ[i];
                    double p2x = pointsX[i + 1 == pointsX.length ? 0 : i + 1];
                    Vector2 closestPoint = ShapeUtil.closestPointOnLine((double)posX, (double)posZ, (double)p1x, (double)p1z, (double)p2x, (double)(p2z = pointsZ[i + 1 == pointsZ.length ? 0 : i + 1]));
                    if (ShapeUtil.distanceBetweenPoints((double)posX, (double)posZ, (double)closestPoint.getX(), (double)closestPoint.getZ()) > renderDistanceBlocks) continue;
                    double dx = p2x - p1x;
                    double dz = p2z - p1z;
                    double distance = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dz, 2.0));
                    double unitX = distance == 0.0 ? 0.0 : dx / distance;
                    double unitZ = distance == 0.0 ? 0.0 : dz / distance;
                    double absUnitX = Math.abs(unitX);
                    double absUnitZ = Math.abs(unitZ);
                    double distanceFromStartX = Math.abs(closestPoint.getX() - p1x);
                    double distanceFromStartZ = Math.abs(closestPoint.getZ() - p1z);
                    long unitsFromStartX = absUnitX == 0.0 ? 0L : (long)(distanceFromStartX / absUnitX);
                    long unitsFromStartZ = absUnitZ == 0.0 ? 0L : (long)(distanceFromStartZ / absUnitZ);
                    double closestPointAdjustedX = p1x + (double)unitsFromStartX * unitX;
                    double closestPointAdjustedZ = p1z + (double)unitsFromStartZ * unitZ;
                    double startX = this.clamp(closestPointAdjustedX - renderDistanceBlocks * unitX, p1x, p2x);
                    double startZ = this.clamp(closestPointAdjustedZ - renderDistanceBlocks * unitZ, p1z, p2z);
                    double stopX = this.clamp(closestPointAdjustedX + renderDistanceBlocks * unitX, p1x, p2x);
                    double stopZ = this.clamp(closestPointAdjustedZ + renderDistanceBlocks * unitZ, p1z, p2z);
                    float texturePosition = 0.0f;
                    double x = startX;
                    double z = startZ;
                    while (true) {
                        double z2;
                        double x2;
                        float textureDistance;
                        double remainingX = stopX - x;
                        double remainingZ = stopZ - z;
                        if (Math.abs(remainingX) <= absUnitX || Math.abs(remainingZ) <= absUnitZ) {
                            float remainingDistance = (float)Math.sqrt(Math.pow(remainingX, 2.0) + Math.pow(remainingZ, 2.0));
                            textureDistance = remainingDistance * 0.5f;
                            x2 = x + remainingX;
                            z2 = z + remainingZ;
                            this.addWall(bufferBuilder, height, posX, posZ, x, z, x2, z2, offset, texturePosition, textureDistance, textureVertical);
                            continue block1;
                        }
                        textureDistance = 0.5f;
                        x2 = x + unitX;
                        z2 = z + unitZ;
                        this.addWall(bufferBuilder, height, posX, posZ, x, z, x2, z2, offset, texturePosition, textureDistance, textureVertical);
                        x += unitX;
                        z += unitZ;
                        texturePosition += 0.5f;
                    }
                }
            } else if (borderShape instanceof EllipseBorderShape) {
                double maxAngle;
                double minAngle;
                EllipseBorderShape ellipse = (EllipseBorderShape)borderShape;
                double centerX = ellipse.getCenterX();
                double centerZ = ellipse.getCenterZ();
                double radiusX = ellipse.getRadiusX();
                double radiusZ = ellipse.getRadiusZ();
                double radius = Math.min(radiusX, radiusZ);
                double angle = Math.acos((2.0 * radius * radius - 1.0) / (2.0 * radius * radius));
                if (radius > renderDistanceBlocks) {
                    double cameraAngle = Math.atan2(radiusX * (posZ - centerZ), radiusZ * (posX - centerX));
                    double cameraAngleAdjusted = Math.floor(cameraAngle / angle) * angle;
                    double arcAngle = renderDistanceBlocks / radius;
                    minAngle = cameraAngleAdjusted - arcAngle;
                    maxAngle = cameraAngleAdjusted + arcAngle;
                } else {
                    minAngle = 0.0;
                    maxAngle = Math.PI * 2;
                }
                float texturePosition = 0.0f;
                double a = minAngle;
                double b = minAngle + angle;
                while (a < maxAngle) {
                    float textureHorizontal;
                    Vector2 pointB;
                    Vector2 pointA = ShapeUtil.pointOnEllipse((double)centerX, (double)centerZ, (double)radiusX, (double)radiusZ, (double)a);
                    if (b >= maxAngle) {
                        pointB = ShapeUtil.pointOnEllipse((double)centerX, (double)centerZ, (double)radiusX, (double)radiusZ, (double)maxAngle);
                        float remainingDistance = (float)ShapeUtil.distanceBetweenPoints((double)pointA.getX(), (double)pointA.getZ(), (double)pointB.getX(), (double)pointB.getZ());
                        textureHorizontal = remainingDistance * 0.5f;
                        this.addWall(bufferBuilder, height, posX, posZ, pointB.getX(), pointB.getZ(), pointA.getX(), pointA.getZ(), offset, 0.0f, textureHorizontal, textureVertical);
                        break;
                    }
                    pointB = ShapeUtil.pointOnEllipse((double)centerX, (double)centerZ, (double)radiusX, (double)radiusZ, (double)b);
                    textureHorizontal = 0.5f;
                    this.addWall(bufferBuilder, height, posX, posZ, pointB.getX(), pointB.getZ(), pointA.getX(), pointA.getZ(), offset, 0.0f, textureHorizontal, textureVertical);
                    a += angle;
                    b += angle;
                }
            }
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            RenderSystem.enableCull();
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            matrixStack.method_22909();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        ci.cancel();
    }

    private double clamp(double value, double p1, double p2) {
        double min = Math.min(p1, p2);
        double max = Math.max(p1, p2);
        return Math.max(min, Math.min(max, value));
    }

    private void addWall(class_287 bufferBuilder, double height, double posX, double posZ, double x1, double z1, double x2, double z2, float offset, float texturePosition, float textureHorizontal, float textureVertical) {
        this.addVertex(bufferBuilder, -height, posX, posZ, x1, z1, offset + texturePosition, offset + textureVertical);
        this.addVertex(bufferBuilder, -height, posX, posZ, x2, z2, offset + texturePosition + textureHorizontal, offset + textureVertical);
        this.addVertex(bufferBuilder, height, posX, posZ, x2, z2, offset + texturePosition + textureHorizontal, offset);
        this.addVertex(bufferBuilder, height, posX, posZ, x1, z1, offset + texturePosition, offset);
    }

    private void addVertex(class_287 bufferBuilder, double height, double x1, double z1, double x2, double z2, float u, float v) {
        bufferBuilder.method_22912(x2 - x1, height, z2 - z1).method_22913(u, v).method_1344();
    }
}

