/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Shape;

public class PluginMessage {
    public static byte[] writeBorderData(World world, Shape shape) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream data = new DataOutputStream(out);){
                data.writeInt(0);
                data.writeUTF(world.getKey());
                if (shape instanceof AbstractPolygon) {
                    AbstractPolygon polygon = (AbstractPolygon)shape;
                    data.writeByte(1);
                    List points = polygon.points();
                    data.writeInt(points.size());
                    for (Vector2 point : points) {
                        data.writeDouble(point.getX());
                        data.writeDouble(point.getZ());
                    }
                } else if (shape instanceof AbstractEllipse) {
                    AbstractEllipse ellipse = (AbstractEllipse)shape;
                    data.writeByte(2);
                    Vector2 center = ellipse.center();
                    Vector2 radii = ellipse.radii();
                    data.writeDouble(center.getX());
                    data.writeDouble(center.getZ());
                    data.writeDouble(radii.getX());
                    data.writeDouble(radii.getZ());
                } else {
                    data.writeByte(0);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }
}

