/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.villager;

import com.blamejared.crafttweaker.api.action.villager.ActionTradeBase;
import com.blamejared.crafttweaker.api.villager.ITradeRemover;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3852;
import net.minecraft.class_3853;

public class ActionRemoveTrade
extends ActionTradeBase {
    private final ITradeRemover tradeRemover;
    private final List<class_3853.class_1652> removed;

    public ActionRemoveTrade(class_3852 profession, int level, ITradeRemover tradeRemover) {
        super(profession, level);
        this.tradeRemover = tradeRemover;
        this.removed = new ArrayList<class_3853.class_1652>();
    }

    @Override
    public void apply() {
        List<class_3853.class_1652> tradeList = this.getTradeList();
        this.apply(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void apply(List<class_3853.class_1652> tradeList) {
        tradeList.forEach(iTrade -> {
            if (this.tradeRemover.shouldRemove((class_3853.class_1652)iTrade)) {
                this.removed.add((class_3853.class_1652)iTrade);
            }
        });
        tradeList.removeAll(this.removed);
    }

    @Override
    public String describe() {
        return String.format("Removing Villager trade for Profession: '%s' and Level: '%s'", this.profession.toString(), this.level);
    }

    @Override
    public void undo() {
        List<class_3853.class_1652> tradeList = this.getTradeList();
        this.undo(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void undo(List<class_3853.class_1652> tradeList) {
        tradeList.addAll(this.removed);
    }

    @Override
    public String describeUndo() {
        return String.format("Undoing removal of Villager trade for Profession: '%s' and Level: '%s'", this.profession.toString(), this.level);
    }
}

