/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.item.ActionSetFood;
import com.blamejared.crafttweaker.api.action.item.ActionSetItemProperty;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStackConstants;
import com.blamejared.crafttweaker.api.util.AttributeUtil;
import com.blamejared.crafttweaker.api.util.EnchantmentUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessItem;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_7923;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.IItemStack")
@Document(value="vanilla/api/item/IItemStack")
public interface IItemStack
extends IIngredient,
IIngredientWithAmount {
    @ZenCodeType.Field
    public static final String CRAFTTWEAKER_DATA_KEY = "CraftTweakerData";
    @ZenCodeType.Field
    public static final UUID BASE_ATTACK_DAMAGE_UUID;
    @ZenCodeType.Field
    public static final UUID BASE_ATTACK_SPEED_UUID;

    public static IItemStack empty() {
        return IItemStackConstants.EMPTY_STACK.get();
    }

    public static IItemStack of(class_1799 stack) {
        return Services.PLATFORM.createItemStack(stack);
    }

    public static IItemStack of(class_1799 stack, boolean mutable) {
        return mutable ? IItemStack.ofMutable(stack) : IItemStack.of(stack);
    }

    public static IItemStack ofMutable(class_1799 stack) {
        return Services.PLATFORM.createItemStackMutable(stack);
    }

    @ZenCodeType.Method
    public IItemStack copy();

    @ZenCodeType.Getter(value="registryName")
    default public class_2960 getRegistryName() {
        return class_7923.field_41178.method_10221((Object)this.getInternal().method_7909());
    }

    @ZenCodeType.Getter(value="owner")
    default public String getOwner() {
        return this.getRegistryName().method_12836();
    }

    @Override
    default public boolean isEmpty() {
        return this.getInternal().method_7960();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="maxStackSize")
    default public int getMaxStackSize() {
        return this.getInternal().method_7909().method_7882();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="maxStackSize")
    default public void setMaxStackSize(int newMaxStackSize) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<Integer>(this, "Max Stack Size", newMaxStackSize, this.getInternal().method_7909().method_7882(), ((AccessItem)this.getInternal().method_7909())::crafttweaker$setMaxStackSize));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="rarity")
    default public class_1814 getRarity() {
        return this.getInternal().method_7932();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="rarity")
    default public void setRarity(class_1814 newRarity) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<class_1814>(this, "Rarity", newRarity, this.getInternal().method_7932(), ((AccessItem)this.getInternal().method_7909())::crafttweaker$setRarity));
    }

    @ZenCodeType.Method
    default public IItemStack withLore(class_2561 ... lore) {
        return this.modify(itemStack -> {
            class_2487 tag = itemStack.method_7911("display");
            if (lore != null && lore.length != 0) {
                class_2499 listtag = new class_2499();
                for (class_2561 component : lore) {
                    listtag.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)component)));
                }
                tag.method_10566("Lore", (class_2520)listtag);
            } else {
                tag.method_10551("Lore");
            }
        });
    }

    @ZenCodeType.Getter(value="displayName")
    default public class_2561 getDisplayName() {
        return this.getInternal().method_7954();
    }

    @ZenCodeType.Method
    default public IItemStack withDisplayName(class_2561 name) {
        return this.modify(itemStack -> itemStack.method_7977(name));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="hoverName")
    default public class_2561 getHoverName() {
        return this.getInternal().method_7964();
    }

    @ZenCodeType.Method
    default public void resetHoverName() {
        this.getInternal().method_7925();
    }

    @ZenCodeType.Getter(value="hasCustomHoverName")
    default public boolean hasDisplayName() {
        return this.getInternal().method_7938();
    }

    @ZenCodeType.Getter(value="hasFoil")
    default public boolean hasFoil() {
        return this.getInternal().method_7958();
    }

    @ZenCodeType.Getter(value="isEnchantable")
    default public boolean isEnchantable() {
        return this.getInternal().method_7923();
    }

    @ZenCodeType.Getter(value="isEnchanted")
    default public boolean isEnchanted() {
        return this.getInternal().method_7942();
    }

    @ZenCodeType.Getter(value="baseRepairCost")
    default public int getBaseRepairCost() {
        return this.getInternal().method_7928();
    }

    @Override
    @ZenCodeType.Getter(value="amount")
    default public int getAmount() {
        return this.getInternal().method_7947();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    default public IItemStack setAmount(int amount) {
        return this.modify(itemStack -> itemStack.method_7939(amount));
    }

    @ZenCodeType.Method
    default public IItemStack grow(@ZenCodeType.OptionalInt(value=1) int amount) {
        return this.setAmount(this.getAmount() + amount);
    }

    @ZenCodeType.Method
    default public IItemStack shrink(@ZenCodeType.OptionalInt(value=1) int amount) {
        return this.setAmount(this.getAmount() - amount);
    }

    @ZenCodeType.Getter(value="stackable")
    default public boolean isStackable() {
        return this.getInternal().method_7946();
    }

    @ZenCodeType.Method
    default public IItemStack withDamage(int damage) {
        return this.modify(itemStack -> itemStack.method_7974(damage));
    }

    @ZenCodeType.Method
    default public IItemStack withAttributeModifier(class_1320 attribute, String uuid, String name, double value, class_1322.class_1323 operation, class_1304[] slotTypes, @ZenCodeType.OptionalBoolean boolean preserveDefaults) {
        return this.withAttributeModifier(attribute, UUID.fromString(uuid), name, value, operation, slotTypes, preserveDefaults);
    }

    @ZenCodeType.Method
    default public IItemStack withAttributeModifier(class_1320 attribute, UUID uuid, String name, double value, class_1322.class_1323 operation, class_1304[] slotTypes, @ZenCodeType.OptionalBoolean boolean preserveDefaults) {
        return this.modify(itemStack -> {
            for (class_1304 slotType : slotTypes) {
                if (preserveDefaults) {
                    AttributeUtil.addAttributeModifier(itemStack, attribute, new class_1322(uuid, name, value, operation), slotType);
                    continue;
                }
                itemStack.method_7916(attribute, new class_1322(uuid, name, value, operation), slotType);
            }
        });
    }

    @ZenCodeType.Method
    default public IItemStack withAttributeModifier(class_1320 attribute, String name, double value, class_1322.class_1323 operation, class_1304[] slotTypes, @ZenCodeType.OptionalBoolean boolean preserveDefaults) {
        return this.modify(itemStack -> {
            for (class_1304 slotType : slotTypes) {
                if (preserveDefaults) {
                    AttributeUtil.addAttributeModifier(itemStack, attribute, new class_1322(name, value, operation), slotType);
                    continue;
                }
                itemStack.method_7916(attribute, new class_1322(name, value, operation), slotType);
            }
        });
    }

    @ZenCodeType.Method
    default public Map<class_1320, List<class_1322>> getAttributes(class_1304 slotType) {
        return this.getInternal().method_7926(slotType).asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, attributeAttributeModifierEntry -> new ArrayList((Collection)attributeAttributeModifierEntry.getValue())));
    }

    @ZenCodeType.Getter(value="damageableItem")
    default public boolean isDamageableItem() {
        return this.getInternal().method_7963();
    }

    @ZenCodeType.Getter(value="damaged")
    default public boolean isDamaged() {
        return this.getInternal().method_7986();
    }

    @ZenCodeType.Getter(value="maxDamage")
    default public int getMaxDamage() {
        return this.getInternal().method_7936();
    }

    @ZenCodeType.Setter(value="maxDamage")
    default public void setMaxDamage(int newMaxDamage) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<Integer>(this, "Max Damage", newMaxDamage, this.getInternal().method_7936(), ((AccessItem)this.getInternal().method_7909())::crafttweaker$setMaxDamage));
    }

    @ZenCodeType.Getter(value="descriptionId")
    default public String getDescriptionId() {
        return this.getInternal().method_7922();
    }

    @ZenCodeType.Method
    default public IItemStack withTag(MapData tag) {
        return this.modify(itemStack -> itemStack.method_7980(tag.getInternal()));
    }

    @ZenCodeType.Method
    default public IItemStack withoutTag() {
        return this.modify(itemStack -> itemStack.method_7980(null));
    }

    @ZenCodeType.Getter(value="hasTag")
    default public boolean hasTag() {
        return this.getInternal().method_7985();
    }

    @ZenCodeType.Getter(value="tag")
    default public @ZenCodeType.Nullable IData getTag() {
        return TagToDataConverter.convert((class_2520)this.getInternal().method_7969());
    }

    @ZenCodeType.Method
    default public IData getOrCreateTag() {
        if (this.getInternal().method_7969() == null) {
            this.getInternal().method_7980(new class_2487());
        }
        return this.getTag();
    }

    @Override
    default public boolean matches(IItemStack stack, boolean ignoreDamage) {
        return ItemStackUtil.areStacksTheSame(this.getInternal(), stack.getInternal(), ignoreDamage, true);
    }

    @Override
    default public String getCommandString() {
        return ItemStackUtil.getCommandString(this.getInternal(), this.isMutable());
    }

    @ZenCodeType.Getter(value="useDuration")
    default public int getUseDuration() {
        return this.getInternal().method_7935();
    }

    @ZenCodeType.Getter(value="useOnRelease")
    default public boolean useOnRelease() {
        return this.getInternal().method_7967();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="food")
    default public @ZenCodeType.Nullable class_4174 getFood() {
        return this.getInternal().method_7909().method_19264();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="food")
    default public void setFood(@ZenCodeType.Nullable class_4174 food) {
        CraftTweakerAPI.apply(new ActionSetFood(this, food, this.getInternal().method_7909().method_19264()));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isEdible")
    default public boolean isEdible() {
        return this.getInternal().method_19267();
    }

    @ZenCodeType.Getter(value="burnTime")
    default public int getBurnTime() {
        return Services.EVENT.getBurnTime(this);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="fireResistant")
    default public boolean isFireResistant() {
        return this.getInternal().method_7909().method_24358();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="fireResistant")
    default public void setFireResistant(boolean fireResistant) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<Boolean>(this, "Fire Resistant", fireResistant, this.getInternal().method_7909().method_24358(), ((AccessItem)this.getInternal().method_7909())::crafttweaker$setFireResistant));
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MOD)
    default public Percentaged<IItemStack> percent(double percentage) {
        return new Percentaged<IItemStack>(this, percentage / 100.0, iItemStack -> iItemStack.getCommandString() + " % " + percentage);
    }

    @ZenCodeType.Caster(implicit=true)
    default public Percentaged<IItemStack> asWeightedItemStack() {
        return this.percent(100.0);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="definition")
    @ZenCodeType.Caster(implicit=true)
    default public class_1792 getDefinition() {
        return this.getInternal().method_7909();
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public class_1935 asItemLike() {
        return this.getInternal().method_7909();
    }

    @ZenCodeType.Method
    public IItemStack asMutable();

    @ZenCodeType.Method
    public IItemStack asImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isImmutable")
    public boolean isImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isMutable")
    default public boolean isMutable() {
        return !this.isImmutable();
    }

    @ZenCodeType.Getter(value="damage")
    default public int getDamage() {
        return this.getInternal().method_7919();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="enchantments")
    default public Map<class_1887, Integer> getEnchantments() {
        return class_1890.method_8222((class_1799)this.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="enchantments")
    default public IItemStack setEnchantments(Map<class_1887, Integer> enchantments) {
        return this.modify(newStack -> EnchantmentUtil.setEnchantments(enchantments, newStack));
    }

    @ZenCodeType.Method
    default public int getEnchantmentLevel(class_1887 enchantment) {
        return this.getEnchantments().getOrDefault(enchantment, 0);
    }

    @ZenCodeType.Method
    default public IItemStack withEnchantment(class_1887 enchantment, @ZenCodeType.OptionalInt(value=1) int level) {
        return this.modify(itemStack -> {
            Map<class_1887, Integer> enchantments = this.getEnchantments();
            enchantments.put(enchantment, level);
            EnchantmentUtil.setEnchantments(enchantments, itemStack);
        });
    }

    @ZenCodeType.Method
    default public IItemStack removeEnchantment(class_1887 enchantment) {
        return this.modify(itemStack -> {
            Map<class_1887, Integer> enchantments = this.getEnchantments();
            enchantments.remove(enchantment);
            EnchantmentUtil.setEnchantments(enchantments, itemStack);
        });
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public class_1799 getInternal();

    @Override
    default public class_1856 asVanillaIngredient() {
        if (this.getInternal().method_7960()) {
            return class_1856.field_9017;
        }
        if (!this.getInternal().method_7985()) {
            return class_1856.method_8101((class_1799[])new class_1799[]{this.getImmutableInternal()});
        }
        return Services.REGISTRY.getIngredientPartialTag(this.getImmutableInternal());
    }

    @ZenCodeType.Method
    default public class_1799 getImmutableInternal() {
        return this.getInternal().method_7972();
    }

    @Override
    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public IIngredientWithAmount asIIngredientWithAmount() {
        return this;
    }

    @Override
    default public IItemStack getIngredient() {
        return this;
    }

    @Override
    default public IData asIData() {
        IData data = IIngredient.super.asIData();
        if (!1.$assertionsDisabled && !(data instanceof MapData)) {
            throw new AssertionError();
        }
        data.put("count", new IntData(this.getAmount()));
        return data;
    }

    public IItemStack modify(Consumer<class_1799> var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        BASE_ATTACK_DAMAGE_UUID = AccessItem.crafttweaker$getBASE_ATTACK_DAMAGE_UUID();
        BASE_ATTACK_SPEED_UUID = AccessItem.crafttweaker$getBASE_ATTACK_SPEED_UUID();
    }
}

