/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.tag.manager.type;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.tag.known.ActionKnownTagAdd;
import com.blamejared.crafttweaker.api.action.tag.known.ActionKnownTagClear;
import com.blamejared.crafttweaker.api.action.tag.known.ActionKnownTagCreate;
import com.blamejared.crafttweaker.api.action.tag.known.ActionKnownTagRemove;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.tag.MutableLoadResult;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/tag/manager/type/KnownTagManager")
@ZenCodeType.Name(value="crafttweaker.api.tag.manager.type.KnownTagManager")
public class KnownTagManager<T>
implements ITagManager<KnownTag<T>> {
    private final class_5321<? extends class_2378<T>> resourceKey;
    private final Class<T> elementClass;
    private final MutableLoadResult<T> backingResult;
    private Map<class_2960, KnownTag<T>> tagCache;

    public KnownTagManager(class_5321<? extends class_2378<T>> resourceKey, Class<T> elementClass) {
        this.resourceKey = resourceKey;
        this.elementClass = elementClass;
        this.backingResult = new MutableLoadResult();
        this.tagCache = new HashMap<class_2960, KnownTag<T>>();
    }

    @Override
    public Optional<Class<?>> elementClass() {
        return Optional.of(this.elementClass);
    }

    @Override
    public class_5321<? extends class_2378<T>> resourceKey() {
        return this.resourceKey;
    }

    @SafeVarargs
    @ZenCodeType.Method
    public final void addElements(KnownTag<T> to, T ... values) {
        if (!this.exists(to)) {
            CraftTweakerAPI.apply(new ActionKnownTagCreate<T>(to));
        }
        CraftTweakerAPI.apply(new ActionKnownTagAdd<T>(to, List.of(values)));
        this.recalculate();
    }

    @Override
    public void addId(KnownTag<T> to, class_2960 ... values) {
        if (!this.exists(to)) {
            CraftTweakerAPI.apply(new ActionKnownTagCreate<T>(to));
        }
        List<Object> actualValues = Arrays.stream(values).map(resourceLocation -> Services.REGISTRY.makeHolder((class_5321<?>)this.resourceKey(), (class_2960)resourceLocation)).map(class_6880::comp_349).map(o -> o).toList();
        CraftTweakerAPI.apply(new ActionKnownTagAdd<Object>(to, actualValues));
        this.recalculate();
    }

    @Override
    @ZenCodeType.Method
    public final void removeId(KnownTag<T> from, class_2960 ... values) {
        if (!this.exists(from)) {
            throw new IllegalArgumentException("Cannot remove elements from empty tag: " + from);
        }
        List<Object> actualValues = Arrays.stream(values).map(resourceLocation -> Services.REGISTRY.makeHolder((class_5321<?>)this.resourceKey(), (class_2960)resourceLocation)).map(class_6880::comp_349).map(o -> o).toList();
        CraftTweakerAPI.apply(new ActionKnownTagRemove<Object>(from, actualValues));
        this.recalculate();
    }

    @Override
    public void clear(KnownTag<T> from) {
        if (!this.exists(from)) {
            throw new IllegalArgumentException("Cannot clear elements of an empty tag: " + from);
        }
        CraftTweakerAPI.apply(new ActionKnownTagClear<T>(from));
        this.recalculate();
    }

    @ZenCodeType.Method
    public List<T> elements(KnownTag<T> of) {
        if (!this.exists(of)) {
            return List.of();
        }
        return this.getInternal(of).stream().map(class_6880::comp_349).collect(Collectors.toList());
    }

    @SafeVarargs
    @ZenCodeType.Method
    public final void removeElements(KnownTag<T> from, T ... values) {
        if (!this.exists(from)) {
            throw new IllegalArgumentException("Cannot remove elements from empty tag: " + from);
        }
        CraftTweakerAPI.apply(new ActionKnownTagRemove<T>(from, List.of(values)));
        this.recalculate();
    }

    @Override
    @ZenCodeType.Method
    public KnownTag<T> tag(String id) {
        return this.tag(new class_2960(id));
    }

    @Override
    @ZenCodeType.Method
    public KnownTag<T> tag(class_2960 id) {
        return this.tagMap().getOrDefault(id, new KnownTag(id, this));
    }

    @Override
    public void recalculate() {
        this.tagCache = this.backingResult.tagMap().keySet().stream().map(id -> Pair.of((Object)id, new KnownTag((class_2960)id, this))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    @Override
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tagMap")
    public Map<class_2960, KnownTag<T>> tagMap() {
        if (this.tagCache.isEmpty()) {
            this.recalculate();
        }
        return this.tagCache;
    }

    @Override
    public Map<class_2960, Collection<class_6880<?>>> internalTags() {
        return (Map)GenericUtil.uncheck(Collections.unmodifiableMap(this.backingResult.tagMap()));
    }

    @Nullable
    public Collection<class_6880<T>> getInternal(KnownTag<T> tag) {
        return this.backingResult.tagMap().get(tag.id());
    }

    @Override
    @Nullable
    public Collection<class_6880<?>> getInternalRaw(KnownTag<T> tag) {
        return (Collection)GenericUtil.uncheck(this.getInternal(tag));
    }

    @Override
    public List<class_2960> tagKeys() {
        return new ArrayList<class_2960>(this.tagMap().keySet());
    }

    @Override
    public <U> void addTag(class_2960 id, Collection<class_6880<U>> tag) {
        this.backingResult.addTag(id, (Collection)GenericUtil.uncheck(tag));
        this.recalculate();
    }

    @Override
    public void bind(class_3505.class_6863<?> result) {
        this.backingResult.bind(result);
    }

    @ZenCodeType.Method
    public List<KnownTag<T>> getTagsFor(T element) {
        return this.tags().stream().filter(tag -> tag.contains(element)).toList();
    }
}

