/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.CraftTweakerCommon;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.loot.LootManager;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.util.PathUtil;
import com.blamejared.crafttweaker.api.villager.CTVillagerTrades;
import com.blamejared.crafttweaker.impl.command.CtCommands;
import com.blamejared.crafttweaker.mixin.common.access.level.damage.AccessDamageSources;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.blamejared.crafttweaker.natives.villager.ExpandVillagerProfession;
import com.blamejared.crafttweaker.natives.world.biome.ExpandBiome;
import com.blamejared.crafttweaker.platform.Services;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3853;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8490;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

public final class DumpCommands {
    private DumpCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("dump_brackets", class_2561.method_43471((String)"crafttweaker.command.description.dump.brackets"), builder -> builder.executes(context -> {
            DumpCommands.doFullBracketsDump((CommandContext<class_2168>)context);
            return 1;
        }));
        handler.registerRootCommand("dump", class_2561.method_43471((String)"crafttweaker.command.description.dump"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandUtilities.send((class_2561)class_2561.method_43471((String)"crafttweaker.command.dump.types").method_27693(": "), (class_1657)player);
            CtCommands.get().commands().get("dump").subCommands().keySet().stream().map(it -> CommandUtilities.run(class_2561.method_43470((String)"- ").method_10852((class_2561)class_2561.method_43470((String)it).method_27692(class_124.field_1060)), "/ct dump " + it)).forEach(it -> CommandUtilities.send(it, (class_1657)player));
            return 1;
        }));
    }

    public static void registerDumpers(ICommandRegistrationHandler handler) {
        DumpCommands.registerBracketDumpers(handler);
        DumpCommands.registerCustomDumpers(handler);
    }

    private static void registerBracketDumpers(ICommandRegistrationHandler handler) {
        CraftTweakerAPI.getRegistry().getAllLoaders().stream().map(CraftTweakerAPI.getRegistry()::getBracketDumpers).map(Map::values).flatMap(Collection::stream).distinct().forEach(it -> {
            String subCommandName = it.subCommandName();
            handler.registerDump(subCommandName, it.description(), builder -> builder.executes((Command)it));
        });
    }

    private static void registerCustomDumpers(ICommandRegistrationHandler handler) {
        handler.registerDump("recipes", class_2561.method_43471((String)"crafttweaker.command.description.dump.recipes"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_7923.field_41188.method_10220().peek(type -> CommandUtilities.COMMAND_LOGGER.info(type.toString())).map(it -> ((AccessRecipeManager)player.method_37908().method_8433()).crafttweaker$getRecipes().getOrDefault(it, Collections.emptyMap()).keySet()).flatMap(Collection::stream).map(class_2960::toString).forEach(arg_0 -> ((Logger)CommandUtilities.COMMAND_LOGGER).info(arg_0));
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.recipes")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)player);
            return 1;
        }));
        handler.registerDump("loot_modifiers", class_2561.method_43471((String)"crafttweaker.command.description.dump.loot_modifiers"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            LootManager.INSTANCE.getModifierManager().getAllNames().forEach(arg_0 -> ((Logger)CommandUtilities.COMMAND_LOGGER).info(arg_0));
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.loot_modifiers")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)player);
            return 1;
        }));
        handler.registerDump("loot_tables", class_2561.method_43471((String)"crafttweaker.command.description.dump.loot_tables"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            server.method_3857().method_51193(class_8490.field_44498).stream().map(class_2960::toString).sorted().forEach(arg_0 -> ((Logger)CommandUtilities.COMMAND_LOGGER).info(arg_0));
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.loot_tables")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)player);
            return 1;
        }));
        handler.registerDump("biomes", class_2561.method_43471((String)"crafttweaker.command.description.dump.biomes"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            server.method_30611().method_33310(class_7924.field_41236).ifPresent(biomes -> biomes.method_10220().map(ExpandBiome::getCommandString).sorted().forEach(arg_0 -> ((Logger)CommandUtilities.COMMAND_LOGGER).info(arg_0)));
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.biomes")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)player);
            return 1;
        }));
        handler.registerDump("villager_trades", class_2561.method_43471((String)"crafttweaker.command.description.dump.villager.trades"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_3853.field_17067.forEach((villagerProfession, levelToTrades) -> {
                CommandUtilities.COMMAND_LOGGER.info("Trades for: " + ExpandVillagerProfession.getCommandString(villagerProfession));
                levelToTrades.keySet().intStream().sorted().filter(level -> ((class_3853.class_1652[])levelToTrades.getOrDefault(level, (Object)new class_3853.class_1652[0])).length > 0).peek(level -> CommandUtilities.COMMAND_LOGGER.info("Level " + level + " trades")).mapToObj(level -> (class_3853.class_1652[])levelToTrades.getOrDefault(level, (Object)new class_3853.class_1652[0])).flatMap(Arrays::stream).forEach(iTrade -> {
                    String tradeStr = " - Unable to display trade.";
                    if (CTVillagerTrades.TRADE_CONVERTER.containsKey(iTrade.getClass())) {
                        tradeStr = CTVillagerTrades.TRADE_CONVERTER.get(iTrade.getClass()).apply((class_3853.class_1652)iTrade).toString();
                    }
                    CommandUtilities.COMMAND_LOGGER.info(iTrade.getClass().getSimpleName() + tradeStr);
                });
            });
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.villager.trades")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)player);
            return 1;
        }));
        handler.registerDump("wandering_trades", class_2561.method_43471((String)"crafttweaker.command.description.dump.wandering.trades"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandUtilities.COMMAND_LOGGER.info("Wandering Trader Trades");
            class_3853.field_17724.keySet().intStream().sorted().filter(level -> ((class_3853.class_1652[])class_3853.field_17724.getOrDefault(level, (Object)new class_3853.class_1652[0])).length > 0).peek(level -> CommandUtilities.COMMAND_LOGGER.info("Level " + level + " trades")).mapToObj(level -> (class_3853.class_1652[])class_3853.field_17724.getOrDefault(level, (Object)new class_3853.class_1652[0])).flatMap(Arrays::stream).forEach(iTrade -> {
                String tradeStr = " - Unable to display trade.";
                if (CTVillagerTrades.TRADE_CONVERTER.containsKey(iTrade.getClass())) {
                    tradeStr = CTVillagerTrades.TRADE_CONVERTER.get(iTrade.getClass()).apply((class_3853.class_1652)iTrade).toString();
                }
                CommandUtilities.COMMAND_LOGGER.info(iTrade.getClass().getSimpleName() + tradeStr);
            });
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.wandering.trades")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)player);
            return 1;
        }));
        handler.registerDump("tag_contents", class_2561.method_43471((String)"crafttweaker.command.description.dump.tag.contents"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandUtilities.COMMAND_LOGGER.info("All Tag Contents");
            CraftTweakerTagRegistry.INSTANCE.managers().stream().sorted(ITagManager::compareTo).peek(it -> CommandUtilities.COMMAND_LOGGER.info("Contents of '{}' tags:", (Object)it.tagFolder())).flatMap(it -> it.tags().stream().sorted(MCTag::compareTo)).peek(it -> CommandUtilities.COMMAND_LOGGER.info(it.getCommandString())).flatMap(it -> it.idElements().stream().sorted(Comparator.comparing(rl -> rl.method_12832()).thenComparing(rl -> rl.method_12836())).map(o -> DumpCommands.getTagAsString(player, it, o))).forEach(it -> CommandUtilities.COMMAND_LOGGER.info("\t- {}", it));
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.tag.contents")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)player);
            return 1;
        }));
        handler.registerDump("damage_sources", class_2561.method_43471((String)"crafttweaker.command.description.dump.damage_sources"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            ((AccessDamageSources)player.method_37908().method_48963()).crafttweaker$getDamageTypes().method_10235().stream().sorted().forEach(arg_0 -> ((Logger)CommandUtilities.COMMAND_LOGGER).info(arg_0));
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.biomes")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)player);
            return 1;
        }));
        handler.registerDump("fake_players", class_2561.method_43471((String)"crafttweaker.command.description.dump.fake_players"), builder -> builder.executes(context -> {
            Services.PLATFORM.fakePlayers().map(it -> it.getName() + " -> " + it.getId()).forEach(it -> CraftTweakerCommon.logger().info(it));
            CommandUtilities.send(CommandUtilities.openingLogFile(class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(class_2561.method_43471((String)"crafttweaker.command.misc.fake_players")), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_1657)((class_2168)context.getSource()).method_9207());
            return 1;
        }));
    }

    private static String getTagAsString(class_3222 player, MCTag tag, Object o) {
        if (o instanceof class_2960) {
            return o.toString();
        }
        Optional foundRegistry = player.field_13995.method_30611().method_33310(tag.manager().resourceKey());
        if (foundRegistry.isPresent()) {
            return foundRegistry.map(objects -> objects.method_10221(o)).map(class_2960::toString).orElse(o.toString());
        }
        return o.toString();
    }

    private static void doFullBracketsDump(CommandContext<class_2168> context) {
        Path directory = PathUtil.findFromGameDirectory("ct_dumps");
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            CommandUtilities.COMMAND_LOGGER.error("Could not create output folder '{}'", (Object)directory);
            return;
        }
        CraftTweakerAPI.getRegistry().getAllLoaders().stream().map(CraftTweakerAPI.getRegistry()::getBracketDumpers).map(Map::values).flatMap(Collection::stream).distinct().forEach(it -> {
            String dumpedFileName = it.dumpedFileName() + ".txt";
            Iterable iterable = () -> it.values().sorted().iterator();
            try {
                Files.write(directory.resolve(dumpedFileName), iterable, new OpenOption[0]);
            }
            catch (IOException e) {
                CommandUtilities.COMMAND_LOGGER.error("Error writing to file '" + dumpedFileName + "'", (Throwable)e);
            }
        });
        CommandUtilities.send(CommandUtilities.openingFile(class_2561.method_43471((String)"crafttweaker.command.files.created").method_27692(class_124.field_1060), "ct_dumps"), (class_2168)context.getSource());
    }
}

