/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3737;
import net.minecraft.class_5819;
import org.dawnoftimebuilder.platform.Services;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.Utils;

public interface IBlockClimbingPlant {
    default public void tickPlant(class_2680 stateIn, class_1937 worldIn, class_2338 pos, class_5819 random) {
        if (!worldIn.method_8608()) {
            if (((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.method_11654(BlockStatePropertiesAA.CLIMBING_PLANT))).hasNoPlant() || ((Boolean)stateIn.method_11654((class_2769)class_2397.field_11200)).booleanValue()) {
                return;
            }
            if (!worldIn.method_8477(pos)) {
                return;
            }
            if (worldIn.method_22335(pos, 0) >= 8) {
                IBlockClimbingPlant newBlock;
                int index;
                int age = (Integer)stateIn.method_11654((class_2769)BlockStatePropertiesAA.AGE_0_6);
                if (random.method_43048(Services.PLATFORM.getConfig().climbingPlantGrowthChance) == 0) {
                    if (age < 2) {
                        this.placePlant((class_2680)stateIn.method_11657((class_2769)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf(age + 1)), worldIn, pos, 2);
                        return;
                    }
                    if (((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.method_11654(BlockStatePropertiesAA.CLIMBING_PLANT))).canGrow(worldIn, age)) {
                        this.placePlant((class_2680)stateIn.method_11657((class_2769)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf(2 + (age - 1) % 5)), worldIn, pos, 2);
                        return;
                    }
                }
                if (age < 2 || random.method_43048(Services.PLATFORM.getConfig().climbingPlantSpreadChance) != 0) {
                    return;
                }
                class_2338[] positions = new class_2338[]{pos.method_10095(), pos.method_10078(), pos.method_10072(), pos.method_10067(), pos.method_10084()};
                class_2680 newState = worldIn.method_8320(positions[index = random.method_43048(5)]);
                class_2248 class_22482 = newState.method_26204();
                if (class_22482 instanceof IBlockClimbingPlant && (newBlock = (IBlockClimbingPlant)class_22482).canHavePlant(newState) && ((BlockStatePropertiesAA.ClimbingPlant)((Object)newState.method_11654(BlockStatePropertiesAA.CLIMBING_PLANT))).hasNoPlant()) {
                    this.placePlant((class_2680)newState.method_11657(BlockStatePropertiesAA.CLIMBING_PLANT, (Comparable)((Object)((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.method_11654(BlockStatePropertiesAA.CLIMBING_PLANT))))), worldIn, positions[index], 2);
                }
            }
        }
    }

    default public boolean tryPlacingPlant(class_2680 stateIn, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn) {
        BlockStatePropertiesAA.ClimbingPlant plant;
        if (player.method_18276()) {
            return false;
        }
        class_1799 heldItemStack = player.method_5998(handIn);
        if (this.canHavePlant(stateIn) && ((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.method_11654(BlockStatePropertiesAA.CLIMBING_PLANT))).hasNoPlant() && !(plant = BlockStatePropertiesAA.ClimbingPlant.getFromItem(heldItemStack.method_7909())).hasNoPlant()) {
            stateIn = (class_2680)stateIn.method_11657(BlockStatePropertiesAA.CLIMBING_PLANT, (Comparable)((Object)plant));
            if (!player.method_7337()) {
                heldItemStack.method_7934(1);
            }
            this.placePlant(stateIn, worldIn, pos, 10);
            return true;
        }
        return false;
    }

    default public void placePlant(class_2680 state, class_1937 world, class_2338 pos, int option) {
        world.method_8652(pos, state, option);
    }

    default public class_1269 harvestPlant(class_2680 stateIn, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn) {
        if (player.method_7337() && ((Boolean)stateIn.method_11654((class_2769)class_2397.field_11200)).booleanValue() && !((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.method_11654(BlockStatePropertiesAA.CLIMBING_PLANT))).hasNoPlant()) {
            if (player.method_18276()) {
                if ((Integer)stateIn.method_11654((class_2769)BlockStatePropertiesAA.AGE_0_6) > 0) {
                    this.placePlant((class_2680)stateIn.method_11657((class_2769)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf((Integer)stateIn.method_11654((class_2769)BlockStatePropertiesAA.AGE_0_6) - 1)), worldIn, pos, 10);
                } else {
                    this.placePlant((class_2680)((class_2680)stateIn.method_11657(BlockStatePropertiesAA.CLIMBING_PLANT, (Comparable)((Object)BlockStatePropertiesAA.ClimbingPlant.NONE))).method_11657((class_2769)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf(0)), worldIn, pos, 10);
                }
                return class_1269.field_5812;
            }
            if ((Integer)stateIn.method_11654((class_2769)BlockStatePropertiesAA.AGE_0_6) < ((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.method_11654(BlockStatePropertiesAA.CLIMBING_PLANT))).maxAge()) {
                this.placePlant((class_2680)stateIn.method_11657((class_2769)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf((Integer)stateIn.method_11654((class_2769)BlockStatePropertiesAA.AGE_0_6) + 1)), worldIn, pos, 10);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if ((Integer)stateIn.method_11654((class_2769)BlockStatePropertiesAA.AGE_0_6) > 2 && this.dropPlant(stateIn, (class_1936)worldIn, pos, player.method_5998(handIn), true)) {
            stateIn = (class_2680)stateIn.method_11657((class_2769)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf(2));
            this.placePlant(stateIn, worldIn, pos, 10);
            worldIn.method_8396(null, pos, class_3417.field_15037, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (player.method_18276()) {
            return this.tryRemovingPlant(stateIn, worldIn, pos, player.method_5998(handIn));
        }
        return class_1269.field_5811;
    }

    default public class_1269 tryRemovingPlant(class_2680 stateIn, class_1937 worldIn, class_2338 pos, class_1799 heldItemStack) {
        if (!((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.method_11654(BlockStatePropertiesAA.CLIMBING_PLANT))).hasNoPlant()) {
            stateIn = this.removePlant(stateIn, (class_1936)worldIn, pos, heldItemStack);
            this.placePlant(stateIn, worldIn, pos, 10);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    default public class_2680 removePlant(class_2680 stateIn, class_1936 worldIn, class_2338 pos, class_1799 heldItemStack) {
        this.dropPlant(stateIn, worldIn, pos, heldItemStack, true);
        worldIn.method_8396(null, pos, class_3417.field_15037, class_3419.field_15245, 1.0f, 1.0f);
        stateIn = (class_2680)((class_2680)stateIn.method_11657(BlockStatePropertiesAA.CLIMBING_PLANT, (Comparable)((Object)BlockStatePropertiesAA.ClimbingPlant.NONE))).method_11657((class_2769)BlockStatePropertiesAA.AGE_0_6, (Comparable)Integer.valueOf(0));
        return stateIn;
    }

    default public boolean dropPlant(class_2680 stateIn, class_1936 worldIn, class_2338 pos, class_1799 heldItemStack, boolean bool) {
        if (worldIn.method_8608()) {
            return false;
        }
        BlockStatePropertiesAA.ClimbingPlant plant = (BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.method_11654(BlockStatePropertiesAA.CLIMBING_PLANT));
        if (plant.hasNoPlant()) {
            return false;
        }
        List<class_1799> drops = Utils.getLootList((class_3218)worldIn, stateIn, heldItemStack, plant.method_15434() + "_" + stateIn.method_11654((class_2769)BlockStatePropertiesAA.AGE_0_6));
        return Utils.dropLootFromList(worldIn, pos, drops, 1.0f);
    }

    default public boolean canHavePlant(class_2680 state) {
        if (state.method_26204() instanceof class_3737) {
            return (Boolean)state.method_11654((class_2769)class_2741.field_12508) == false;
        }
        return true;
    }

    default public boolean canSustainClimbingPlant(class_2680 stateUnder) {
        class_2248 block = stateUnder.method_26204();
        return block == class_2246.field_10219 || stateUnder.method_26164(class_3481.field_29822);
    }
}

