/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.dawnoftimebuilder.block.templates.SlabBlockAA;

public class MixedSlabBlock
extends SlabBlockAA {
    private final ArrayList<MixedBlockRecipe> listRecipes = new ArrayList();

    public MixedSlabBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public MixedSlabBlock addMixedBlockRecipe(class_2248 secondSlab, Supplier<class_2248> mixedBlock, boolean thisSlabIsBottom) {
        return this.addMixedBlockRecipe(() -> secondSlab, mixedBlock, thisSlabIsBottom);
    }

    private MixedSlabBlock addMixedBlockRecipe(Supplier<class_2248> secondSlab, Supplier<class_2248> mixedBlock, boolean thisSlabIsBottom) {
        this.listRecipes.add(new MixedBlockRecipe(secondSlab, mixedBlock, thisSlabIsBottom));
        return this;
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        class_2350 facing = hit.method_17780();
        class_1799 itemStack = player.method_5998(handIn);
        if (!player.method_18276() && player.method_7343(pos, facing, itemStack) && facing.method_10166().method_10178() && !itemStack.method_7960()) {
            for (MixedBlockRecipe recipe : this.listRecipes) {
                class_2680 madeState;
                if (facing != recipe.getFacingForMerging(false) || !recipe.isConnectibleFirstSlab(state) || itemStack.method_7909() != recipe.getSecondSlab().method_8389() || !worldIn.method_8652(pos, madeState = recipe.getMixedBlock().method_9564(), 11)) continue;
                this.method_9567(worldIn, pos, state, (class_1309)player, itemStack);
                if (player instanceof class_3222) {
                    class_174.field_1191.method_23889((class_3222)player, pos, itemStack);
                }
                class_2498 soundtype = recipe.getMixedBlock().method_9573(state);
                worldIn.method_8396(player, pos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
                if (!player.method_7337()) {
                    itemStack.method_7934(1);
                }
                return class_1269.field_5812;
            }
        }
        return super.method_9534(state, worldIn, pos, player, handIn, hit);
    }

    public static class_1792 getBlockItem(final MixedSlabBlock block) {
        return new class_1747((class_2248)block, new class_1792.class_1793()){

            public class_1269 method_7712(class_1750 context) {
                class_2350 facing = context.method_8038();
                if (context.method_8036() != null && context.method_8036().method_18276() || !facing.method_10166().method_10178()) {
                    return super.method_7712(context);
                }
                class_1657 player = context.method_8036();
                class_1799 itemStack = context.method_8041();
                class_1937 worldIn = context.method_8045();
                class_2338 pos = context.method_8037();
                if (!context.method_7717()) {
                    pos = pos.method_10093(facing.method_10153());
                }
                if (player != null && !player.method_7343(pos, facing, itemStack)) {
                    return super.method_7712(context);
                }
                if (!itemStack.method_7960()) {
                    class_2680 state = worldIn.method_8320(pos);
                    for (MixedBlockRecipe recipe : block.listRecipes) {
                        class_2680 madeState;
                        if (facing != recipe.getFacingForMerging(true) || !recipe.isConnectibleSecondSlab(state) || (madeState = recipe.getMixedBlock().method_9605(context)) == null || !worldIn.method_8652(pos, madeState, 11)) continue;
                        this.method_7711().method_9567(worldIn, pos, state, (class_1309)player, itemStack);
                        if (player instanceof class_3222) {
                            class_174.field_1191.method_23889((class_3222)player, pos, itemStack);
                        }
                        class_2498 soundtype = recipe.getMixedBlock().method_9573(state);
                        worldIn.method_8396(player, pos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
                        itemStack.method_7934(1);
                        return class_1269.field_5812;
                    }
                }
                return super.method_7712(context);
            }
        };
    }

    public static class MixedBlockRecipe {
        private final Supplier<class_2248> secondSlab;
        private final Supplier<class_2248> mixedBlock;
        private final boolean firstSlabIsBottom;

        private MixedBlockRecipe(Supplier<class_2248> secondSlab, Supplier<class_2248> mixedBlock, boolean firstSlabIsBottom) {
            this.secondSlab = secondSlab;
            this.mixedBlock = mixedBlock;
            this.firstSlabIsBottom = firstSlabIsBottom;
        }

        private boolean isConnectibleFirstSlab(class_2680 state) {
            return this.firstSlabIsBottom ? state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681 : state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12679;
        }

        private boolean isConnectibleSecondSlab(class_2680 state) {
            if (state.method_26204() == this.secondSlab.get() && this.secondSlab.get() instanceof class_2482) {
                return this.firstSlabIsBottom ? state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12679 : state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681;
            }
            return false;
        }

        private class_2350 getFacingForMerging(boolean tryPlacingFirstSlab) {
            if (tryPlacingFirstSlab) {
                return this.firstSlabIsBottom ? class_2350.field_11033 : class_2350.field_11036;
            }
            return this.firstSlabIsBottom ? class_2350.field_11036 : class_2350.field_11033;
        }

        protected class_2248 getSecondSlab() {
            return this.secondSlab.get();
        }

        protected class_2248 getMixedBlock() {
            return this.mixedBlock.get();
        }
    }
}

