/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1754;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1836;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3576;
import net.minecraft.class_3621;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.dawnoftimebuilder.block.general.WaterTrickleBlock;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.block.templates.FaucetBlock;
import org.dawnoftimebuilder.mixin.impl.BucketItemAccessor;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.Utils;
import org.jetbrains.annotations.NotNull;

public class PoolBlock
extends BlockAA {
    public final int maxLevel;
    public final int faucetLevel;

    public PoolBlock(class_4970.class_2251 propertiesIn, int maxLevelIn, int faucetLevelIn, class_265[] shapes) {
        super(propertiesIn.method_9631(state -> 1), shapes);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BlockStatePropertiesAA.HAS_PILLAR, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(0)));
        this.maxLevel = maxLevelIn;
        this.faucetLevel = faucetLevelIn;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{class_2741.field_12489}).method_11667(new class_2769[]{class_2741.field_12487}).method_11667(new class_2769[]{class_2741.field_12540}).method_11667(new class_2769[]{class_2741.field_12527}).method_11667(new class_2769[]{BlockStatePropertiesAA.HAS_PILLAR}).method_11667(new class_2769[]{BlockStatePropertiesAA.LEVEL});
    }

    @Override
    public int getShapeIndex(@NotNull class_2680 state, @NotNull class_1922 worldIn, @NotNull class_2338 pos, @NotNull class_3726 context) {
        int index = 0;
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12489)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12487)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12540)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12527)).booleanValue()) {
            index += 8;
        }
        if (((Boolean)state.method_11654((class_2769)BlockStatePropertiesAA.HAS_PILLAR)).booleanValue()) {
            index += 16;
        }
        return index;
    }

    public class_2680 method_9605(class_1750 contextIn) {
        PoolLevelAndSides levelAndSides = PoolBlock.levelOfPoolAround(contextIn.method_8037(), (class_1936)contextIn.method_8045());
        class_2680 state = (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(levelAndSides.south))).method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(levelAndSides.north))).method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(levelAndSides.right))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(levelAndSides.left));
        int level = levelAndSides.level;
        if (level <= 0 && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAround(contextIn.method_8037(), (class_1936)contextIn.method_8045()))) {
            level = 1;
            if (!contextIn.method_8045().method_8608()) {
                contextIn.method_8045().method_39279(contextIn.method_8037(), (class_2248)this, 5);
            }
        }
        state = (class_2680)state.method_11657((class_2769)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(level));
        return state;
    }

    public class_1269 method_9534(class_2680 blockStateIn, class_1937 worldIn, class_2338 blockPosIn, class_1657 playerEntityIn, class_1268 handIn, class_3965 blockRayTraceResultIn) {
        class_1799 itemStack = playerEntityIn.method_6047();
        if (!playerEntityIn.method_18276()) {
            int lastLevel;
            int nextLevel = lastLevel = ((Integer)blockStateIn.method_11654((class_2769)BlockStatePropertiesAA.LEVEL)).intValue();
            boolean tryToChangeLevel = false;
            class_1799 newItemStack = null;
            if (itemStack.method_7909() instanceof class_1755) {
                if (((BucketItemAccessor)itemStack.method_7909()).getContent() instanceof class_3621) {
                    nextLevel = this.maxLevel;
                    if (!playerEntityIn.method_7337()) {
                        newItemStack = new class_1799((class_1935)class_1802.field_8550);
                    }
                } else if (((BucketItemAccessor)itemStack.method_7909()).getContent() instanceof class_3576) {
                    nextLevel = 0;
                    if (!playerEntityIn.method_7337()) {
                        newItemStack = new class_1799((class_1935)class_1802.field_8705);
                    }
                }
                tryToChangeLevel = true;
            } else if (itemStack.method_7909() instanceof class_1812) {
                class_1842 potion = class_1844.method_8063((class_1799)itemStack);
                if (potion.method_8049().isEmpty() && nextLevel + 1 < this.maxLevel) {
                    ++nextLevel;
                    if (!playerEntityIn.method_7337()) {
                        newItemStack = new class_1799((class_1935)class_1802.field_8469);
                    }
                }
                tryToChangeLevel = true;
            } else if (itemStack.method_7909() instanceof class_1754) {
                class_1842 potion = class_1844.method_8063((class_1799)itemStack);
                if (potion.method_8049().isEmpty() && nextLevel - 1 >= 0) {
                    --nextLevel;
                    if (!playerEntityIn.method_7337()) {
                        newItemStack = class_1802.field_8574.method_7854();
                    }
                }
                tryToChangeLevel = true;
            }
            if (tryToChangeLevel) {
                if (nextLevel == lastLevel) {
                    return class_1269.field_21466;
                }
                if (newItemStack != null) {
                    itemStack.method_7934(1);
                    playerEntityIn.method_31548().method_7394(newItemStack);
                }
                blockStateIn = (class_2680)blockStateIn.method_11657((class_2769)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(nextLevel));
                worldIn.method_8652(blockPosIn, blockStateIn, 10);
                if (nextLevel == 0) {
                    PoolBlock.removeWaterAround(blockStateIn, blockPosIn, worldIn);
                }
                return class_1269.field_5812;
            }
            if (itemStack.method_7960()) {
                blockStateIn = (class_2680)blockStateIn.method_11657((class_2769)BlockStatePropertiesAA.HAS_PILLAR, (Comparable)Boolean.valueOf((Boolean)blockStateIn.method_11654((class_2769)BlockStatePropertiesAA.HAS_PILLAR) == false));
                worldIn.method_8652(blockPosIn, blockStateIn, 10);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public void method_9567(class_1937 worldIn, class_2338 blockPosIn, class_2680 blockStateIn, class_1309 entityIn, class_1799 itemStackIn) {
        if (entityIn instanceof class_1657 && !entityIn.method_5715()) {
            super.method_9567(worldIn, blockPosIn, blockStateIn, entityIn, itemStackIn);
            class_2338 blockPos = blockPosIn.method_10074();
            class_2680 blockState = worldIn.method_8320(blockPos);
            if (blockState.method_26204() == this) {
                blockState = (class_2680)blockState.method_11657((class_2769)BlockStatePropertiesAA.HAS_PILLAR, (Comparable)Boolean.valueOf(true));
                worldIn.method_8652(blockPos, blockState, 10);
            }
        }
    }

    public void method_9588(class_2680 blockStateIn, class_3218 serverWorldIn, class_2338 blockPosIn, class_5819 randomIn) {
        super.method_9588(blockStateIn, serverWorldIn, blockPosIn, randomIn);
        boolean increase = EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAround(blockPosIn, (class_1936)serverWorldIn));
        if (increase) {
            int level = (Integer)blockStateIn.method_11654((class_2769)BlockStatePropertiesAA.LEVEL);
            if (level < this.maxLevel) {
                blockStateIn = (class_2680)blockStateIn.method_11657((class_2769)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(level + 1));
                serverWorldIn.method_8652(blockPosIn, blockStateIn, 10);
                if (level + 1 < this.maxLevel) {
                    serverWorldIn.method_39279(blockPosIn, (class_2248)this, 5);
                }
            }
        } else {
            int level = (Integer)blockStateIn.method_11654((class_2769)BlockStatePropertiesAA.LEVEL);
            if (level - 1 >= 0) {
                blockStateIn = (class_2680)blockStateIn.method_11657((class_2769)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(--level));
                serverWorldIn.method_8652(blockPosIn, blockStateIn, 10);
                if (level - 1 >= 0) {
                    serverWorldIn.method_39279(blockPosIn, (class_2248)this, 5);
                }
            }
        }
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 directionIn, class_2680 facingStateIn, class_1936 worldIn, class_2338 currentPosIn, class_2338 facingPosIn) {
        if (directionIn.method_10166().method_10179()) {
            boolean hasPoolInSide;
            boolean bl = hasPoolInSide = facingStateIn.method_26204() == this;
            if (hasPoolInSide && (Integer)facingStateIn.method_11654((class_2769)BlockStatePropertiesAA.LEVEL) >= 0) {
                stateIn = (class_2680)stateIn.method_11657((class_2769)BlockStatePropertiesAA.LEVEL, (Comparable)((Integer)facingStateIn.method_11654((class_2769)BlockStatePropertiesAA.LEVEL)));
            }
            switch (directionIn) {
                case field_11043: {
                    stateIn = (class_2680)stateIn.method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
                case field_11034: {
                    stateIn = (class_2680)stateIn.method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
                case field_11035: {
                    stateIn = (class_2680)stateIn.method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
                case field_11039: {
                    stateIn = (class_2680)stateIn.method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
            }
        }
        int level = (Integer)stateIn.method_11654((class_2769)BlockStatePropertiesAA.LEVEL);
        if (facingPosIn.method_10264() == currentPosIn.method_10264() + 1) {
            int lastLevel = level;
            EnumActivatorState state = PoolBlock.hasOnePoolActivatorAround(currentPosIn, worldIn);
            if (EnumActivatorState.ENABLED.equals((Object)state)) {
                if (level < this.maxLevel) {
                    ++level;
                }
            } else if (EnumActivatorState.DISABLED.equals((Object)state) && level - 1 >= 0) {
                --level;
            }
            stateIn = (class_2680)stateIn.method_11657((class_2769)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(level));
            if (!worldIn.method_8608() && lastLevel != level) {
                worldIn.method_39279(currentPosIn, (class_2248)this, 5);
            }
        }
        return stateIn;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_9568(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "add_column");
    }

    public int method_9505(class_2680 p_200011_1_In, class_1922 p_200011_2_In, class_2338 p_200011_3_In) {
        return 1;
    }

    public boolean method_9526(class_2680 p_220074_1_In) {
        return false;
    }

    public boolean method_9579(class_2680 p_200123_1_In, class_1922 p_200123_2_In, class_2338 p_200123_3_In) {
        return true;
    }

    public static boolean removeWaterAround(class_2680 blockStateIn, class_2338 blockPosIn, class_1937 worldIn) {
        return PoolBlock.removeWaterAround(new LinkedHashMap<class_2338, class_2680>(), blockStateIn, blockPosIn, worldIn, 0.0f, 0.0f);
    }

    private static boolean removeWaterAround(Map<class_2338, class_2680> testedPositionsIn, class_2680 blockStateIn, class_2338 blockPosIn, class_1937 worldIn, float prohibitedXIn, float prohibitedZIn) {
        boolean success = (Integer)blockStateIn.method_11654((class_2769)BlockStatePropertiesAA.LEVEL) > 0;
        blockStateIn = (class_2680)blockStateIn.method_11657((class_2769)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(0));
        worldIn.method_8652(blockPosIn, blockStateIn, 10);
        if (prohibitedXIn != 1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, 1, 0)) {
            success = true;
        }
        if (prohibitedXIn != -1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, -1, 0)) {
            success = true;
        }
        if (prohibitedZIn != 1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, 0, 1)) {
            success = true;
        }
        if (prohibitedZIn != -1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, 0, -1)) {
            success = true;
        }
        return success;
    }

    private static boolean removeWaterAroundOffset(Map<class_2338, class_2680> testedPositionsIn, class_2338 blockPosIn, class_1937 worldIn, int x, int z) {
        class_2338 pos = blockPosIn.method_10069(x, 0, z);
        if (!testedPositionsIn.containsKey(pos)) {
            class_2680 state = worldIn.method_8320(pos);
            if (state.method_26204() instanceof PoolBlock) {
                testedPositionsIn.put(pos, state);
                return PoolBlock.removeWaterAround(testedPositionsIn, state, pos, worldIn, x, z);
            }
            if (state.method_26204() instanceof FaucetBlock) {
                state = (class_2680)state.method_11657((class_2769)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(false));
                worldIn.method_8652(pos, state, 10);
            }
        }
        return false;
    }

    public static EnumActivatorState hasOnePoolActivatorAround(class_2338 blockPosIn, class_1936 worldIn) {
        return PoolBlock.hasOnePoolActivatorAround(new LinkedHashMap<class_2338, class_2680>(), blockPosIn, worldIn, 0.0f, 0.0f);
    }

    private static EnumActivatorState hasOnePoolActivatorAround(Map<class_2338, class_2680> testedPositionsIn, class_2338 blockPosIn, class_1936 worldIn, float prohibitedXIn, float prohibitedZIn) {
        if (testedPositionsIn.containsKey(blockPosIn)) {
            return EnumActivatorState.NO;
        }
        class_2680 state = worldIn.method_8320(blockPosIn.method_10084());
        testedPositionsIn.put(blockPosIn, state);
        if (state.method_26204() instanceof WaterTrickleBlock || state.method_26204() instanceof FaucetBlock && ((Boolean)state.method_11654((class_2769)BlockStatePropertiesAA.ACTIVATED)).booleanValue()) {
            return EnumActivatorState.ENABLED;
        }
        if (prohibitedXIn != 1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, 1, 0)) || prohibitedXIn != -1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, -1, 0)) || prohibitedZIn != 1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, 0, 1)) || prohibitedZIn != -1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, 0, -1))) {
            return EnumActivatorState.ENABLED;
        }
        return EnumActivatorState.NO;
    }

    public static EnumActivatorState hasOnePoolActivatorAroundOffset(Map<class_2338, class_2680> testedPositionsIn, class_1936 worldIn, class_2338 baseBlockPosIn, int xOffsetIn, int zOffsetIn) {
        class_2338 offsetBlockPos = baseBlockPosIn.method_10069(xOffsetIn, 0, zOffsetIn);
        class_2680 offsetState = worldIn.method_8320(offsetBlockPos);
        if (offsetState.method_26204() instanceof PoolBlock) {
            return PoolBlock.hasOnePoolActivatorAround(testedPositionsIn, offsetBlockPos, worldIn, -xOffsetIn, -zOffsetIn);
        }
        return EnumActivatorState.NO;
    }

    private static PoolLevelAndSides levelOfPoolAround(class_2338 blockPosIn, class_1936 worldIn) {
        return PoolBlock.levelOfPoolAround(new LinkedHashMap<class_2338, class_2680>(), new PoolLevelAndSides(), blockPosIn, worldIn, 0.0f, 0.0f);
    }

    private static PoolLevelAndSides levelOfPoolAround(Map<class_2338, class_2680> testedPositionsIn, PoolLevelAndSides poolLevelAndSidesIn, class_2338 blockPosIn, class_1936 worldIn, float prohibitedXIn, float prohibitedZIn) {
        int level;
        boolean center;
        boolean bl = center = prohibitedXIn == 0.0f && prohibitedZIn == 0.0f;
        if (prohibitedXIn != 1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, 1, 0);
            if (level > 0 && center) {
                poolLevelAndSidesIn.right = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        if (prohibitedXIn != -1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, -1, 0);
            if (level > 0 && center) {
                poolLevelAndSidesIn.left = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        if (prohibitedZIn != 1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, 0, 1);
            if (level > 0 && center) {
                poolLevelAndSidesIn.north = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        if (prohibitedZIn != -1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, 0, -1);
            if (level > 0 && center) {
                poolLevelAndSidesIn.south = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        return poolLevelAndSidesIn;
    }

    private static int poolLevelAroundOffset(Map<class_2338, class_2680> testedPositionsIn, PoolLevelAndSides poolLevelAndSidesIn, class_2338 baseBlockPosIn, class_1936 worldIn, int xOffsetIn, int zOffsetIn) {
        class_2338 pos = baseBlockPosIn.method_10069(xOffsetIn, 0, zOffsetIn);
        if (testedPositionsIn.containsKey(pos)) {
            return -1;
        }
        class_2680 state = worldIn.method_8320(pos);
        testedPositionsIn.put(pos, state);
        if (state.method_26204() instanceof PoolBlock) {
            PoolBlock.levelOfPoolAround(testedPositionsIn, poolLevelAndSidesIn, pos, worldIn, -xOffsetIn, -zOffsetIn);
            int currentLevel = (Integer)state.method_11654((class_2769)BlockStatePropertiesAA.LEVEL);
            return Math.max(currentLevel, poolLevelAndSidesIn.level);
        }
        return -1;
    }

    public static final class PoolLevelAndSides {
        public boolean left;
        public boolean right;
        public boolean north;
        public boolean south;
        public int level = 0;
    }

    public static enum EnumActivatorState {
        NO,
        DISABLED,
        ENABLED;

    }
}

