/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2366;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import org.dawnoftimebuilder.block.IBlockGeneration;
import org.dawnoftimebuilder.util.Utils;

public class SoilCropsBlock
extends class_2302
implements IBlockGeneration {
    private final PlantType plantType;
    public static final class_2746 PERSISTENT = class_2741.field_12514;

    public SoilCropsBlock(PlantType type) {
        super(class_4970.class_2251.method_9630((class_4970)class_2246.field_10583).method_49229(class_4970.class_2250.field_10656).method_9640().method_9626(class_2498.field_17580));
        this.plantType = type;
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)this.method_9824(), (Comparable)Integer.valueOf(0))).method_11657((class_2769)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{PERSISTENT});
    }

    public void method_9514(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 random) {
        float f;
        int age;
        if (((Boolean)state.method_11654((class_2769)PERSISTENT)).booleanValue()) {
            return;
        }
        if (!worldIn.method_8477(pos)) {
            return;
        }
        if (worldIn.method_22335(pos, 0) >= 9 && (age = this.method_9829(state)) < this.method_9827() && random.method_43048((int)(25.0f / (f = SoilCropsBlock.method_9830((class_2248)this, (class_1922)worldIn, (class_2338)pos))) + 1) == 0) {
            this.setPlantWithAge(state, (class_1936)worldIn, pos, age + 1);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return this.mayGenerateOn((class_1922)world, pos.method_10074(), this.getPlantType()) && super.method_9558(state, world, pos);
    }

    private PlantType getPlantType() {
        return this.plantType;
    }

    protected boolean method_9695(class_2680 state, class_1922 world, class_2338 pos) {
        return this.mayGenerateOn(world, pos, this.getPlantType());
    }

    public boolean mayGenerateOn(class_1922 worldIn, class_2338 pos, PlantType plantType) {
        class_2680 stateOn = worldIn.method_8320(pos);
        class_2248 blockOn = stateOn.method_26204();
        if (plantType.equals((Object)PlantType.DESERT)) {
            return stateOn.method_27852(class_2246.field_10102) || stateOn.method_27852(class_2246.field_10415) || blockOn instanceof class_2366;
        }
        if (plantType.equals((Object)PlantType.NETHER)) {
            return stateOn.method_27852(class_2246.field_10114);
        }
        if (plantType.equals((Object)PlantType.CROP)) {
            return stateOn.method_27852(class_2246.field_10362);
        }
        if (plantType.equals((Object)PlantType.CAVE)) {
            return stateOn.method_26206(worldIn, pos, class_2350.field_11036);
        }
        if (plantType.equals((Object)PlantType.PLAINS)) {
            return stateOn.method_27852(class_2246.field_10219) || stateOn.method_27852(class_2246.field_10566) || stateOn.method_27852(class_2246.field_10362);
        }
        if (plantType.equals((Object)PlantType.WATER)) {
            return worldIn.method_8316(pos.method_10084()).method_15772() == class_3612.field_15910 && (stateOn.method_27852(class_2246.field_10460) || stateOn.method_27852(class_2246.field_10566) || stateOn.method_27852(class_2246.field_10362) || stateOn.method_27852(class_2246.field_10255));
        }
        if (plantType.equals((Object)PlantType.BEACH)) {
            boolean isBeach;
            boolean bl = isBeach = stateOn.method_27852(class_2246.field_10219) || stateOn.method_27852(class_2246.field_10566) || stateOn.method_27852(class_2246.field_10102) || stateOn.method_27852(class_2246.field_10534);
            if (isBeach) {
                boolean hasWater = false;
                for (class_2350 face : class_2350.class_2353.field_11062) {
                    class_2680 blockState = worldIn.method_8320(pos.method_10093(face));
                    class_3610 fluidState = worldIn.method_8316(pos.method_10093(face));
                    hasWater = blockState.method_27852(class_2246.field_10110);
                    if (!(hasWater |= fluidState.method_15767(class_3486.field_15517))) continue;
                    break;
                }
                return hasWater;
            }
        }
        return false;
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        if (((Boolean)state.method_11654((class_2769)PERSISTENT)).booleanValue()) {
            if (player.method_7337()) {
                int age = this.method_9829(state);
                if (player.method_18276()) {
                    if (age > 0) {
                        this.setPlantWithAge(state, (class_1936)worldIn, pos, age - 1);
                        return class_1269.field_5812;
                    }
                } else if (age < this.method_9827()) {
                    this.setPlantWithAge(state, (class_1936)worldIn, pos, age + 1);
                    return class_1269.field_5812;
                }
            }
        } else if (Utils.useLighter(worldIn, pos, player, handIn)) {
            Random rand = new Random();
            for (int i = 0; i < 5; ++i) {
                worldIn.method_8494((class_2394)class_2398.field_11251, (double)pos.method_10263() + rand.nextDouble(), (double)pos.method_10264() + 0.5 + rand.nextDouble() / 2.0, (double)pos.method_10260() + rand.nextDouble(), 0.0, 0.07, 0.0);
            }
            worldIn.method_8652(pos, (class_2680)state.method_11657((class_2769)PERSISTENT, (Comparable)Boolean.valueOf(true)), 10);
            return class_1269.field_5812;
        }
        return super.method_9534(state, worldIn, pos, player, handIn, hit);
    }

    public void setPlantWithAge(class_2680 currentState, class_1936 worldIn, class_2338 pos, int newAge) {
        worldIn.method_8652(pos, (class_2680)currentState.method_11657((class_2769)this.method_9824(), (Comparable)Integer.valueOf(newAge)), 10);
    }

    @Nonnull
    protected class_1935 method_9832() {
        return this.method_8389();
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_9568(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "crop");
    }

    @Override
    public boolean generateOnPos(class_5281 world, class_2338 pos, class_2680 state, class_5819 random) {
        class_2680 groundState = world.method_8320(pos.method_10074());
        if (!groundState.method_26164(class_3481.field_29822)) {
            return false;
        }
        this.setPlantWithAge(state, (class_1936)world, pos, random.method_43048(this.method_9827() + 1));
        return true;
    }

    public static enum PlantType {
        DESERT,
        NETHER,
        CROP,
        CAVE,
        PLAINS,
        WATER,
        BEACH;

    }
}

