/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.util;

import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_3542;
import net.minecraft.class_4778;
import org.dawnoftimebuilder.registry.DoTBBlocksRegistry;
import org.dawnoftimebuilder.registry.DoTBItemsRegistry;
import org.jetbrains.annotations.NotNull;

public class BlockStatePropertiesAA {
    public static final class_2746 CUT = class_2746.method_11825((String)"cut");
    public static final class_2746 ROLLED = class_2746.method_11825((String)"rolled");
    public static final class_2746 AXIS_X = class_2746.method_11825((String)"axis_x");
    public static final class_2746 AXIS_Y = class_2746.method_11825((String)"axis_y");
    public static final class_2746 AXIS_Z = class_2746.method_11825((String)"axis_z");
    public static final class_2746 SUBAXIS = class_2746.method_11825((String)"subaxis");
    public static final class_2746 HAS_PILLAR = class_2746.method_11825((String)"has_pillar");
    public static final class_2746 CENTER = class_2746.method_11825((String)"center");
    public static final class_2746 NORTH_TRICKLE = class_2746.method_11825((String)"north_trickle");
    public static final class_2746 EAST_TRICKLE = class_2746.method_11825((String)"east_trickle");
    public static final class_2746 SOUTH_TRICKLE = class_2746.method_11825((String)"south_trickle");
    public static final class_2746 WEST_TRICKLE = class_2746.method_11825((String)"west_trickle");
    public static final class_2746 CENTER_TRICKLE = class_2746.method_11825((String)"center_trickle");
    public static final class_2746 ACTIVATED = class_2746.method_11825((String)"activated");
    public static final class_2746 SMALL_TOP = class_2746.method_11825((String)"small_top");
    public static final class_2758 MULTIBLOCK_0_2 = class_2758.method_11867((String)"multiblock", (int)0, (int)2);
    public static final class_2758 MULTIBLOCK_3X = class_2758.method_11867((String)"multiblock_3x", (int)0, (int)2);
    public static final class_2758 MULTIBLOCK_2Y = class_2758.method_11867((String)"multiblock_2y", (int)0, (int)1);
    public static final class_2758 MULTIBLOCK_3Y = class_2758.method_11867((String)"multiblock_3y", (int)0, (int)2);
    public static final class_2758 MULTIBLOCK_3Z = class_2758.method_11867((String)"multiblock_3z", (int)0, (int)2);
    public static final class_2758 HUMIDITY_0_8 = class_2758.method_11867((String)"humidity", (int)0, (int)8);
    public static final class_2758 AGE_0_6 = class_2758.method_11867((String)"age", (int)0, (int)6);
    public static final class_2758 HEAT_0_4 = class_2758.method_11867((String)"heat", (int)0, (int)4);
    public static final class_2758 SIZE_0_2 = class_2758.method_11867((String)"size", (int)0, (int)2);
    public static final class_2758 SIZE_0_5 = class_2758.method_11867((String)"size", (int)0, (int)5);
    public static final class_2758 STACK = class_2758.method_11867((String)"stack", (int)1, (int)3);
    public static final class_2758 LEVEL = class_2758.method_11867((String)"level", (int)0, (int)16);
    public static final class_2754<ClimbingPlant> CLIMBING_PLANT = class_2754.method_11850((String)"climbing_plant", ClimbingPlant.class);
    public static final class_2754<FencePillar> FENCE_PILLAR = class_2754.method_11850((String)"fence_pillar", FencePillar.class);
    public static final class_2754<HorizontalConnection> HORIZONTAL_CONNECTION = class_2754.method_11850((String)"horizontal_connection", HorizontalConnection.class);
    public static final class_2754<OpenPosition> OPEN_POSITION = class_2754.method_11850((String)"open_position", OpenPosition.class);
    public static final class_2754<PillarConnection> PILLAR_CONNECTION = class_2754.method_11850((String)"pillar_connection", PillarConnection.class);
    public static final class_2754<SidedWindow> SIDED_WINDOW = class_2754.method_11850((String)"sided_window", SidedWindow.class);
    public static final class_2754<VerticalConnection> VERTICAL_CONNECTION = class_2754.method_11850((String)"vertical_connection", VerticalConnection.class);
    public static final class_2754<SquareCorners> CORNER = class_2754.method_11850((String)"corner", SquareCorners.class);
    public static final class_2754<class_4778> PILLAR_WALL = class_2754.method_11850((String)"pillar", class_4778.class);
    public static final class_2754<VerticalLimitedConnection> NORTH_STATE = class_2754.method_11850((String)"north_state", VerticalLimitedConnection.class);
    public static final class_2754<VerticalLimitedConnection> EAST_STATE = class_2754.method_11850((String)"east_state", VerticalLimitedConnection.class);
    public static final class_2754<VerticalLimitedConnection> SOUTH_STATE = class_2754.method_11850((String)"south_state", VerticalLimitedConnection.class);
    public static final class_2754<VerticalLimitedConnection> WEST_STATE = class_2754.method_11850((String)"west_state", VerticalLimitedConnection.class);
    public static final class_2754<WaterTrickleEnd> WATER_TRICKLE_END = class_2754.method_11850((String)"water_end", WaterTrickleEnd.class);

    public static enum ClimbingPlant implements class_3542
    {
        NONE("none"),
        VINE("vine"),
        IVY("ivy"),
        GRAPE("grape", true, 4, 6, 0, 2, 2);

        private final String name;
        private final boolean cycle;
        private final int[] moonPhasePerAge;

        private ClimbingPlant(String name, boolean cycle, int age2, int age3, int age4, int age5, int age6) {
            this.name = name;
            this.cycle = cycle;
            this.moonPhasePerAge = new int[]{age2, age3, age4, age5, age6};
        }

        private ClimbingPlant(String name) {
            this(name, false, 0, 0, 0, 0, 0);
        }

        public static ClimbingPlant getFromItem(class_1792 item) {
            if (item == DoTBItemsRegistry.INSTANCE.GRAPE_SEEDS.get()) {
                return GRAPE;
            }
            if (item == class_2246.field_10597.method_8389()) {
                return VINE;
            }
            if (item == DoTBBlocksRegistry.INSTANCE.IVY.get().method_8389()) {
                return IVY;
            }
            return NONE;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public int maxAge() {
            return this.cycle ? 6 : 2;
        }

        public boolean canGrow(class_1937 worldIn, int currentAge) {
            if (!this.cycle || currentAge < 2 || currentAge > 6) {
                return false;
            }
            int currentPhase = worldIn.method_8597().method_28531(worldIn.method_8532());
            return (currentPhase - this.moonPhasePerAge[currentAge -= 2] + 8) % 8 < 4;
        }

        public boolean hasNoPlant() {
            return this == NONE;
        }
    }

    public static enum FencePillar implements class_3542
    {
        NONE("none"),
        PILLAR_BIG("pillar_big"),
        PILLAR_SMALL("pillar_small"),
        CAP_PILLAR_BIG("cap_pillar_big");

        private final String name;

        private FencePillar(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }

    public static enum HorizontalConnection implements class_3542
    {
        NONE("none", 0),
        LEFT("left", 1),
        RIGHT("right", 2),
        BOTH("both", 3);

        private final String name;
        private final int index;

        private HorizontalConnection(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum OpenPosition implements class_3542
    {
        CLOSED("closed"),
        HALF("half"),
        FULL("full");

        private final String name;

        private OpenPosition(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public boolean isOpen() {
            return this != CLOSED;
        }
    }

    public static enum PillarConnection implements class_3542
    {
        NOTHING("nothing"),
        FOUR_PX("4_pixels"),
        SIX_PX("6_pixels"),
        EIGHT_PX("8_pixels"),
        TEN_PX("10_pixels");

        private final String name;

        private PillarConnection(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }

    public static enum SidedWindow implements class_3542
    {
        NORTH("north", class_2350.field_11043),
        EAST("east", class_2350.field_11034),
        SOUTH("south", class_2350.field_11035),
        WEST("west", class_2350.field_11039),
        AXIS_X("axis_x", class_2350.field_11034),
        AXIS_Z("axis_z", class_2350.field_11043);

        private final String name;
        private final class_2350 direction;

        private SidedWindow(String name, class_2350 offset) {
            this.name = name;
            this.direction = offset;
        }

        public static SidedWindow getSide(class_2350 facing, boolean isSneaking) {
            if (isSneaking) {
                return facing.method_10166() == class_2350.class_2351.field_11048 ? AXIS_X : AXIS_Z;
            }
            return switch (facing) {
                case class_2350.field_11034 -> EAST;
                case class_2350.field_11035 -> SOUTH;
                case class_2350.field_11039 -> WEST;
                default -> NORTH;
            };
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public class_2350 getDirection() {
            return this.direction;
        }

        public class_2350 getOffset() {
            return this.direction.method_10160();
        }

        public SidedWindow rotate(boolean clockWise) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORTH -> {
                    if (clockWise) {
                        yield EAST;
                    }
                    yield WEST;
                }
                case EAST -> {
                    if (clockWise) {
                        yield SOUTH;
                    }
                    yield NORTH;
                }
                case SOUTH -> {
                    if (clockWise) {
                        yield WEST;
                    }
                    yield EAST;
                }
                case WEST -> {
                    if (clockWise) {
                        yield NORTH;
                    }
                    yield SOUTH;
                }
                case AXIS_X -> AXIS_Z;
                case AXIS_Z -> AXIS_X;
            };
        }
    }

    public static enum VerticalConnection implements class_3542
    {
        NONE("none", 0),
        UNDER("under", 1),
        ABOVE("above", 2),
        BOTH("both", 3);

        private final String name;
        private final int index;

        private VerticalConnection(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum SquareCorners implements class_3542
    {
        TOP_LEFT("top_left", -1, 1),
        TOP_RIGHT("top_right", 1, 1),
        BOTTOM_RIGHT("bottom_right", 1, -1),
        BOTTOM_LEFT("bottom_left", -1, -1);

        private final String name;
        private final int horizontal_offset;
        private final int vertical_offset;

        private SquareCorners(String name, int horizontal_offset, int vertical_offset) {
            this.name = name;
            this.horizontal_offset = horizontal_offset;
            this.vertical_offset = vertical_offset;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public int getHorizontalOffset(SquareCorners referenceCorner) {
            return referenceCorner.horizontal_offset == this.horizontal_offset ? 0 : this.horizontal_offset;
        }

        public int getVerticalOffset(SquareCorners referenceCorner) {
            return referenceCorner.vertical_offset == this.vertical_offset ? 0 : this.vertical_offset;
        }

        public boolean isTopCorner() {
            return this.vertical_offset == 1;
        }

        public SquareCorners getAdjacentCorner(boolean vertically) {
            return switch (this) {
                case TOP_RIGHT -> {
                    if (vertically) {
                        yield BOTTOM_RIGHT;
                    }
                    yield TOP_LEFT;
                }
                case BOTTOM_RIGHT -> {
                    if (vertically) {
                        yield TOP_RIGHT;
                    }
                    yield BOTTOM_LEFT;
                }
                case BOTTOM_LEFT -> {
                    if (vertically) {
                        yield TOP_LEFT;
                    }
                    yield BOTTOM_RIGHT;
                }
                default -> vertically ? BOTTOM_LEFT : TOP_RIGHT;
            };
        }
    }

    public static enum VerticalLimitedConnection implements class_3542
    {
        NONE("none", 0),
        BOTTOM("bottom", 1),
        TOP("top", 2);

        private final String name;
        private final int index;

        private VerticalLimitedConnection(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum WaterTrickleEnd implements class_3542
    {
        STRAIGHT("straight"),
        FADE("fade"),
        SPLASH("splash");

        private final String name;

        private WaterTrickleEnd(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }
}

