/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.talent.BedFinderTalent;
import doggytalents.common.talent.BlackPeltTalent;
import doggytalents.common.talent.ChemiCanineTalent;
import doggytalents.common.talent.CreeperSweeperTalent;
import doggytalents.common.talent.DoggyArmorTalent;
import doggytalents.common.talent.DoggyDashTalent;
import doggytalents.common.talent.DoggyTorchTalent;
import doggytalents.common.talent.FireDrillTalent;
import doggytalents.common.talent.FisherDogTalent;
import doggytalents.common.talent.FlyingFurballTalent;
import doggytalents.common.talent.GatePasserTalent;
import doggytalents.common.talent.GuardDogTalent;
import doggytalents.common.talent.HappyEaterTalent;
import doggytalents.common.talent.HellHoundTalent;
import doggytalents.common.talent.MobRetrieverTalent;
import doggytalents.common.talent.OokamiKazeTalent;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.talent.PestFighterTalent;
import doggytalents.common.talent.PillowPawTalent;
import doggytalents.common.talent.PoisonFangTalent;
import doggytalents.common.talent.PuppyEyesTalent;
import doggytalents.common.talent.QuickHealerTalent;
import doggytalents.common.talent.RescueDogTalent;
import doggytalents.common.talent.RoaringGaleTalent;
import doggytalents.common.talent.ShepherdDogTalent;
import doggytalents.common.talent.ShockAbsorberTalent;
import doggytalents.common.talent.SnifferDogTalent;
import doggytalents.common.talent.SwimmerDogTalent;
import doggytalents.common.talent.WaterHolderTalent;
import doggytalents.common.talent.WolfMountTalent;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.talent.talentclass.LowCostTalent;
import doggytalents.common.talent.talentclass.SingleLevelTalent;
import doggytalents.forge_imitate.registry.DeferredRegister;
import doggytalents.forge_imitate.registry.RegistryObject;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class DoggyTalents {
    public static final DeferredRegister<Talent> TALENTS = DeferredRegister.create(() -> DoggyTalentsAPI.TALENTS.get(), "doggytalents");
    public static final RegistryObject<Talent> BED_FINDER = DoggyTalents.registerInst("bed_finder", BedFinderTalent::new);
    public static final RegistryObject<Talent> BLACK_PELT = DoggyTalents.registerInst("black_pelt", BlackPeltTalent::new);
    public static final RegistryObject<Talent> CREEPER_SWEEPER = DoggyTalents.registerInst("creeper_sweeper", CreeperSweeperTalent::new);
    public static final RegistryObject<Talent> DOGGY_DASH = DoggyTalents.registerInst("doggy_dash", DoggyDashTalent::new);
    public static final RegistryObject<Talent> FISHER_DOG = DoggyTalents.registerInst("fisher_dog", FisherDogTalent::new);
    public static final RegistryObject<Talent> GUARD_DOG = DoggyTalents.registerInst("guard_dog", GuardDogTalent::new);
    public static final RegistryObject<Talent> HAPPY_EATER = DoggyTalents.registerInst("happy_eater", HappyEaterTalent::new);
    public static final RegistryObject<Talent> HELL_HOUND = DoggyTalents.registerInst("hell_hound", HellHoundTalent::new);
    public static final RegistryObject<Talent> HUNTER_DOG = DoggyTalents.registerInst("hunter_dog", null);
    public static final RegistryObject<Talent> PACK_PUPPY = DoggyTalents.registerInst("pack_puppy", PackPuppyTalent::new);
    public static final RegistryObject<Talent> PEST_FIGHTER = DoggyTalents.registerInst("pest_fighter", PestFighterTalent::new);
    public static final RegistryObject<Talent> PILLOW_PAW = DoggyTalents.register("pillow_paw", () -> new Talent(PillowPawTalent::new){

        @Override
        public boolean isDogEligible(AbstractDog dog) {
            return PillowPawTalent.isDogEligible(dog);
        }
    });
    public static final RegistryObject<Talent> POISON_FANG = DoggyTalents.registerInst("poison_fang", PoisonFangTalent::new);
    public static final RegistryObject<Talent> PUPPY_EYES = DoggyTalents.registerInst("puppy_eyes", PuppyEyesTalent::new);
    public static final RegistryObject<Talent> QUICK_HEALER = DoggyTalents.registerInst("quick_healer", QuickHealerTalent::new);
    public static final RegistryObject<Talent> RESCUE_DOG = DoggyTalents.registerInst("rescue_dog", RescueDogTalent::new);
    public static final RegistryObject<Talent> ROARING_GALE = DoggyTalents.registerInst("roaring_gale", RoaringGaleTalent::new);
    public static final RegistryObject<Talent> SHEPHERD_DOG = DoggyTalents.registerInst("shepherd_dog", ShepherdDogTalent::new);
    public static final RegistryObject<Talent> SWIMMER_DOG = DoggyTalents.registerInst("swimmer_dog", SwimmerDogTalent::new);
    public static final RegistryObject<Talent> WOLF_MOUNT = DoggyTalents.registerInst("wolf_mount", WolfMountTalent::new);
    public static final RegistryObject<Talent> DOGGY_TORCH = DoggyTalents.registerInst("doggy_torch", DoggyTorchTalent::new);
    public static final RegistryObject<LowCostTalent> DOGGY_ARMOR = DoggyTalents.register("doggy_armor", () -> new LowCostTalent(DoggyArmorTalent::new));
    public static final RegistryObject<Talent> WATER_HOLDER = DoggyTalents.register("water_holder", () -> new Talent(WaterHolderTalent::new));
    public static final RegistryObject<Talent> DOGGY_TOOLS = DoggyTalents.register("doggy_tools", () -> new Talent(DoggyToolsTalent::new));
    public static final RegistryObject<Talent> SHOCK_ABSORBER = DoggyTalents.register("shock_absorber", () -> new Talent(ShockAbsorberTalent::new));
    public static final RegistryObject<Talent> MOB_RETRIEVER = DoggyTalents.register("mob_retriever", () -> new Talent(MobRetrieverTalent::new));
    public static final RegistryObject<Talent> FLYING_FURBALL = DoggyTalents.register("flying_furball", () -> new Talent(FlyingFurballTalent::new){

        @Override
        public int getLevelCost(int toGoToLevel) {
            if (toGoToLevel == 1) {
                return 5;
            }
            return super.getLevelCost(toGoToLevel);
        }

        @Override
        public int getCummulativeCost(int level) {
            if (level <= 0) {
                return 0;
            }
            return level * (level + 1) / 2 + 4;
        }

        @Override
        public boolean isDogEligible(AbstractDog dog) {
            return dog.getDogLevel(PILLOW_PAW) <= 0 && dog.getDogLevel().getLevel(DogLevel.Type.KAMI) > 0;
        }

        @Override
        public Optional<String> getNonEligibleTranslationKey(AbstractDog dog) {
            if (dog.getDogLevel(PILLOW_PAW) > 0) {
                return Optional.empty();
            }
            return Optional.of(this.getTranslationKey() + ".dog_not_kami");
        }
    });
    public static final RegistryObject<Talent> CHEMI_CANINE = DoggyTalents.register("chemi_canine", () -> new Talent(ChemiCanineTalent::new){

        @Override
        public int getLevelCost(int toGoToLevel) {
            if (toGoToLevel == 1) {
                return 5;
            }
            return super.getLevelCost(toGoToLevel);
        }

        @Override
        public int getCummulativeCost(int level) {
            if (level <= 0) {
                return 0;
            }
            return level * (level + 1) / 2 + 4;
        }
    });
    public static final RegistryObject<Talent> FIRE_DRILL = DoggyTalents.register("fire_drill", () -> new SingleLevelTalent(FireDrillTalent::new));
    public static final RegistryObject<Talent> SNIFFER_DOG = DoggyTalents.register("sniffer_dog", () -> new Talent(SnifferDogTalent::new));
    public static final RegistryObject<Talent> GATE_PASSER = DoggyTalents.register("gate_passer", () -> new SingleLevelTalent(GatePasserTalent::new));
    public static final RegistryObject<Talent> OOKAMIKAZE = DoggyTalents.register("ookamikaze", () -> new Talent(OokamiKazeTalent::new){

        @Override
        public boolean isDogEligible(AbstractDog dog) {
            return dog.getDogLevel().getLevel(DogLevel.Type.KAMI) > 0;
        }

        @Override
        public Optional<String> getNonEligibleTranslationKey(AbstractDog dog) {
            return Optional.of(FLYING_FURBALL.get().getTranslationKey() + ".dog_not_kami");
        }
    });

    private static <T extends Talent> RegistryObject<Talent> registerInst(String name, BiFunction<Talent, Integer, TalentInstance> sup) {
        return DoggyTalents.register(name, () -> new Talent(sup));
    }

    private static <T extends Talent> RegistryObject<T> register(String name, Supplier<T> sup) {
        return TALENTS.register(name, sup);
    }
}

