/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.feature;

import doggytalents.api.inferface.AbstractDog;
import java.util.Arrays;
import java.util.Comparator;

public enum EnumMode {
    INJURED(-1, "incapacitated", false, false),
    DOCILE(0, "docile", true, false),
    WANDERING(1, "wandering", false, false, true),
    AGGRESIVE(2, "aggressive"),
    BERSERKER(3, "berserker"),
    BERSERKER_MINOR(4, "berserker_minor"),
    TACTICAL(5, "tactical"),
    PATROL(6, "patrol", false, true, true),
    GUARD(7, "guard"),
    GUARD_FLAT(8, "guard_flat"),
    GUARD_MINOR(9, "guard_minor");

    private int index;
    private boolean shouldFollowOwner = true;
    private boolean shouldAttack = true;
    private boolean canWander = false;
    private String saveName;
    private String unlocalisedTip;
    private String unlocalisedName;
    private String unlocalisedInfo;
    public static final EnumMode[] VALUES;

    private EnumMode(int index, String name) {
        this(index, name, true, true);
    }

    private EnumMode(int index, String name, boolean shouldFollowOwner, boolean shouldAttack) {
        this(index, name, "dog.mode." + name, "dog.mode." + name + ".indicator", "dog.mode." + name + ".description", shouldFollowOwner, shouldAttack);
    }

    private EnumMode(int index, String name, boolean shouldFollowOwner, boolean shouldAttack, boolean canWander) {
        this(index, name, "dog.mode." + name, "dog.mode." + name + ".indicator", "dog.mode." + name + ".description", shouldFollowOwner, shouldAttack);
        this.canWander = canWander;
    }

    private EnumMode(int index, String mode, String unlocalisedName, String tip, String info, boolean shouldFollowOwner, boolean shouldAttack) {
        this.index = index;
        this.saveName = mode;
        this.unlocalisedName = unlocalisedName;
        this.unlocalisedTip = tip;
        this.unlocalisedInfo = info;
        this.shouldFollowOwner = shouldFollowOwner;
        this.shouldAttack = shouldAttack;
    }

    public int getIndex() {
        return this.index;
    }

    public String getSaveName() {
        return this.saveName;
    }

    public String getTip() {
        return this.unlocalisedTip;
    }

    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    public String getUnlocalisedInfo() {
        return this.unlocalisedInfo;
    }

    public void onModeSet(AbstractDog dog, EnumMode prev) {
        switch (prev) {
            default: 
        }
        dog.method_5942().method_6340();
        dog.method_5980(null);
        dog.method_6015(null);
    }

    public EnumMode previousMode() {
        int i = this.getIndex() - 1;
        if (i < 0) {
            i = VALUES.length - 1;
        }
        return VALUES[i];
    }

    public EnumMode nextMode() {
        int i = this.getIndex() + 1;
        if (i >= VALUES.length) {
            i = 0;
        }
        return VALUES[i];
    }

    public boolean shouldFollowOwner() {
        return this.shouldFollowOwner;
    }

    public boolean shouldAttack() {
        return this.shouldAttack;
    }

    public boolean minorAttack() {
        return this == BERSERKER_MINOR || this == GUARD_FLAT;
    }

    public boolean canWander() {
        return this.canWander;
    }

    public static EnumMode byIndex(int i) {
        if (i == -1) {
            return INJURED;
        }
        if (i < 0 || i >= VALUES.length) {
            i = DOCILE.getIndex();
        }
        return VALUES[i];
    }

    public static EnumMode bySaveName(String saveName) {
        for (EnumMode gender : EnumMode.values()) {
            if (!gender.saveName.equals(saveName)) continue;
            return gender;
        }
        return DOCILE;
    }

    static {
        VALUES = (EnumMode[])Arrays.stream(EnumMode.values()).filter(x -> x.getIndex() >= 0).sorted(Comparator.comparingInt(EnumMode::getIndex)).toArray(EnumMode[]::new);
    }
}

