/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.impl;

import doggytalents.api.forge_imitate.inventory.ItemStackHandler;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class DogArmorItemHandler
extends ItemStackHandler {
    private AbstractDog dog;

    public DogArmorItemHandler(AbstractDog dog) {
        super(4);
        this.dog = dog;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2499 itemsList = new class_2499();
        for (int i = 0; i < this.stacks.size(); ++i) {
            class_1799 stack = (class_1799)this.stacks.get(i);
            if (stack.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10567("Slot", (byte)i);
            stack.method_7953(itemTag);
            itemsList.add((Object)itemTag);
        }
        class_2487 compound = new class_2487();
        compound.method_10566("dogArmors", (class_2520)itemsList);
        return compound;
    }

    @Override
    public void deserializeNBT(class_2487 compound) {
        if (compound.method_10573("dogArmors", 9)) {
            class_2499 tagList = compound.method_10554("dogArmors", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                class_2487 itemTag = tagList.method_10602(i);
                int slot = itemTag.method_10550("Slot");
                class_1799 stack = class_1799.method_7915((class_2487)itemTag);
                this.setArmorInSlot(stack);
            }
            this.onLoad();
        }
    }

    public void setArmorInSlot(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (!(item instanceof class_1738)) {
            return;
        }
        class_1738 armor = (class_1738)item;
        class_1304 slot = armor.method_48398().method_48399();
        this.setArmorInSlot(stack, slot);
    }

    public void setArmorInSlot(class_1799 stack, class_1304 slot) {
        DogArmorSlots dogSlot = DogArmorSlots.byEquipment(slot);
        if (dogSlot == null) {
            return;
        }
        this.stacks.set(dogSlot.slotId, (Object)stack);
    }

    public class_1799 getArmorFromSlot(class_1304 slot) {
        DogArmorSlots dogSlot = DogArmorSlots.byEquipment(slot);
        if (dogSlot == null) {
            return class_1799.field_8037;
        }
        return (class_1799)this.stacks.get(dogSlot.slotId);
    }

    public Iterable<class_1799> armors() {
        return this.stacks;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        if (!this.dog.canDogWearArmor()) {
            return false;
        }
        DogArmorSlots dogSlot = DogArmorSlots.bySlotId(slot);
        if (dogSlot == null) {
            return false;
        }
        class_1304 equip = dogSlot.val;
        class_1792 item = stack.method_7909();
        if (!(item instanceof class_1738)) {
            return false;
        }
        class_1738 armor = (class_1738)item;
        class_1304 wantSlot = armor.method_48398().method_48399();
        return wantSlot == equip;
    }

    public void onPropsUpdated(DogAlterationProps props) {
        if (props.canWearArmor()) {
            return;
        }
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.stacks.set(i, (Object)class_1799.field_8037);
        }
    }

    public static enum DogArmorSlots {
        HEAD(0, class_1304.field_6169),
        CHEST(1, class_1304.field_6174),
        LEGS(2, class_1304.field_6172),
        FEET(3, class_1304.field_6166);

        public final int slotId;
        public final class_1304 val;

        private DogArmorSlots(int slotId, class_1304 val) {
            this.slotId = slotId;
            this.val = val;
        }

        public static DogArmorSlots bySlotId(int slotId) {
            DogArmorSlots[] values;
            for (DogArmorSlots val : values = DogArmorSlots.values()) {
                if (val.slotId != slotId) continue;
                return val;
            }
            return null;
        }

        public static DogArmorSlots byEquipment(class_1304 slot) {
            DogArmorSlots[] values;
            for (DogArmorSlots val : values = DogArmorSlots.values()) {
                if (val.val != slot) continue;
                return val;
            }
            return null;
        }
    }
}

