/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.registry;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentOption;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class TalentInstance
implements IDogAlteration {
    protected final Talent talent;
    protected int level;

    public TalentInstance(Talent talentIn) {
        this(talentIn, 1);
    }

    public TalentInstance(Talent talentIn, int levelIn) {
        this.talent = talentIn;
        this.level = levelIn;
    }

    public Talent getTalent() {
        return this.talent;
    }

    public final int level() {
        return this.level;
    }

    public final void setLevel(int levelIn) {
        this.level = levelIn;
    }

    public boolean of(Supplier<Talent> talentIn) {
        return this.of(talentIn.get());
    }

    public boolean of(Talent talentIn) {
        return talentIn == this.talent;
    }

    public TalentInstance copy() {
        TalentInstance ret = this.talent.getDefault(this.level);
        ret.copyTalentOptionFrom(this);
        return ret;
    }

    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
    }

    public void readFromNBT(AbstractDog dogIn, class_2487 compound) {
    }

    public final void doReadFromNBT(AbstractDog dogIn, class_2487 compound) {
        this.setLevel(compound.method_10550("level"));
        this.readFromNBT(dogIn, compound);
    }

    public final void doWriteToNBT(AbstractDog dogIn, class_2487 compound) {
        compound.method_10569("level", this.level());
        this.writeToNBT(dogIn, compound);
    }

    public final void writeToBuf(class_2540 buf, BiConsumer<class_2540, TalentOption<?>> talent_option_writer) {
        buf.writeInt(this.level());
        Collection<TalentOption<?>> talent_options = this.getAllTalentOptions();
        if (talent_options.isEmpty()) {
            buf.writeInt(0);
            return;
        }
        buf.writeInt(talent_options.size());
        for (TalentOption<?> entry : talent_options) {
            talent_option_writer.accept(buf, entry);
            this.writeTalentOptionToBuf(buf, entry);
        }
    }

    private <T> void writeTalentOptionToBuf(class_2540 buf, TalentOption<T> entry) {
        T value = this.getTalentOptionOrDefault(entry);
        entry.encode(buf, value);
    }

    public final void readFromBuf(class_2540 buf, Function<class_2540, TalentOption<?>> talent_option_reader) {
        this.setLevel(buf.readInt());
        int talent_options_size = buf.readInt();
        if (talent_options_size <= 0) {
            return;
        }
        for (int i = 0; i < talent_options_size; ++i) {
            TalentOption<?> entry = talent_option_reader.apply(buf);
            this.readTalentOptionFromBuf(buf, entry);
        }
    }

    private <T> void readTalentOptionFromBuf(class_2540 buf, TalentOption<T> entry) {
        T value = entry.decode(buf);
        if (value == null) {
            value = entry.getDefault();
        }
        this.setTalentOption(entry, value);
    }

    public final void writeInstance(AbstractDog dogIn, class_2487 compound) {
        class_2960 rl = DoggyTalentsAPI.TALENTS.get().method_10221((Object)this.talent);
        if (rl != null) {
            compound.method_10582("type", rl.toString());
        }
        this.doWriteToNBT(dogIn, compound);
    }

    public static Optional<TalentInstance> readInstance(AbstractDog dogIn, class_2487 compound) {
        class_2960 rl = class_2960.method_12829((String)compound.method_10558("type"));
        if (DoggyTalentsAPI.TALENTS.get().method_10250(rl)) {
            TalentInstance inst = ((Talent)DoggyTalentsAPI.TALENTS.get().method_10223(rl)).getDefault();
            inst.doReadFromNBT(dogIn, compound);
            return Optional.of(inst);
        }
        DoggyTalentsAPI.LOGGER.warn("Failed to load talent {}", (Object)rl);
        return Optional.empty();
    }

    public <T extends TalentInstance> T cast(Class<T> type) {
        if (this.getClass().isAssignableFrom(type)) {
            return (T)this;
        }
        throw new RuntimeException("Could not cast " + this.getClass().getName() + " to " + type.getName());
    }

    public String toString() {
        return String.format("%s [talent: %s, level: %d]", this.getClass().getSimpleName(), DoggyTalentsAPI.TALENTS.get().method_10221((Object)this.talent), this.level);
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    public void set(AbstractDog dog, int levelBefore) {
    }

    public final <T> T getTalentOptionOrDefault(TalentOption<T> entry) {
        Object val = this.getTalentOption(entry);
        if (val == null) {
            val = entry.getDefault();
        }
        return (T)val;
    }

    public Object getTalentOption(TalentOption<?> entry) {
        return null;
    }

    public void setTalentOption(TalentOption<?> entry, Object data) {
    }

    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of();
    }

    public void copyTalentOptionFrom(TalentInstance other) {
        Collection<TalentOption<?>> entries = this.getAllTalentOptions();
        if (entries.isEmpty()) {
            return;
        }
        for (TalentOption<?> entry : entries) {
            this.doCopyTalentOption(other, entry);
        }
    }

    private <T> void doCopyTalentOption(TalentInstance other, TalentOption<T> entry) {
        T val = other.getTalentOptionOrDefault(entry);
        this.setTalentOption(entry, val);
    }

    public boolean hasRenderer() {
        return this.getTalent().hasRenderer();
    }
}

