/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import doggytalents.DoggyTalentsNext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.apache.commons.io.IOUtils;

public class CachedFileTexture
extends class_1049 {
    private File cacheFile;
    private boolean textureUploaded;

    public CachedFileTexture(class_2960 rlIn, File cacheFileIn) {
        super(rlIn);
        this.cacheFile = cacheFileIn;
    }

    private void setImage(class_1011 nativeImageIn) {
        class_310.method_1551().execute(() -> {
            this.textureUploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
            } else {
                this.upload(nativeImageIn);
            }
        });
    }

    private void upload(class_1011 imageIn) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)imageIn.method_4307(), (int)imageIn.method_4323());
        imageIn.method_4301(0, 0, 0, true);
    }

    public void method_4625(class_3300 manager) throws IOException {
        class_310.method_1551().execute(() -> {
            if (!this.textureUploaded) {
                class_1011 nativeimage = null;
                if (this.cacheFile.isFile() && this.cacheFile.exists()) {
                    DoggyTalentsNext.LOGGER.debug("Loading dog texture from local cache ({})", (Object)this.cacheFile);
                    FileInputStream fileinputstream = null;
                    try {
                        fileinputstream = new FileInputStream(this.cacheFile);
                        nativeimage = this.loadTexture(fileinputstream);
                    }
                    catch (FileNotFoundException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fileinputstream);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)fileinputstream);
                    }
                    IOUtils.closeQuietly((InputStream)fileinputstream);
                }
                if (nativeimage != null) {
                    this.setImage(nativeimage);
                } else {
                    DoggyTalentsNext.LOGGER.warn("Was unable to set image ({})", (Object)this.cacheFile);
                }
            }
        });
    }

    @Nullable
    private class_1011 loadTexture(InputStream inputStreamIn) {
        class_1011 nativeimage = null;
        try {
            nativeimage = class_1011.method_4309((InputStream)inputStreamIn);
        }
        catch (IOException ioexception) {
            DoggyTalentsNext.LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
        }
        return nativeimage;
    }
}

