/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7367;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DogTextureManager
extends class_4080<Preparations> {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents/dogSkin");
    public static final DogTextureManager INSTANCE = new DogTextureManager();
    private static final Gson GSON = new Gson();
    protected final Map<String, DogSkin> skinHashToLoc = Maps.newHashMap();
    protected final Map<DogSkin, String> locToSkinHash = Maps.newHashMap();
    protected final List<DogSkin> customSkinLoc = new ArrayList<DogSkin>(20);

    public List<DogSkin> getAll() {
        return Collections.unmodifiableList(this.customSkinLoc);
    }

    public DogSkin getDogSkin(String hash) {
        if (hash == null || hash.isEmpty()) {
            return DogSkin.CLASSICAL;
        }
        return this.skinHashToLoc.getOrDefault(hash, DogSkin.MISSING);
    }

    public String getHash(DogSkin loc) {
        if (loc == null || !loc.isCustom()) {
            return "";
        }
        return this.locToSkinHash.getOrDefault(loc, "");
    }

    public class_2960 getTexture(Dog dog) {
        DogSkin skin = dog.getClientSkin();
        if (skin != null && skin.isCustom()) {
            return skin.getPath();
        }
        return dog.dogVariant().texture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized RegisterState registerDogSkin(Preparations prep, class_3298 resource, DogSkin dogSkin) {
        RegisterState state = RegisterState.FAIL;
        InputStream inputstream = null;
        try {
            inputstream = resource.method_14482();
            String hash = this.computeHash(IOUtils.toByteArray((InputStream)inputstream));
            if (prep.skinHashToLoc.containsKey(hash)) {
                state = RegisterState.DUPLICATE;
            } else {
                prep.skinHashToLoc.put(hash, dogSkin);
                prep.locToSkinHash.put(dogSkin, hash);
                prep.customSkinLoc.add(dogSkin);
                state = RegisterState.SUCCESS;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
        return state;
    }

    public String computeHash(byte[] targetArray) {
        return Hashing.sha1().hashBytes(targetArray).toString();
    }

    protected Preparations prepare(class_3300 resourceManager, class_3695 profiler) {
        Preparations prep = new Preparations();
        profiler.method_16065();
        this.getSkinFromSkinJsonAllPack(resourceManager, prep);
        profiler.method_15407();
        profiler.method_16066();
        return prep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getSkinFromSkinJsonAllPack(class_3300 resMan, Preparations prep) {
        class_2960 SKIN_JSON_RES = Util.getResource("textures/entity/dog/skin.json");
        List jsonSkinPacks = resMan.method_29213().collect(Collectors.toList());
        for (class_3262 jsonSkinPack : jsonSkinPacks) {
            InputStream istream = null;
            try {
                class_7367 packRes = jsonSkinPack.method_14405(class_3264.field_14188, SKIN_JSON_RES);
                if (packRes == null) continue;
                istream = (InputStream)packRes.get();
                JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(istream, StandardCharsets.UTF_8), JsonElement.class);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                RegsiterResult result = this.getSkinFromSkinJson(resMan, prep, jsonObject);
                if (result.success > 0) {
                    LOGGER.info("Successfully registered " + result.success + " entries from pack [" + jsonSkinPack.method_14409() + "]");
                }
                if (result.duplicates > 0) {
                    LOGGER.warn("Pack [" + jsonSkinPack.method_14409() + "] contains " + result.duplicates + " duplicated entries. Those will be omitted.");
                }
                IOUtils.closeQuietly((InputStream)istream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(istream);
            }
        }
        this.getSkinJsonFromOtherMods(resMan, prep);
        prep.customSkinLoc.add(0, DogSkin.CLASSICAL);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSkinJsonFromOtherMods(class_3300 resMan, Preparations prep) {
        List<class_2960> paths = ClientSetup.OTHER_MOD_SKIN_JSONS;
        if (paths.isEmpty()) {
            return;
        }
        for (class_2960 path : paths) {
            InputStream istream = null;
            try {
                Optional res = resMan.method_14486(path);
                if (res.isEmpty()) continue;
                istream = ((class_3298)res.get()).method_14482();
                JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(istream, StandardCharsets.UTF_8), JsonElement.class);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                RegsiterResult result = this.getSkinFromSkinJson(resMan, prep, jsonObject);
                if (result.success > 0) {
                    LOGGER.info("Successfully registered " + result.success + " entries from path [" + path + "]");
                }
                if (result.duplicates > 0) {
                    LOGGER.warn("Path [" + path + "] contains " + result.duplicates + " duplicated entries. Those will be omitted.");
                }
                IOUtils.closeQuietly((InputStream)istream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(istream);
            }
        }
    }

    public RegsiterResult getSkinFromSkinJson(class_3300 resMan, Preparations prep, JsonObject jsonObject) {
        int success_cnt = 0;
        int duplicate_cnt = 0;
        int failed_cnt = 0;
        JsonArray skinEntries = jsonObject.get("dog_skins").getAsJsonArray();
        block4: for (JsonElement skinEntry : skinEntries) {
            DogSkin skin;
            JsonObject skinObject = skinEntry.getAsJsonObject();
            String name = skinObject.get("skin_name").getAsString();
            String id = skinObject.get("skin_id").getAsString();
            String use_model = skinObject.get("use_model").getAsString();
            class_2960 text_rl = id.indexOf(58) >= 0 ? new class_2960(id + ".png") : Util.getResource("textures/entity/dog/custom/" + id + ".png");
            if (use_model == null || use_model.equals("default") || use_model.equals("")) {
                skin = new DogSkin(text_rl).setName(name);
            } else if (use_model.equals("variant")) {
                JsonElement earOptional;
                dogModel = DogModelRegistry.getDogModelHolder(use_model);
                skin = dogModel == null ? new DogSkin(text_rl).setName(name) : new DogSkin(text_rl, dogModel).setName(name);
                JsonElement tailOptional = skinObject.get("tail_id");
                if (tailOptional != null) {
                    skin.setTail(tailOptional.getAsByte());
                }
                if ((earOptional = skinObject.get("ear_id")) != null) {
                    skin.setEar(earOptional.getAsByte());
                }
            } else {
                dogModel = DogModelRegistry.getDogModelHolder(use_model);
                skin = dogModel == null ? new DogSkin(text_rl).setName(name) : new DogSkin(text_rl, dogModel).setName(name);
            }
            this.readSkinExtraInfo(skin, skinObject);
            RegisterState state = RegisterState.FAIL;
            Optional res = resMan.method_14486(text_rl);
            if (res.isPresent()) {
                state = this.registerDogSkin(prep, (class_3298)res.get(), skin);
            }
            switch (state) {
                case SUCCESS: {
                    ++success_cnt;
                    continue block4;
                }
                case DUPLICATE: {
                    ++duplicate_cnt;
                    continue block4;
                }
            }
            ++failed_cnt;
        }
        return new RegsiterResult(success_cnt, duplicate_cnt, failed_cnt);
    }

    private void readSkinExtraInfo(DogSkin skin, JsonObject skinJsonObject) {
        JsonElement mystery;
        JsonElement tags;
        JsonElement desc;
        JsonElement based_on;
        JsonElement author = skinJsonObject.get("author");
        if (author != null) {
            skin.setAuthor(author.getAsString());
        }
        if ((based_on = skinJsonObject.get("based_on")) != null) {
            skin.setBasedOn(based_on.getAsString());
        }
        if ((desc = skinJsonObject.get("description")) != null) {
            skin.setDesc(desc.getAsString());
        }
        if ((tags = skinJsonObject.get("tags")) != null) {
            skin.setTags(tags.getAsString());
        }
        if ((mystery = skinJsonObject.get("mystery")) != null) {
            skin.setMystery(mystery.getAsBoolean());
        }
    }

    protected void apply(Preparations prep, class_3300 resourceManager, class_3695 profiler) {
        prep.apply(this);
    }

    public String method_22322() {
        return "DogTextureManager";
    }

    private static enum RegisterState {
        SUCCESS,
        DUPLICATE,
        FAIL;

    }

    protected static class Preparations {
        private final Map<String, DogSkin> skinHashToLoc = new HashMap<String, DogSkin>();
        private final Map<DogSkin, String> locToSkinHash = new HashMap<DogSkin, String>();
        private final List<DogSkin> customSkinLoc = new ArrayList<DogSkin>();

        protected Preparations() {
        }

        public void apply(DogTextureManager dogTextureManager) {
            dogTextureManager.skinHashToLoc.clear();
            dogTextureManager.customSkinLoc.clear();
            dogTextureManager.skinHashToLoc.putAll(this.skinHashToLoc);
            dogTextureManager.locToSkinHash.putAll(this.locToSkinHash);
            dogTextureManager.customSkinLoc.addAll(this.customSkinLoc);
        }
    }

    private record RegsiterResult(int success, int duplicates, int fail) {
    }
}

