/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.block.model;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.fabric_helper.block.dogbed.DogBedModelData;
import doggytalents.common.util.DogBedUtil;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.renderer.VanillaModelEncoder;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class DogBedModel
implements class_1087 {
    private static final class_2960 MISSING_TEXTURE = new class_2960("missingno");
    private class_1088 modelLoader;
    private class_793 model;
    private class_1087 bakedModel;
    private final Map<Triple<ICasingMaterial, IBeddingMaterial, class_2350>, class_1087> cache = Maps.newConcurrentMap();

    public DogBedModel(class_1088 modelLoader, class_793 model, class_1087 bakedModel) {
        this.modelLoader = modelLoader;
        this.model = model;
        this.bakedModel = bakedModel;
    }

    public class_1087 getModelVariant(@Nonnull DogBedModelData data) {
        return this.getModelVariant(data.casing(), data.bedding(), data.direction());
    }

    public class_1087 getModelVariant(ICasingMaterial casing, IBeddingMaterial bedding, class_2350 facing) {
        ImmutableTriple key = ImmutableTriple.of((Object)(casing != null ? casing : null), (Object)(bedding != null ? bedding : null), (Object)(facing != null ? facing : class_2350.field_11043));
        return this.cache.computeIfAbsent((Triple<ICasingMaterial, IBeddingMaterial, class_2350>)key, k -> this.bakeModelVariant((ICasingMaterial)k.getLeft(), (IBeddingMaterial)k.getMiddle(), (class_2350)k.getRight()));
    }

    public List<class_777> method_4707(class_2680 state, class_2350 side, class_5819 rand) {
        return this.getModelVariant(null, null, class_2350.field_11043).method_4707(state, side, rand);
    }

    public class_1087 bakeModelVariant(final @Nullable ICasingMaterial casingResource, final @Nullable IBeddingMaterial beddingResource, final @Nonnull class_2350 facing) {
        List parts = this.model.method_3433();
        ArrayList<class_785> elements = new ArrayList<class_785>(parts.size());
        for (class_785 part : parts) {
            elements.add(new class_785(part.field_4228, part.field_4231, (Map)Maps.newHashMap((Map)part.field_4230), part.field_4232, part.field_4229));
        }
        final class_793 newModel = new class_793(this.model.field_4247, elements, (Map)Maps.newHashMap((Map)this.model.field_4251), Boolean.valueOf(this.model.method_3444()), this.model.method_24298(), this.model.method_3443(), new ArrayList(this.model.method_3434()));
        newModel.field_4252 = this.model.field_4252;
        newModel.field_4253 = this.model.field_4253;
        Either<class_4730, String> casingTexture = this.findCasingTexture(casingResource);
        newModel.field_4251.put("bedding", this.findBeddingTexture(beddingResource));
        newModel.field_4251.put("casing", casingTexture);
        newModel.field_4251.put("particle", casingTexture);
        class_1087 newModelBaked = new class_7775(){

            public class_1100 method_45872(class_2960 p_252194_) {
                return newModel;
            }

            @Nullable
            public class_1087 method_45873(class_2960 p_250776_, class_3665 p_251280_) {
                return newModel.method_3446((class_7775)this, newModel, class_4730::method_24148, (class_3665)DogBedModel.this.getModelRotation(facing), DogBedModel.this.createResourceVariant(casingResource, beddingResource, facing), true);
            }
        }.method_45873(null, null);
        return newModelBaked;
    }

    private class_2960 createResourceVariant(@Nonnull ICasingMaterial casingResource, @Nonnull IBeddingMaterial beddingResource, @Nonnull class_2350 facing) {
        String beddingKey = beddingResource != null ? DogBedMaterialManager.getKey(beddingResource).toString().replace(':', '.') : "doggytalents.dogbed.bedding.missing";
        String casingKey = beddingResource != null ? DogBedMaterialManager.getKey(casingResource).toString().replace(':', '.') : "doggytalents.dogbed.casing.missing";
        return new class_1091(Util.getResource("block/dog_bed"), "#bedding=" + beddingKey + ",casing=" + casingKey + ",facing=" + facing.method_10151());
    }

    private Either<class_4730, String> findCasingTexture(@Nullable ICasingMaterial resource) {
        return this.findTexture(resource != null ? resource.getTexture() : null);
    }

    private Either<class_4730, String> findBeddingTexture(@Nullable IBeddingMaterial resource) {
        return this.findTexture(resource != null ? resource.getTexture() : null);
    }

    private Either<class_4730, String> findTexture(@Nullable class_2960 resource) {
        if (resource == null) {
            resource = MISSING_TEXTURE;
        }
        return Either.left((Object)new class_4730(class_1723.field_21668, resource));
    }

    private class_1086 getModelRotation(@Nonnull class_2350 dir) {
        switch (dir) {
            default: {
                return class_1086.field_5350;
            }
            case field_11034: {
                return class_1086.field_5366;
            }
            case field_11035: {
                return class_1086.field_5355;
            }
            case field_11039: 
        }
        return class_1086.field_5347;
    }

    public boolean method_4708() {
        return this.bakedModel.method_4708();
    }

    public boolean method_4712() {
        return this.bakedModel.method_4712();
    }

    public boolean method_24304() {
        return this.bakedModel.method_24304();
    }

    public boolean method_4713() {
        return this.bakedModel.method_4713();
    }

    public class_1058 method_4711() {
        return this.bakedModel.method_4711();
    }

    public class_809 method_4709() {
        return this.bakedModel.method_4709();
    }

    public class_806 method_4710() {
        return this.bakedModel.method_4710();
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_1920 dataGetter = blockView;
        Object data = dataGetter.getBlockEntityRenderData(pos);
        class_1087 bakedModel = null;
        if (data instanceof DogBedModelData) {
            DogBedModelData dogBedData = (DogBedModelData)data;
            bakedModel = this.getModelVariant(dogBedData);
        } else {
            bakedModel = this.getModelVariant(DogBedModelData.EMPTY);
        }
        VanillaModelEncoder.emitBlockQuads((class_1087)bakedModel, (class_2680)state, randomSupplier, (RenderContext)context, (QuadEmitter)context.getEmitter());
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        Pair<ICasingMaterial, IBeddingMaterial> bedMaterial = DogBedUtil.getMaterials(stack);
        class_1087 bakedModel = this.getModelVariant((ICasingMaterial)bedMaterial.getLeft(), (IBeddingMaterial)bedMaterial.getRight(), class_2350.field_11043);
        VanillaModelEncoder.emitItemQuads((class_1087)bakedModel, null, randomSupplier, (RenderContext)context);
    }
}

