/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.animation;

import doggytalents.client.entity.model.AnimatedSyncedAccessoryModel;
import doggytalents.client.entity.model.animation.SimpleAnimatedModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_630;
import net.minecraft.class_7179;
import net.minecraft.class_7184;
import net.minecraft.class_7186;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class DogKeyframeAnimations {
    public static void animate(DogModel model, Dog dog, class_7184 animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        float elapsed_in_seconds = DogKeyframeAnimations.getElapsedSeconds(animation, elapsed_in_millis);
        for (Map.Entry entry : animation.comp_599().entrySet()) {
            Optional<class_630> partOptional = model.searchForPartWithName((String)entry.getKey());
            if (partOptional.isEmpty()) continue;
            class_630 part = partOptional.get();
            model.resetPart(part, dog);
            List channelList = (List)entry.getValue();
            for (class_7179 channel : channelList) {
                class_7186[] keyframes = channel.comp_596();
                int currentKeyframeIndx = Math.max(0, class_3532.method_15360((int)0, (int)keyframes.length, compare_indx -> elapsed_in_seconds <= keyframes[compare_indx].comp_600()) - 1);
                int nextKeyframeIndx = Math.min(keyframes.length - 1, currentKeyframeIndx + 1);
                class_7186 currentKeyframe = keyframes[currentKeyframeIndx];
                class_7186 nextKeyframe = keyframes[nextKeyframeIndx];
                float passed_time_since_current = elapsed_in_seconds - currentKeyframe.comp_600();
                float duration_between = nextKeyframe.comp_600() - currentKeyframe.comp_600();
                float passed_progress = 0.0f;
                if (duration_between > 0.0f) {
                    passed_progress = class_3532.method_15363((float)(passed_time_since_current / duration_between), (float)0.0f, (float)1.0f);
                }
                nextKeyframe.comp_602().apply(temp_buffer, passed_progress, keyframes, currentKeyframeIndx, nextKeyframeIndx, interpolation_scale);
                channel.comp_595().apply(part, temp_buffer);
                model.adjustAnimatedPart(part, dog);
            }
        }
    }

    public static void animate(AnimatedSyncedAccessoryModel model, Dog dog, class_7184 animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        float elapsed_in_seconds = DogKeyframeAnimations.getElapsedSeconds(animation, elapsed_in_millis);
        for (Map.Entry entry : animation.comp_599().entrySet()) {
            Optional<class_630> partOptional = model.searchForPartWithName((String)entry.getKey());
            if (partOptional.isEmpty()) continue;
            class_630 part = partOptional.get();
            model.resetPart(part, dog);
            List channelList = (List)entry.getValue();
            for (class_7179 channel : channelList) {
                class_7186[] keyframes = channel.comp_596();
                int currentKeyframeIndx = Math.max(0, class_3532.method_15360((int)0, (int)keyframes.length, compare_indx -> elapsed_in_seconds <= keyframes[compare_indx].comp_600()) - 1);
                int nextKeyframeIndx = Math.min(keyframes.length - 1, currentKeyframeIndx + 1);
                class_7186 currentKeyframe = keyframes[currentKeyframeIndx];
                class_7186 nextKeyframe = keyframes[nextKeyframeIndx];
                float passed_time_since_current = elapsed_in_seconds - currentKeyframe.comp_600();
                float duration_between = nextKeyframe.comp_600() - currentKeyframe.comp_600();
                float passed_progress = 0.0f;
                if (duration_between > 0.0f) {
                    passed_progress = class_3532.method_15363((float)(passed_time_since_current / duration_between), (float)0.0f, (float)1.0f);
                }
                nextKeyframe.comp_602().apply(temp_buffer, passed_progress, keyframes, currentKeyframeIndx, nextKeyframeIndx, interpolation_scale);
                channel.comp_595().apply(part, temp_buffer);
            }
        }
    }

    public static void animateSimple(SimpleAnimatedModel model, class_7184 animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        float elapsed_in_seconds = DogKeyframeAnimations.getElapsedSeconds(animation, elapsed_in_millis);
        for (Map.Entry entry : animation.comp_599().entrySet()) {
            Optional<class_630> partOptional = model.getPartFromName((String)entry.getKey());
            if (partOptional.isEmpty()) continue;
            class_630 part = partOptional.get();
            model.resetPart(part);
            List channelList = (List)entry.getValue();
            for (class_7179 channel : channelList) {
                class_7186[] keyframes = channel.comp_596();
                int currentKeyframeIndx = Math.max(0, class_3532.method_15360((int)0, (int)keyframes.length, compare_indx -> elapsed_in_seconds <= keyframes[compare_indx].comp_600()) - 1);
                int nextKeyframeIndx = Math.min(keyframes.length - 1, currentKeyframeIndx + 1);
                class_7186 currentKeyframe = keyframes[currentKeyframeIndx];
                class_7186 nextKeyframe = keyframes[nextKeyframeIndx];
                float passed_time_since_current = elapsed_in_seconds - currentKeyframe.comp_600();
                float duration_between = nextKeyframe.comp_600() - currentKeyframe.comp_600();
                float passed_progress = 0.0f;
                if (duration_between > 0.0f) {
                    passed_progress = class_3532.method_15363((float)(passed_time_since_current / duration_between), (float)0.0f, (float)1.0f);
                }
                nextKeyframe.comp_602().apply(temp_buffer, passed_progress, keyframes, currentKeyframeIndx, nextKeyframeIndx, interpolation_scale);
                channel.comp_595().apply(part, temp_buffer);
            }
        }
    }

    public static float getCurrentAnimatedYRot(Dog dog, class_7184 animation, long elapsed_in_millis, float interpolation_scale) {
        float elapsed_in_seconds = DogKeyframeAnimations.getElapsedSeconds(animation, elapsed_in_millis);
        List rootChannelList = (List)animation.comp_599().get("root");
        if (rootChannelList == null || rootChannelList.isEmpty()) {
            return 0.0f;
        }
        class_7179 rotationChannel = null;
        for (class_7179 channel : rootChannelList) {
            if (channel.comp_595() != class_7179.class_7183.field_37887) continue;
            rotationChannel = channel;
        }
        if (rotationChannel == null) {
            return 0.0f;
        }
        class_7186[] keyframes = rotationChannel.comp_596();
        int currentKeyframeIndx = Math.max(0, class_3532.method_15360((int)0, (int)keyframes.length, compare_indx -> elapsed_in_seconds <= keyframes[compare_indx].comp_600()) - 1);
        int nextKeyframeIndx = Math.min(keyframes.length - 1, currentKeyframeIndx + 1);
        class_7186 currentKeyframe = keyframes[currentKeyframeIndx];
        class_7186 nextKeyframe = keyframes[nextKeyframeIndx];
        float passed_time_since_current = elapsed_in_seconds - currentKeyframe.comp_600();
        float duration_between = nextKeyframe.comp_600() - currentKeyframe.comp_600();
        float passed_progress = 0.0f;
        if (duration_between > 0.0f) {
            passed_progress = class_3532.method_15363((float)(passed_time_since_current / duration_between), (float)0.0f, (float)1.0f);
        }
        Vector3f result = new Vector3f(0.0f, 0.0f, 0.0f);
        nextKeyframe.comp_602().apply(result, passed_progress, keyframes, currentKeyframeIndx, nextKeyframeIndx, interpolation_scale);
        return result.y;
    }

    private static float getElapsedSeconds(class_7184 animation, long raw_seconds) {
        float f = (float)raw_seconds / 1000.0f;
        return animation.comp_598() ? f % animation.comp_597() : f;
    }
}

