/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer.accessory;

import doggytalents.api.inferface.IColoredObject;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.DogFrontLegsSeperate;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_922;

public class DefaultAccessoryRenderer
extends class_3887<Dog, DogModel> {
    private DogModel defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();
    private DogFrontLegsSeperate hindLegDiffTextModel;

    public DefaultAccessoryRenderer(class_3883 parentRenderer, class_5617.class_5618 ctx) {
        super(parentRenderer);
        this.hindLegDiffTextModel = new DogFrontLegsSeperate(ctx.method_32167(ClientSetup.DOG_FRONT_LEGS_SEPERATE));
    }

    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!dog.method_6181() || dog.method_5767()) {
            return;
        }
        for (AccessoryInstance accessoryInst : dog.getClientSortedAccessories()) {
            Accessory accessory;
            DogModel model;
            DogSkin skin = dog.getClientSkin();
            if (skin.useCustomModel() && !(model = skin.getCustomModel().getValue()).acessoryShouldRender(dog, accessoryInst) || !(accessory = accessoryInst.getAccessory()).shouldRender() || !this.isOverlay(accessory)) continue;
            if (accessory.hasHindLegDiffTex()) {
                this.renderHindLegDifferentAccessory(poseStack, buffer, packedLight, dog, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, accessoryInst);
                continue;
            }
            this.renderNormalAccessory(poseStack, buffer, packedLight, dog, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, accessoryInst);
        }
    }

    private void renderNormalAccessory(class_4587 poseStack, class_4597 buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, AccessoryInstance accessoryInst) {
        DogModel dogModel;
        DogModel parentModel = (DogModel)this.method_17165();
        if (parentModel.useDefaultModelForAccessories()) {
            dogModel = this.defaultModel;
            parentModel.method_17081(dogModel);
            dogModel.copyFrom(parentModel);
        } else {
            dogModel = parentModel;
        }
        class_2960 texture_rl = accessoryInst.getModelTexture(dog);
        boolean isTranslucent = this.isAcceossryRenderTranslucent(accessoryInst.getAccessory());
        if (texture_rl == null) {
            return;
        }
        boolean tailVisible0 = dogModel.tail.field_3665;
        if (dog.getClientSkin().useCustomModel()) {
            dogModel.tail.field_3665 = false;
        }
        if (accessoryInst instanceof IColoredObject) {
            IColoredObject coloredObject = (IColoredObject)((Object)accessoryInst);
            float[] color = coloredObject.getColor();
            if (isTranslucent) {
                DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, color[0], color[1], color[2], 1.0f);
            } else {
                class_3887.method_23199((class_583)dogModel, (class_2960)texture_rl, (class_4587)poseStack, (class_4597)buffer, (int)packedLight, (class_1309)dog, (float)color[0], (float)color[1], (float)color[2]);
            }
        } else if (isTranslucent) {
            DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            class_3887.method_23199((class_583)dogModel, (class_2960)texture_rl, (class_4587)poseStack, (class_4597)buffer, (int)packedLight, (class_1309)dog, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        dogModel.tail.field_3665 = tailVisible0;
    }

    private void renderHindLegDifferentAccessory(class_4587 poseStack, class_4597 buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, AccessoryInstance accessoryInst) {
        float[] color;
        IColoredObject coloredObject;
        DogModel parentModel = (DogModel)this.method_17165();
        DogModel dogModel = parentModel.useDefaultModelForAccessories() ? this.defaultModel : parentModel;
        if (dogModel != parentModel) {
            ((DogModel)this.method_17165()).method_17081(dogModel);
            dogModel.copyFrom(parentModel);
        }
        class_2960 texture_rl = accessoryInst.getModelTexture(dog);
        boolean isTranslucent = this.isAcceossryRenderTranslucent(accessoryInst.getAccessory());
        if (texture_rl == null) {
            return;
        }
        boolean tailVisible0 = dogModel.tail.field_3665;
        if (dog.getClientSkin().useCustomModel()) {
            dogModel.tail.field_3665 = false;
        }
        boolean rightFrontLegVisible0 = dogModel.legFrontRight.field_3665;
        boolean leftFrontLegVisible0 = dogModel.legFrontLeft.field_3665;
        dogModel.legFrontLeft.field_3665 = false;
        dogModel.legFrontRight.field_3665 = false;
        if (accessoryInst instanceof IColoredObject) {
            coloredObject = (IColoredObject)((Object)accessoryInst);
            color = coloredObject.getColor();
            if (isTranslucent) {
                DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, color[0], color[1], color[2], 1.0f);
            } else {
                class_3887.method_23199((class_583)dogModel, (class_2960)texture_rl, (class_4587)poseStack, (class_4597)buffer, (int)packedLight, (class_1309)dog, (float)color[0], (float)color[1], (float)color[2]);
            }
        } else if (isTranslucent) {
            DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            class_3887.method_23199((class_583)dogModel, (class_2960)texture_rl, (class_4587)poseStack, (class_4597)buffer, (int)packedLight, (class_1309)dog, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        dogModel.tail.field_3665 = tailVisible0;
        dogModel.legFrontRight.field_3665 = rightFrontLegVisible0;
        dogModel.legFrontLeft.field_3665 = leftFrontLegVisible0;
        dogModel.method_17081(this.hindLegDiffTextModel);
        this.hindLegDiffTextModel.sync(dogModel);
        if (accessoryInst instanceof IColoredObject) {
            coloredObject = (IColoredObject)((Object)accessoryInst);
            color = coloredObject.getColor();
            if (isTranslucent) {
                DefaultAccessoryRenderer.renderTranslucentModel(this.hindLegDiffTextModel, texture_rl, poseStack, buffer, packedLight, dog, color[0], color[1], color[2], 1.0f);
            } else {
                class_3887.method_23199((class_583)this.hindLegDiffTextModel, (class_2960)texture_rl, (class_4587)poseStack, (class_4597)buffer, (int)packedLight, (class_1309)dog, (float)color[0], (float)color[1], (float)color[2]);
            }
        } else if (isTranslucent) {
            DefaultAccessoryRenderer.renderTranslucentModel(this.hindLegDiffTextModel, texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            class_3887.method_23199((class_583)this.hindLegDiffTextModel, (class_2960)texture_rl, (class_4587)poseStack, (class_4597)buffer, (int)packedLight, (class_1309)dog, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public boolean isOverlay(Accessory accessory) {
        Accessory.AccessoryRenderType type = accessory.getAccessoryRenderType();
        return type == Accessory.AccessoryRenderType.OVERLAY || type == Accessory.AccessoryRenderType.OVERLAY_AND_MODEL;
    }

    public boolean isAcceossryRenderTranslucent(Accessory accessory) {
        if (((Boolean)ConfigHandler.CLIENT.TRANSLUCENT_ALL_OVERLAY.get()).booleanValue()) {
            return true;
        }
        return accessory.renderTranslucent();
    }

    public static <T extends class_1309> void renderTranslucentModel(class_583<T> p_117377_, class_2960 p_117378_, class_4587 p_117379_, class_4597 p_117380_, int p_117381_, T p_117382_, float p_117383_, float p_117384_, float p_117385_, float opascity) {
        class_4588 vertexconsumer = p_117380_.getBuffer(class_1921.method_23580((class_2960)p_117378_));
        p_117377_.method_2828(p_117379_, vertexconsumer, p_117381_, class_922.method_23622(p_117382_, (float)0.0f), p_117383_, p_117384_, p_117385_, opascity);
    }
}

