/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.client.entity.model.animation.DogAnimationRegistry;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.client.screen.DogNewInfoScreen.DogNewInfoScreen;
import doggytalents.client.screen.DogNewInfoScreen.store.UIActionTypes;
import doggytalents.client.screen.DogNewInfoScreen.store.slice.TalentChangeHandlerSlice;
import doggytalents.client.screen.framework.Store;
import doggytalents.client.screen.framework.UIAction;
import doggytalents.client.screen.widget.DogInventoryButton;
import doggytalents.client.screen.widget.DoggySpin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationState;
import doggytalents.common.fabric_helper.util.FabricUtil;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogMountData;
import doggytalents.common.network.packet.data.DogSyncData;
import doggytalents.common.network.packet.data.WhistleUseData;
import doggytalents.common.util.InventoryUtil;
import doggytalents.forge_imitate.event.client.InputEvent;
import doggytalents.forge_imitate.event.client.MovementInputUpdateEvent;
import doggytalents.forge_imitate.event.client.ScreenEvent;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3928;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_638;
import net.minecraft.class_7184;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_761;

public class ClientEventHandler {
    DogInventoryButton activeInventoryButton;
    private DoggySpin spinWidget = new DoggySpin(0, 0, 128);

    public void onInputEvent(MovementInputUpdateEvent event) {
        if (!event.getInput().field_3904) {
            return;
        }
        class_746 entity = event.getEntity();
        class_1297 vehicle = entity.method_5854();
        if (!entity.method_5765()) {
            return;
        }
        if (!(vehicle instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)vehicle;
        if (!dog.canJump()) {
            return;
        }
        dog.setJumpPower(100);
    }

    public void onScreenInit(ScreenEvent.Init.Post event) {
        if (!((Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.DOG_INV_BUTTON_IN_INV)).booleanValue()) {
            return;
        }
        class_437 screen = event.getScreen();
        if (screen instanceof class_490 || screen instanceof class_481) {
            boolean creative = screen instanceof class_481;
            class_310 mc = class_310.method_1551();
            int width = mc.method_22683().method_4486();
            int height = mc.method_22683().method_4502();
            int sizeX = creative ? 195 : 176;
            int sizeY = creative ? 136 : 166;
            int guiLeft = (width - sizeX) / 2;
            int guiTop = (height - sizeY) / 2;
            int x = guiLeft + (creative ? 36 : sizeX / 2 - 10);
            int y = guiTop + (creative ? 7 : 48);
            this.activeInventoryButton = new DogInventoryButton(x, y, screen);
            event.addListener(this.activeInventoryButton);
        }
        if (event.getScreen() instanceof class_3928) {
            this.spinWidget.chooseStyle();
        }
    }

    public void onScreenDrawForeground(ScreenEvent.Render.Post event) {
        if (!((Boolean)ConfigHandler.CLIENT.WORD_LOAD_ICON.get()).booleanValue()) {
            return;
        }
        if (!(event.getScreen() instanceof class_3928)) {
            return;
        }
        this.spinWidget.method_46419(event.getScreen().field_22790 - 128);
        this.spinWidget.method_25394(event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick());
    }

    public void onKeyboardInput(InputEvent.Key event) {
        this.proccessWhistle(event);
    }

    public void proccessWhistle(InputEvent.Key event) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        WhistleItem whistle = DoggyItems.WHISTLE.get();
        class_1799 whistle_stack = InventoryUtil.findStackWithItemFromHands((class_1657)player, whistle);
        if (whistle_stack == null) {
            return;
        }
        int hotkey_use = FabricUtil.getWhistleKey((class_1657)player, event.keyCode);
        if (hotkey_use < 0) {
            return;
        }
        if (player.method_7357().method_7904((class_1792)whistle)) {
            return;
        }
        class_2487 tag = whistle_stack.method_7969();
        if (tag == null) {
            return;
        }
        int[] hotkeyarr = tag.method_10561("hotkey_modes");
        if (hotkeyarr == null) {
            return;
        }
        if (hotkeyarr.length != 4) {
            return;
        }
        int mode_id = hotkeyarr[hotkey_use];
        WhistleItem.WhistleMode[] whistle_modes = WhistleItem.WhistleMode.VALUES;
        if (mode_id >= whistle_modes.length) {
            return;
        }
        if (mode_id < 0) {
            return;
        }
        WhistleItem.WhistleMode useMode = whistle_modes[mode_id];
        List dogsList = player.method_37908().method_8390(Dog.class, player.method_5829().method_1009(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.method_6171((class_1309)player));
        whistle.useMode(useMode, dogsList, player.method_37908(), (class_1657)player, class_1268.field_5808, true);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new WhistleUseData(mode_id));
        class_304 keyHotbarSlots = mc.field_1690.field_1852[hotkey_use];
        if (keyHotbarSlots.method_1417(event.keyCode, event.scanCode)) {
            keyHotbarSlots.method_1436();
        }
    }

    public void drawSelectionBox(class_4587 matrixStackIn, class_1657 player, float particleTicks, class_238 boundingBox) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f);
        RenderSystem.lineWidth((float)2.0f);
        class_243 vec3d = class_310.method_1551().field_1773.method_19418().method_19326();
        double d0 = vec3d.method_10216();
        double d1 = vec3d.method_10214();
        double d2 = vec3d.method_10215();
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        class_761.method_22982((class_4587)matrixStackIn, (class_4588)bufferbuilder, (class_238)boundingBox.method_989(-d0, -d1, -d2), (float)1.0f, (float)1.0f, (float)0.0f, (float)0.8f);
        class_289.method_1348().method_1350();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void onDogMountEvent(DogMountData data) {
        class_310 mc = class_310.method_1551();
        class_1297 e = mc.field_1687.method_8469(data.dogId);
        class_746 player = mc.field_1724;
        if (e instanceof Dog) {
            Dog d = (Dog)e;
            if (data.mount && player != null) {
                d.method_5804((class_1297)player);
            } else {
                d.method_5848();
            }
        }
    }

    public static boolean vertifyBlockTexture(class_2960 loc) {
        class_2960 path = ClientEventHandler.getAbsoluteBlockTexture(loc);
        Optional res = class_310.method_1551().method_1478().method_14486(path);
        return res.isPresent();
    }

    public static class_2960 getAbsoluteBlockTexture(class_2960 loc) {
        return new class_2960(loc.method_12836(), "textures/" + loc.method_12832() + ".png");
    }

    public static boolean vertifyArmorTexture(class_2960 loc) {
        Optional res = class_310.method_1551().method_1478().method_14486(loc);
        return res.isPresent();
    }

    public static boolean shouldClientBlockPick(Dog dog) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        if (!dog.method_5782()) {
            return false;
        }
        return player.method_5854() == dog || player.method_5715();
    }

    public static float getAnimatedYRot(Dog dog) {
        if (dog.getAnim() == DogAnimation.NONE) {
            return 0.0f;
        }
        DogAnimation anim = dog.getAnim();
        class_7184 animSeq = DogAnimationRegistry.getSequence(anim);
        DogAnimationState animState = dog.animationManager.animationState;
        float ret = DogKeyframeAnimations.getCurrentAnimatedYRot(dog, animSeq, animState.getAccumulatedTimeMillis(), 1.0f);
        if (anim.rootRotation().isPresent()) {
            Float root_rotation = anim.rootRotation().get();
            ret += root_rotation.floatValue() * ((float)Math.PI / 180);
        }
        return ret;
    }

    public static void onDogSyncedDataUpdated(DogSyncData data) {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            return;
        }
        class_1297 e = level.method_8469(data.dogId);
        if (!(e instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)e;
        dog.dogSyncedDataManager.updateFromDataPacketFromServer(data);
    }

    public static void onDogTalentUpdated(Dog dog) {
        class_310 mc = class_310.method_1551();
        class_437 screen = mc.field_1755;
        if (screen == null) {
            return;
        }
        if (!(screen instanceof DogNewInfoScreen)) {
            return;
        }
        DogNewInfoScreen infoScr = (DogNewInfoScreen)screen;
        if (infoScr.dog != dog) {
            return;
        }
        Store.get(infoScr).dispatch(TalentChangeHandlerSlice.class, new UIAction(UIActionTypes.Talents.TALENT_UPDATE, null));
    }
}

