/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.StatsView.view;

import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.widget.TextOnlyButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.stats.StatsTracker;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class MobKillsView
extends AbstractElement {
    static final int PADDING_LEFT = 5;
    static final int PADDING_RIGHT = 30;
    static final int PADDING_TOP = 5;
    static final int LINE_SPACING = 3;
    private StatsTracker stats;
    private class_327 font;
    private Dog dog;
    private int maxEntryFit;
    private int maxPageNum;
    private int startIndex = 0;
    private int pageIndex = 0;
    private TextOnlyButton lastPage;
    private TextOnlyButton nextPage;

    public MobKillsView(AbstractElement parent, class_437 screen, Dog dog, StatsTracker stats, class_327 font) {
        super(parent, screen);
        this.stats = stats;
        this.font = font;
        this.dog = dog;
    }

    @Override
    public AbstractElement init() {
        this.maxEntryFit = this.getNumOfFitEntries(this.getSizeY());
        this.maxPageNum = this.calculatePagesNum(this.getSizeY(), this.stats.getAllKillCount().size());
        int mX = this.getSizeX() / 2;
        this.lastPage = new TextOnlyButton(this.getRealX() + mX - 30 - 20, this.getRealY() + this.getSizeY() - 20 - 5, 20, 20, (class_2561)class_2561.method_43470((String)"<"), b -> {
            this.startIndex -= this.maxEntryFit;
            --this.pageIndex;
            if (this.pageIndex < 0) {
                this.pageIndex = 0;
            }
        }, this.font);
        this.addChildren((class_364)this.lastPage);
        this.nextPage = new TextOnlyButton(this.getRealX() + mX + 30, this.getRealY() + this.getSizeY() - 20 - 5, 20, 20, (class_2561)class_2561.method_43470((String)">"), b -> {
            this.startIndex += this.maxEntryFit;
            ++this.pageIndex;
            if (this.pageIndex > this.maxPageNum) {
                this.pageIndex = this.maxPageNum;
            }
        }, this.font);
        this.addChildren((class_364)this.nextPage);
        return this;
    }

    @Override
    public void renderElement(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        Map<class_1299<?>, Integer> mobKillMap = this.stats.getAllKillCount();
        int startX = this.getRealX() + 5;
        int pY = this.getRealY() + 5;
        if (mobKillMap.isEmpty()) {
            String str = class_1074.method_4662((String)"doggui.stats.mob_kills.no_kills", (Object[])new Object[]{this.dog.method_5477().getString()});
            graphics.method_25303(this.font, str, startX, pY, -1);
            this.lastPage.field_22763 = false;
            this.nextPage.field_22763 = false;
            return;
        }
        this.lastPage.field_22763 = this.startIndex > 0;
        this.nextPage.field_22763 = false;
        int tillStart = this.startIndex = Math.max(0, this.startIndex);
        int entryDrawm = 0;
        for (Map.Entry<class_1299<?>, Integer> entry : mobKillMap.entrySet()) {
            if (--tillStart >= 0) continue;
            if (entryDrawm >= this.maxEntryFit) {
                this.nextPage.field_22763 = true;
                break;
            }
            class_5250 mobName = entry.getKey().method_5897().method_27661();
            mobName.method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
            Integer kills = entry.getValue();
            graphics.method_27535(this.font, (class_2561)mobName, startX, pY, -1);
            Objects.requireNonNull(this.font);
            String killSentence = this.dog.method_5477().getString() + " has killed " + kills + " " + mobName.getString();
            graphics.method_25303(this.font, killSentence, startX, pY += 9 + 3, -1);
            Objects.requireNonNull(this.font);
            pY += 9 + 3;
            ++entryDrawm;
        }
        if (entryDrawm <= 0 && this.startIndex > 0) {
            this.startIndex = 0;
        }
        int mX = this.getSizeX() / 2;
        String txt = this.pageIndex + 1 + "/" + this.maxPageNum;
        int tX = this.getRealX() + mX - this.font.method_1727(txt) / 2;
        int tY = this.getRealY() + this.getSizeY() - 19;
        graphics.method_25303(this.font, txt, tX, tY, -1);
    }

    private int getOneEntrySize() {
        Objects.requireNonNull(this.font);
        return 9 * 2 + 6;
    }

    private int getNumOfFitEntries(int sizeY) {
        return sizeY / this.getOneEntrySize() - 1;
    }

    private int calculatePagesNum(int sizeY, int entriesNum) {
        return class_3532.method_15386((float)((float)entriesNum / (float)this.getNumOfFitEntries(sizeY)));
    }
}

