/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.framework.widget.TextOnlyButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class StringEntrySelectScreen
extends class_437 {
    private List<String> entries = new ArrayList<String>();
    private List<Integer> filteredIndexes = new ArrayList<Integer>();
    private int pageCount = 1;
    private int activePage = 0;
    private int selectedEntryInPage = 0;
    private String searchString = "";
    private boolean startedUpdatingMouseMove = false;
    private int mouseX0 = 0;
    private int mouseY0 = 0;
    private long blockCharInputMillis = 0L;
    private long prevMillis = 0L;
    private TextOnlyButton prevPageButton;
    private TextOnlyButton nextPageButton;

    public StringEntrySelectScreen(class_2561 title) {
        super(title);
    }

    public void method_25426() {
        super.method_25426();
        this.addPageButtons();
    }

    protected void addPageButtons() {
        int half_width = this.field_22789 / 2;
        int half_height = this.field_22790 / 2;
        TextOnlyButton prevPage = new TextOnlyButton(half_width - this.getSelectAreaSize() / 2 - 20, half_height - 10, 20, 20, (class_2561)class_2561.method_43470((String)"<"), b -> this.prevPage(), this.field_22793);
        TextOnlyButton nextPage = new TextOnlyButton(half_width + this.getSelectAreaSize() / 2, half_height - 10, 20, 20, (class_2561)class_2561.method_43470((String)">"), b -> this.nextPage(), this.field_22793);
        prevPage.field_22763 = this.activePage > 0;
        nextPage.field_22763 = this.activePage < this.pageCount - 1;
        this.prevPageButton = prevPage;
        this.nextPageButton = nextPage;
        this.method_37063((class_364)prevPage);
        this.method_37063((class_364)nextPage);
    }

    protected void nextPage() {
        this.activePage = class_3532.method_15340((int)(this.activePage + 1), (int)0, (int)(this.pageCount - 1));
        this.onPageUpdated();
    }

    protected void prevPage() {
        this.activePage = class_3532.method_15340((int)(this.activePage - 1), (int)0, (int)(this.pageCount - 1));
        this.onPageUpdated();
    }

    protected void onPageUpdated() {
        this.selectedEntryInPage = 0;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.updateBlockCharInputMillis();
        if (this.startedUpdatingMouseMove) {
            this.updateMouseMoved(mouseX, mouseY);
        } else {
            this.mayStartUpdatingMouseMove(mouseX, mouseY);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.drawSelectArea(graphics);
        this.drawSearchBar(graphics);
        this.drawPageIndicator(graphics);
        this.prevPageButton.field_22763 = this.activePage > 0;
        this.nextPageButton.field_22763 = this.activePage < this.pageCount - 1;
    }

    private void updateBlockCharInputMillis() {
        if (this.blockCharInputMillis <= 0L) {
            return;
        }
        long passed = System.currentTimeMillis() - this.prevMillis;
        if (passed > 0L) {
            this.blockCharInputMillis -= passed;
            this.prevMillis = System.currentTimeMillis();
        }
    }

    private void updateMouseMoved(int mouseX, int mouseY) {
        boolean mouse_moved;
        boolean bl = mouse_moved = this.mouseX0 != mouseX || this.mouseY0 != mouseY;
        if (!mouse_moved) {
            return;
        }
        this.onMouseMoved(mouseX, mouseY);
        this.mouseX0 = mouseX;
        this.mouseY0 = mouseY;
    }

    private void mayStartUpdatingMouseMove(int mouseX, int mouseY) {
        int half_width = this.field_22789 / 2;
        int half_height = this.field_22790 / 2;
        int dx = Math.abs(mouseX - half_width);
        int dy = Math.abs(mouseY - half_height);
        if (dx > 10 || dy > 10) {
            this.startedUpdatingMouseMove = true;
            this.mouseX0 = mouseX;
            this.mouseY0 = mouseY;
        }
    }

    protected void onMouseMoved(double mouseX, double mouseY) {
        int newIndx = this.getHoveredIndex(mouseX, mouseY, this.getCurrentPageEntries());
        if (newIndx < 0) {
            return;
        }
        this.selectedEntryInPage = newIndx;
    }

    private int getHoveredIndex(double x, double y, int entry_size) {
        boolean outside_of_area;
        int mX = this.field_22789 / 2;
        int mY = this.field_22790 / 2;
        int area_size = this.getSelectAreaSize();
        boolean bl = outside_of_area = Math.abs(x - (double)mX) > (double)(area_size / 2) || Math.abs(y - (double)mY) > (double)(area_size / 2);
        if (outside_of_area) {
            return -1;
        }
        int baseY = mY - area_size / 2;
        int indx = class_3532.method_15357((double)(y - (double)baseY)) / this.getSpacePerEntry();
        if (indx >= entry_size) {
            return -1;
        }
        return indx;
    }

    private int getCurrentPageEntries() {
        boolean is_last_page;
        boolean bl = is_last_page = this.activePage >= this.pageCount - 1;
        if (is_last_page) {
            return this.filteredIndexes.size() % this.getMaxEntriesPerPage();
        }
        return this.getMaxEntriesPerPage();
    }

    protected void drawSelectArea(class_332 graphics) {
        this.drawSelectAreaBackground(graphics);
        this.drawEntries(graphics);
    }

    protected void drawSelectAreaBackground(class_332 graphics) {
        int half_width = this.field_22789 / 2;
        int half_height = this.field_22790 / 2;
        graphics.method_25294(half_width - this.getSelectAreaSize() / 2, half_height - this.getSelectAreaSize() / 2, half_width + this.getSelectAreaSize() / 2, half_height + this.getSelectAreaSize() / 2, Integer.MIN_VALUE);
    }

    protected void drawEntries(class_332 graphics) {
        int half_width = this.field_22789 / 2;
        int half_height = this.field_22790 / 2;
        int entry_offset = 0;
        int entry_start_x = half_width - this.getSelectAreaSize() / 2 + 2;
        int entry_start_y = half_height - this.getSelectAreaSize() / 2 + 2;
        int startIndx = this.activePage * this.getMaxEntriesPerPage();
        int drawNo = 0;
        for (int i = startIndx; i < this.filteredIndexes.size(); ++i) {
            this.drawEntry(graphics, entry_start_x, entry_start_y + entry_offset, startIndx, i);
            entry_offset += this.getSpacePerEntry();
            if (++drawNo >= this.getMaxEntriesPerPage()) break;
        }
    }

    protected void drawEntry(class_332 graphics, int entry_x, int entry_y, int start_indx, int render_indx) {
        boolean is_selected_entry;
        int color = -1;
        boolean bl = is_selected_entry = render_indx == start_indx + this.selectedEntryInPage;
        if (is_selected_entry) {
            color = this.getHightlightSelectedColor();
        }
        int entry_id = this.filteredIndexes.get(render_indx);
        String text = this.entries.get(entry_id);
        graphics.method_25303(this.field_22793, text, entry_x, entry_y, color);
    }

    protected void drawSearchBar(class_332 graphics) {
        int half_width = this.field_22789 / 2;
        int half_height = this.field_22790 / 2;
        int txtorgx = half_width - this.getSelectAreaSize() / 2 + 10;
        int txtorgy = half_height + this.getSelectAreaSize() / 2 + this.getSearchBarOffset();
        graphics.method_25294(half_width - this.getSelectAreaSize() / 2, half_height + this.getSelectAreaSize() / 2 + 5, half_width + this.getSelectAreaSize() / 2, half_height + this.getSelectAreaSize() / 2 + 17, Integer.MIN_VALUE);
        graphics.method_25303(this.field_22793, this.searchString + "_", txtorgx, txtorgy, -1);
    }

    protected void drawPageIndicator(class_332 graphics) {
        int half_width = this.field_22789 / 2;
        int half_height = this.field_22790 / 2;
        String pageStr = this.activePage + 1 + "/" + this.pageCount;
        int pageStrWidth = this.field_22793.method_1727(pageStr);
        graphics.method_25303(this.field_22793, pageStr, half_width - pageStrWidth / 2, half_height - this.getSelectAreaSize() / 2 - this.getPageIndicatorOffset(), -1);
    }

    public boolean method_25400(char code, int p_231042_2_) {
        if (this.blockCharInputMillis > 0L) {
            return false;
        }
        if (class_155.method_643((char)code)) {
            this.insertText(Character.toString(code));
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_3675.class_306 mouseKey = class_3675.method_15985((int)keyCode, (int)scanCode);
        if (keyCode == 264) {
            int currentPageEntries = this.getCurrentPageEntries() - 1;
            this.selectedEntryInPage = class_3532.method_15340((int)(this.selectedEntryInPage + 1), (int)0, (int)currentPageEntries);
            return true;
        }
        if (keyCode == 265) {
            int currentPageEntries = this.getCurrentPageEntries() - 1;
            this.selectedEntryInPage = class_3532.method_15340((int)(this.selectedEntryInPage - 1), (int)0, (int)currentPageEntries);
            return true;
        }
        if (keyCode == 263) {
            if (this.prevPageButton.field_22763) {
                this.prevPageButton.method_25348(0.0, 0.0);
            }
            return true;
        }
        if (keyCode == 262) {
            if (this.nextPageButton.field_22763) {
                this.nextPageButton.method_25348(0.0, 0.0);
            }
            return true;
        }
        if (keyCode == 257) {
            if (this.filteredIndexes.isEmpty()) {
                return false;
            }
            int selectedId = this.getSelectedFilterId(this.selectedEntryInPage);
            if (selectedId >= 0 && selectedId < this.filteredIndexes.size()) {
                this.onEntrySelected(this.filteredIndexes.get(selectedId));
            }
            return true;
        }
        if (keyCode == 259) {
            this.popCharInText();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double x, double y, int p_94697_) {
        boolean ret = super.method_25402(x, y, p_94697_);
        if (this.filteredIndexes.isEmpty()) {
            return ret;
        }
        int indx = this.getHoveredIndex(x, y, this.getCurrentPageEntries());
        if (indx < 0) {
            return ret;
        }
        int selected_id = this.getSelectedFilterId(indx);
        if (selected_id >= 0 && selected_id < this.filteredIndexes.size()) {
            this.onEntrySelected(this.filteredIndexes.get(selected_id));
        }
        return ret;
    }

    protected void onEntrySelected(int id) {
    }

    private void insertText(String x) {
        if (this.searchString.length() < this.getMaxSearchBufferSize()) {
            this.searchString = this.searchString + x;
        }
        this.updateFilteredIndexes();
    }

    private void popCharInText() {
        if (this.searchString.length() <= 0) {
            return;
        }
        this.searchString = this.searchString.substring(0, this.searchString.length() - 1);
        this.updateFilteredIndexes();
    }

    protected void updateEntries(List<String> new_entries) {
        if (new_entries == null) {
            return;
        }
        this.entries = new_entries;
        this.updateFilteredIndexes();
    }

    protected void updateFilteredIndexes() {
        this.filteredIndexes.clear();
        this.selectedEntryInPage = 0;
        if (this.searchString == null || this.searchString.isEmpty()) {
            for (int i = 0; i < this.entries.size(); ++i) {
                this.filteredIndexes.add(i);
            }
            this.updatePages();
            return;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            String entry = this.entries.get(i);
            if (entry.length() < this.searchString.length() || !entry.contains(this.searchString)) continue;
            this.filteredIndexes.add(i);
        }
        this.updatePages();
    }

    private void updatePages() {
        int filter_size = this.filteredIndexes.size();
        this.activePage = 0;
        this.pageCount = filter_size / this.getMaxEntriesPerPage();
        if (filter_size % this.getMaxEntriesPerPage() > 0) {
            ++this.pageCount;
        }
        this.onPageUpdated();
    }

    private int getSelectedFilterId(int selected_index_per_page) {
        return this.activePage * this.getMaxEntriesPerPage() + selected_index_per_page;
    }

    public void setBlockCharInputMillis(int x) {
        this.blockCharInputMillis = x;
        this.prevMillis = System.currentTimeMillis();
    }

    protected int getMaxEntriesPerPage() {
        return 19;
    }

    protected int getSelectAreaSize() {
        return 200;
    }

    protected int getSearchBarOffset() {
        return 7;
    }

    protected int getPageIndicatorOffset() {
        return 10;
    }

    protected int getSpacePerEntry() {
        return 10;
    }

    protected int getHightlightSelectedColor() {
        return -61191;
    }

    protected int getMaxSearchBufferSize() {
        return 64;
    }
}

