/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogMoveToBedAction;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.util.DogBedUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_5575;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DogBedBlock
extends class_2237 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2383.field_11177;
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final class_265 SHAPE_COLLISION = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);

    public DogBedBlock() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9629(1.0f, 5.0f).method_9626(class_2498.field_11547));
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED});
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 selectionContext) {
        return SHAPE_COLLISION;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 blockState) {
        return new DogBedTileEntity(pos, blockState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return null;
    }

    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)placer.method_5735().method_10153());
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity((class_1922)worldIn, pos, DogBedTileEntity.class);
        if (dogBedTileEntity != null) {
            DogBedUtil.setBedVariant(dogBedTileEntity, stack);
            dogBedTileEntity.setPlacer(placer);
            class_2487 tag = stack.method_7941("doggytalents");
            if (tag != null) {
                class_2561 name = NBTUtil.getTextComponent(tag, "name");
                UUID ownerId = NBTUtil.getUniqueId(tag, "ownerId");
                dogBedTileEntity.setBedName(name);
                dogBedTileEntity.setOwner(ownerId);
            }
        }
        worldIn.method_8652(pos, state, 2);
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (((Boolean)stateIn.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            worldIn.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)worldIn));
        }
        return facing == class_2350.field_11033 && !stateIn.method_26184((class_4538)worldIn, currentPos) ? class_2246.field_10124.method_9564() : super.method_9559(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Deprecated
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        DogBedTileEntity tile = WorldUtil.getTileEntity((class_1922)level, pos, DogBedTileEntity.class);
        if (tile == null) {
            return class_1269.field_5812;
        }
        class_1799 stack = player.method_5998(handIn);
        if (this.handleNameTagBed(player, level, state, pos, tile, stack).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.handleDogRandomRespawn(player, level, state, pos, tile, stack).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.handleDogClaimBed(player, level, state, pos, tile, stack).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.handleDogRespawn(player, level, state, pos, tile, stack).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.handleDogReclaim(player, level, state, pos, tile, stack).method_23666()) {
            return class_1269.field_5812;
        }
        if (tile.getOwnerUUID() != null) {
            class_2561 name = tile.getOwnerName();
            player.method_43496((class_2561)class_2561.method_43469((String)"block.doggytalents.dog_bed.owner", (Object[])new Object[]{name != null ? name : "someone"}));
        } else {
            player.method_43496((class_2561)class_2561.method_43471((String)"block.doggytalents.dog_bed.set_owner_help"));
        }
        return class_1269.field_5812;
    }

    private class_1269 handleDogRandomRespawn(class_1657 player, class_1937 level, class_2680 state, class_2338 pos, DogBedTileEntity tile, class_1799 stack) {
        if (tile.getOwnerUUID() != null) {
            return class_1269.field_5811;
        }
        if (!stack.method_31574(class_1802.field_8288)) {
            return class_1269.field_5811;
        }
        if (player.method_7357().method_7904(class_1802.field_8288)) {
            return class_1269.field_5811;
        }
        DogRespawnStorage storage = DogRespawnStorage.get(level);
        Predicate<DogRespawnData> isFromOwner = filter_data -> {
            UUID owner_id = filter_data.getOwnerId();
            if (owner_id == null) {
                return false;
            }
            return !ObjectUtils.notEqual((Object)owner_id, (Object)player.method_5667());
        };
        List dataList = storage.getAll().stream().filter(isFromOwner).collect(Collectors.toList());
        if (dataList.isEmpty()) {
            return class_1269.field_5811;
        }
        int dataListSize = dataList.size();
        int rIndx = player.method_6051().method_43048(dataListSize);
        UUID rUUID = ((DogRespawnData)dataList.get(rIndx)).getDogId();
        DogRespawnData dogData = storage.remove(rUUID);
        if (dogData == null) {
            return class_1269.field_5812;
        }
        Dog dog = dogData.respawn((class_3218)level, player, pos.method_10084());
        if (dog == null) {
            return class_1269.field_5812;
        }
        tile.setOwner(dog);
        dog.setBedPos((class_5321<class_1937>)dog.method_37908().method_27983(), pos);
        dog.method_37908().method_8421((class_1297)dog, (byte)35);
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        player.method_7357().method_7906(class_1802.field_8288, 60);
        return class_1269.field_5812;
    }

    private class_1269 handleDogReclaim(class_1657 player, class_1937 level, class_2680 state, class_2338 pos, DogBedTileEntity tile, class_1799 stack) {
        UUID owner_id = tile.getOwnerUUID();
        if (owner_id == null) {
            return class_1269.field_5811;
        }
        if (!player.method_5715()) {
            return class_1269.field_5811;
        }
        this.reclaimBed(player, (class_3218)level, tile, pos);
        return class_1269.field_5812;
    }

    private class_1269 handleDogRespawn(class_1657 player, class_1937 level, class_2680 state, class_2338 pos, DogBedTileEntity tile, class_1799 stack) {
        UUID owner_id = tile.getOwnerUUID();
        if (owner_id == null) {
            return class_1269.field_5811;
        }
        DogRespawnStorage storage = DogRespawnStorage.get(level);
        DogRespawnData data = storage.remove(owner_id);
        if (data == null) {
            return class_1269.field_5811;
        }
        Dog dog = data.respawn((class_3218)level, player, pos.method_10084());
        if (dog == null) {
            return class_1269.field_5812;
        }
        tile.setOwner(dog);
        dog.setBedPos((class_5321<class_1937>)dog.method_37908().method_27983(), pos);
        return class_1269.field_5812;
    }

    private class_1269 handleDogClaimBed(class_1657 player, class_1937 level, class_2680 state, class_2338 pos, DogBedTileEntity tile, class_1799 stack) {
        Dog closest;
        boolean isAssign;
        if (tile.getOwnerUUID() != null) {
            return class_1269.field_5811;
        }
        boolean bl = isAssign = player.method_5715() || stack.method_31574(class_1802.field_8606) || stack.method_31574(DoggyItems.TRAINING_TREAT.get());
        if (!isAssign) {
            return class_1269.field_5811;
        }
        Predicate<Dog> isValidDog = valid_dog -> valid_dog.isDoingFine() && valid_dog.method_6171((class_1309)player) && !valid_dog.method_24345();
        List dogs = level.method_18023((class_5575)DoggyEntityTypes.DOG.get(), new class_238(pos).method_1014(10.0), isValidDog);
        Collections.sort(dogs, new EntityUtil.Sorter(class_243.method_24955((class_2382)pos)));
        Dog dog = closest = dogs.isEmpty() ? null : (Dog)dogs.get(0);
        if (pos != null && closest != null && closest.readyForNonTrivialAction()) {
            closest.triggerAction(new DogMoveToBedAction(closest, pos, true));
        }
        return class_1269.field_5812;
    }

    private class_1269 handleNameTagBed(class_1657 player, class_1937 level, class_2680 state, class_2338 pos, DogBedTileEntity tile, class_1799 stack) {
        if (!stack.method_31574(class_1802.field_8448)) {
            return class_1269.field_5811;
        }
        if (!stack.method_7938()) {
            return class_1269.field_5811;
        }
        tile.setBedName(stack.method_7964());
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        level.method_8413(pos, state, state, 3);
        return class_1269.field_5812;
    }

    private boolean reclaimBed(class_1657 player, class_3218 level, DogBedTileEntity bedEntity, class_2338 pos) {
        class_1297 e = level.method_14190(bedEntity.getOwnerUUID());
        if (!(e instanceof Dog)) {
            return false;
        }
        Dog dog = (Dog)e;
        Optional<class_2338> bedPosOptional = dog.getBedPos();
        if (!bedPosOptional.isPresent()) {
            return false;
        }
        class_2338 bedPos = bedPosOptional.get();
        if (bedPos.equals((Object)pos)) {
            return false;
        }
        dog.setBedPos(pos);
        player.method_43496((class_2561)class_2561.method_43469((String)"block.doggytalents.dog_bed.reclaim", (Object[])new Object[]{dog.method_5477().getString(), dog.getGenderPossessiveAdj()}));
        return true;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        class_2487 tag;
        super.method_9568(stack, worldIn, tooltip, flagIn);
        Pair<ICasingMaterial, IBeddingMaterial> materials = DogBedUtil.getMaterials(stack);
        tooltip.add((class_2561)class_2561.method_43471((String)"dogbed.casing.title"));
        tooltip.add((class_2561)(materials.getLeft() != null ? ((ICasingMaterial)materials.getLeft()).getTooltip() : class_2561.method_43471((String)"dogbed.casing.null").method_27692(class_124.field_1061)));
        tooltip.add((class_2561)class_2561.method_43471((String)"dogbed.bedding.title"));
        tooltip.add((class_2561)(materials.getRight() != null ? ((IBeddingMaterial)materials.getRight()).getTooltip() : class_2561.method_43471((String)"dogbed.bedding.null").method_27692(class_124.field_1061)));
        if (materials.getLeft() == null && materials.getRight() == null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"dogbed.explain.missing").method_27692(class_124.field_1056));
        }
        if ((tag = stack.method_7941("doggytalents")) != null) {
            UUID ownerId = NBTUtil.getUniqueId(tag, "ownerId");
            class_2561 name = NBTUtil.getTextComponent(tag, "name");
            class_2561 ownerName = NBTUtil.getTextComponent(tag, "ownerName");
            if (name != null) {
                tooltip.add((class_2561)class_2561.method_43470((String)"Bed Name: ").method_27692(class_124.field_1068).method_10852(name));
            }
            if (ownerName != null) {
                tooltip.add((class_2561)class_2561.method_43470((String)"Name: ").method_27692(class_124.field_1062).method_10852(ownerName));
            }
            if (ownerId != null && (flagIn.method_8035() || class_437.method_25442())) {
                tooltip.add((class_2561)class_2561.method_43470((String)"UUID: ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)ownerId.toString())));
            }
        }
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity(world, pos, DogBedTileEntity.class);
        if (dogBedTileEntity != null) {
            return DogBedUtil.createItemStack(dogBedTileEntity.getCasing(), dogBedTileEntity.getBedding());
        }
        DoggyTalentsNext.LOGGER.debug("Unable to pick block on dog bed.");
        return class_1799.field_8037;
    }
}

