/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import com.google.common.collect.Maps;
import doggytalents.api.impl.BeddingMaterial;
import doggytalents.api.impl.CasingMaterial;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.Util;
import doggytalents.forge_imitate.event.TagsUpdatedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class DogBedMaterialManager {
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    public static final class_2960 NANI_KEY = Util.getResource("textures/block/dog_bed_nani");
    public static final class_2960 NANI_TEXTURE = Util.getResource("block/dog_bed_casing_nani");
    private static final Map<class_2960, IBeddingMaterial> beddingMap = Maps.newConcurrentMap();
    private static final Map<class_2960, ICasingMaterial> casingMap = Maps.newConcurrentMap();
    private static final Map<IBeddingMaterial, class_2960> beddingKeyMap = Maps.newConcurrentMap();
    private static final Map<ICasingMaterial, class_2960> casingKeyMap = Maps.newConcurrentMap();

    public static Map<class_2960, IBeddingMaterial> getBeddings() {
        return beddingMap;
    }

    public static Map<class_2960, ICasingMaterial> getCasings() {
        return casingMap;
    }

    public static IBeddingMaterial getBedding(class_2960 loc) {
        IBeddingMaterial ret = beddingMap.get(loc);
        if (ret == null) {
            return new NaniBedding(loc);
        }
        return ret;
    }

    public static ICasingMaterial getCasing(class_2960 loc) {
        ICasingMaterial ret = casingMap.get(loc);
        if (ret == null) {
            return new NaniCasing(loc);
        }
        return ret;
    }

    public static IBeddingMaterial getBedding(class_2487 tag, String id) {
        class_2960 loc = NBTUtil.getResourceLocation(tag, id);
        return DogBedMaterialManager.getBedding(loc);
    }

    public static ICasingMaterial getCasing(class_2487 tag, String id) {
        class_2960 loc = NBTUtil.getResourceLocation(tag, id);
        return DogBedMaterialManager.getCasing(loc);
    }

    public static class_2960 getKey(IBeddingMaterial loc) {
        if (loc == null) {
            return NANI_KEY;
        }
        if (loc instanceof NaniBedding) {
            NaniBedding nani = (NaniBedding)loc;
            return nani.missingLoc().isPresent() ? nani.missingLoc().get() : NANI_KEY;
        }
        class_2960 ret = beddingKeyMap.get(loc);
        if (ret == null) {
            return NANI_KEY;
        }
        return ret;
    }

    public static class_2960 getKey(ICasingMaterial loc) {
        if (loc == null) {
            return NANI_KEY;
        }
        if (loc instanceof NaniCasing) {
            NaniCasing nani = (NaniCasing)loc;
            return nani.missingLoc().isPresent() ? nani.missingLoc().get() : NANI_KEY;
        }
        class_2960 ret = casingKeyMap.get(loc);
        if (ret == null) {
            return NANI_KEY;
        }
        return ret;
    }

    public static IBeddingMaterial randomBedding() {
        List list = beddingMap.entrySet().stream().filter(x -> !(x.getValue() instanceof NaniBedding)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return NaniBedding.NULL;
        }
        return (IBeddingMaterial)((Map.Entry)list.get(RANDOM.nextInt(list.size()))).getValue();
    }

    public static ICasingMaterial randomCasing() {
        List list = casingMap.entrySet().stream().filter(x -> !(x.getValue() instanceof NaniCasing)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return NaniCasing.NULL;
        }
        return (ICasingMaterial)((Map.Entry)list.get(RANDOM.nextInt(list.size()))).getValue();
    }

    public static void refresh(TagsUpdatedEvent.UpdateCause cause) {
        beddingMap.clear();
        casingMap.clear();
        DogBedMaterialManager.populateBedding(cause);
        DogBedMaterialManager.populateCasing(cause);
    }

    private static void populateBedding(TagsUpdatedEvent.UpdateCause cause) {
        List<class_2248> blocks = DogBedMaterialManager.fetchBeddingBlocks();
        for (class_2248 block : blocks) {
            class_2960 id = class_7923.field_41175.method_10221((Object)block);
            IBeddingMaterial value = new BeddingMaterial(() -> block);
            if (cause == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && !ClientEventHandler.vertifyBlockTexture(((IBeddingMaterial)value).getTexture())) {
                value = new NaniBedding(id);
            }
            beddingMap.put(id, value);
            beddingKeyMap.put(value, id);
        }
    }

    private static void populateCasing(TagsUpdatedEvent.UpdateCause cause) {
        List<class_2248> blocks = DogBedMaterialManager.fetchCasingBlocks();
        for (class_2248 block : blocks) {
            class_2960 id = class_7923.field_41175.method_10221((Object)block);
            ICasingMaterial value = new CasingMaterial(() -> block);
            if (cause == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && !ClientEventHandler.vertifyBlockTexture(((ICasingMaterial)value).getTexture())) {
                value = new NaniCasing(id);
            }
            casingMap.put(id, value);
            casingKeyMap.put(value, id);
        }
    }

    private static List<class_2248> fetchCasingBlocks() {
        class_7922 tags = class_7923.field_41175;
        List planks = tags.method_40266(class_3481.field_15471).map(x -> x.method_40239().map(y -> (class_2248)y.comp_349()).collect(Collectors.toList())).orElse(List.of());
        List logs = tags.method_40266(class_3481.field_15475).map(x -> x.method_40239().map(y -> (class_2248)y.comp_349()).collect(Collectors.toList())).orElse(List.of());
        ArrayList<class_2248> ret = new ArrayList<class_2248>(planks.size() + logs.size());
        ret.addAll(planks);
        ret.addAll(logs);
        return ret;
    }

    private static List<class_2248> fetchBeddingBlocks() {
        class_7922 tags = class_7923.field_41175;
        List wools = tags.method_40266(class_3481.field_15481).map(x -> x.method_40239().map(y -> (class_2248)y.comp_349()).collect(Collectors.toList())).orElse(List.of());
        ArrayList<class_2248> ret = new ArrayList<class_2248>(wools.size());
        ret.addAll(wools);
        return ret;
    }

    public static void onTagsUpdated(TagsUpdatedEvent event) {
        DogBedMaterialManager.refresh(event.getUpdateCause());
    }

    public static class NaniBedding
    extends IBeddingMaterial {
        public static final NaniBedding NULL = new NaniBedding(null);
        private Optional<class_2960> missingLoc;

        public NaniBedding(class_2960 loc) {
            this.missingLoc = loc == null ? Optional.empty() : Optional.of(loc);
        }

        @Override
        public class_2960 getTexture() {
            return NANI_TEXTURE;
        }

        @Override
        public class_2561 getTooltip() {
            String retStr = "nani?";
            if (this.missingLoc.isPresent()) {
                retStr = this.missingLoc.get().toString();
            }
            return class_2561.method_43471((String)retStr).method_27692(class_124.field_1061);
        }

        @Override
        public class_1856 getIngredient() {
            return class_1856.field_9017;
        }

        public Optional<class_2960> missingLoc() {
            return this.missingLoc;
        }
    }

    public static class NaniCasing
    extends ICasingMaterial {
        public static final NaniCasing NULL = new NaniCasing(null);
        private Optional<class_2960> missingLoc;

        public NaniCasing(class_2960 loc) {
            this.missingLoc = loc == null ? Optional.empty() : Optional.of(loc);
        }

        @Override
        public class_2960 getTexture() {
            return NANI_TEXTURE;
        }

        @Override
        public class_2561 getTooltip() {
            String retStr = "nani?";
            if (this.missingLoc.isPresent()) {
                retStr = this.missingLoc.get().toString();
            }
            return class_2561.method_43471((String)retStr).method_27692(class_124.field_1061);
        }

        @Override
        public class_1856 getIngredient() {
            return class_1856.field_9017;
        }

        public Optional<class_2960> missingLoc() {
            return this.missingLoc;
        }
    }
}

