/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.command;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import doggytalents.common.command.arguments.UUIDArgument;
import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.IDogData;
import doggytalents.forge_imitate.registry.DeferredRegister;
import doggytalents.forge_imitate.registry.RegistryObject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class DoggyCommands {
    public static final DeferredRegister<class_2314<?, ?>> ARG_TYPE = DeferredRegister.create(() -> class_7923.field_41192, "doggytalents");
    public static final RegistryObject<class_2319<UUIDArgument>> SUUID = ARG_TYPE.register("doggy_uuid", () -> class_2319.method_41999(UUIDArgument::uuid));
    public static final DynamicCommandExceptionType NOTFOUND_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"command.dogrespawn.notfound", (Object[])new Object[]{arg}));
    public static final DynamicCommandExceptionType RESPAWN_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"command.dogrespawn.exception", (Object[])new Object[]{arg}));
    public static final DynamicCommandExceptionType AMBIGUOUS_NAME_EXCEPTION = new DynamicCommandExceptionType(name -> class_2561.method_43469((String)"command.dogrespawn.imprecise", (Object[])new Object[]{name}));
    public static final DynamicCommandExceptionType BAD_UUID_STRING = new DynamicCommandExceptionType(name -> class_2561.method_43469((String)"command.dogrespawn.bad_uuid_str", (Object[])new Object[]{name}));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dog").requires(s -> s.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"locate").then(class_2170.method_9247((String)"byuuid").then(class_2170.method_9244((String)"ownerName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getOwnerNameSuggestionsLocate()).then(class_2170.method_9244((String)"dogUUID", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogIdSuggestionsLocate()).executes(c -> DoggyCommands.locate((CommandContext<class_2168>)c)))))).then(class_2170.method_9247((String)"byname").then(class_2170.method_9244((String)"ownerName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getOwnerNameSuggestionsLocate()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dogName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogNameSuggestionsLocate()).executes(c -> DoggyCommands.locate2((CommandContext<class_2168>)c))).then(class_2170.method_9244((String)"dogUUID", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogIdSuggestionsLocate()).executes(c -> DoggyCommands.locate((CommandContext<class_2168>)c)))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"revive").then(class_2170.method_9247((String)"byuuid").then(class_2170.method_9244((String)"ownerName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getOwnerNameSuggestionsRevive()).then(class_2170.method_9244((String)"dogUUID", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogIdSuggestionsRevive()).executes(c -> DoggyCommands.respawn((CommandContext<class_2168>)c)))))).then(class_2170.method_9247((String)"byname").then(class_2170.method_9244((String)"ownerName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getOwnerNameSuggestionsRevive()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dogName", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogNameSuggestionsRevive()).executes(c -> DoggyCommands.respawn2((CommandContext<class_2168>)c))).then(class_2170.method_9244((String)"dogUUID", (ArgumentType)StringArgumentType.string()).suggests(DoggyCommands.getDogIdSuggestionsRevive()).executes(c -> DoggyCommands.respawn((CommandContext<class_2168>)c))))))));
    }

    private static <S extends class_2172> SuggestionProvider<S> getOwnerIdSuggestionsLocate() {
        return (context, builder) -> DoggyCommands.getOwnerIdSuggestions(DogLocationStorage.get((class_1937)((class_2168)context.getSource()).method_9225()).getAll(), context, builder);
    }

    private static <S extends class_2172> SuggestionProvider<S> getOwnerIdSuggestionsRevive() {
        return (context, builder) -> DoggyCommands.getOwnerIdSuggestions(DogRespawnStorage.get((class_1937)((class_2168)context.getSource()).method_9225()).getAll(), context, builder);
    }

    private static <S extends class_2172> CompletableFuture<Suggestions> getOwnerIdSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_2168) {
            return class_2172.method_9265((Iterable)possibilities.stream().map(IDogData::getOwnerId).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof class_2172) {
            return ((class_2172)context.getSource()).method_9261(context);
        }
        return Suggestions.empty();
    }

    private static <S extends class_2172> SuggestionProvider<S> getDogIdSuggestionsLocate() {
        return (context, builder) -> DoggyCommands.getDogIdSuggestions(DogLocationStorage.get((class_1937)((class_2168)context.getSource()).method_9225()).getAll(), context, builder);
    }

    private static <S extends class_2172> SuggestionProvider<S> getDogIdSuggestionsRevive() {
        return (context, builder) -> DoggyCommands.getDogIdSuggestions(DogRespawnStorage.get((class_1937)((class_2168)context.getSource()).method_9225()).getAll(), context, builder);
    }

    private static <S extends class_2172> CompletableFuture<Suggestions> getDogIdSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_2168) {
            String dogName = null;
            String ownerName = (String)context.getArgument("ownerName", String.class);
            try {
                dogName = (String)context.getArgument("dogName", String.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (ownerName == null) {
                return Suggestions.empty();
            }
            String dogName2 = dogName;
            Predicate<IDogData> filter = dogName2 == null ? data -> ownerName.equals(data.getOwnerName()) : data -> dogName2.equals(data.getDogName()) && ownerName.equals(data.getOwnerName());
            return class_2172.method_9265((Iterable)possibilities.stream().filter(filter).map(IDogData::getDogId).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof class_2172) {
            return ((class_2172)context.getSource()).method_9261(context);
        }
        return Suggestions.empty();
    }

    private static <S extends class_2172> SuggestionProvider<S> getOwnerNameSuggestionsLocate() {
        return (context, builder) -> DoggyCommands.getOwnerNameSuggestions(DogLocationStorage.get((class_1937)((class_2168)context.getSource()).method_9225()).getAll(), context, builder);
    }

    private static <S extends class_2172> SuggestionProvider<S> getOwnerNameSuggestionsRevive() {
        return (context, builder) -> DoggyCommands.getOwnerNameSuggestions(DogRespawnStorage.get((class_1937)((class_2168)context.getSource()).method_9225()).getAll(), context, builder);
    }

    public static <S extends class_2172> CompletableFuture<Suggestions> getOwnerNameSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_2168) {
            return class_2172.method_9265((Iterable)possibilities.stream().map(IDogData::getOwnerName).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof class_2172) {
            return ((class_2172)context.getSource()).method_9261(context);
        }
        return Suggestions.empty();
    }

    private static <S extends class_2172> SuggestionProvider<S> getDogNameSuggestionsLocate() {
        return (context, builder) -> DoggyCommands.getDogNameSuggestions(DogLocationStorage.get((class_1937)((class_2168)context.getSource()).method_9225()).getAll(), context, builder);
    }

    private static <S extends class_2172> SuggestionProvider<S> getDogNameSuggestionsRevive() {
        return (context, builder) -> DoggyCommands.getDogNameSuggestions(DogRespawnStorage.get((class_1937)((class_2168)context.getSource()).method_9225()).getAll(), context, builder);
    }

    public static <S extends class_2172> CompletableFuture<Suggestions> getDogNameSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_2168) {
            String ownerName = (String)context.getArgument("ownerName", String.class);
            if (ownerName == null) {
                return Suggestions.empty();
            }
            return class_2172.method_9265((Iterable)possibilities.stream().filter(data -> ownerName.equals(data.getOwnerName())).map(IDogData::getDogName).filter(str -> !Strings.isNullOrEmpty((String)str)).map(str -> DoggyCommands.wrapStringInQuoteIfContainsSpace(str)).collect(Collectors.toList()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof class_2172) {
            return ((class_2172)context.getSource()).method_9261(context);
        }
        return Suggestions.empty();
    }

    private static String wrapStringInQuoteIfContainsSpace(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        int spaceIndx = str.indexOf(" ");
        if (spaceIndx < 0) {
            return str;
        }
        return "\"" + str + "\"";
    }

    private static int respawn(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        source.method_9207();
        class_3218 world = source.method_9225();
        String uuidStr = (String)ctx.getArgument("dogUUID", String.class);
        UUID uuid = null;
        try {
            uuid = UUID.fromString(uuidStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uuid == null) {
            throw BAD_UUID_STRING.create((Object)"null");
        }
        DogRespawnStorage respawnStorage = DogRespawnStorage.get((class_1937)world);
        DogRespawnData respawnData = respawnStorage.getData(uuid);
        if (respawnData == null) {
            throw NOTFOUND_EXCEPTION.create((Object)uuid.toString());
        }
        return DoggyCommands.respawn(respawnStorage, respawnData, source);
    }

    private static int respawn2(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        source.method_9207();
        class_3218 world = source.method_9225();
        String ownerName = (String)ctx.getArgument("ownerName", String.class);
        String dogName = (String)ctx.getArgument("dogName", String.class);
        DogRespawnStorage respawnStorage = DogRespawnStorage.get((class_1937)world);
        List respawnData = respawnStorage.getDogs(ownerName).filter(data -> data.getDogName().equals(dogName)).collect(Collectors.toList());
        if (respawnData.isEmpty()) {
            throw NOTFOUND_EXCEPTION.create((Object)dogName);
        }
        if (respawnData.size() > 1) {
            StringJoiner joiner = new StringJoiner(", ");
            for (DogRespawnData data2 : respawnData) {
                joiner.add(Objects.toString(data2.getDogId()));
            }
            throw AMBIGUOUS_NAME_EXCEPTION.create((Object)dogName);
        }
        return DoggyCommands.respawn(respawnStorage, (DogRespawnData)respawnData.get(0), source);
    }

    private static int respawn(DogRespawnStorage respawnStorage, DogRespawnData respawnData, class_2168 source) throws CommandSyntaxException {
        Dog dog = respawnData.respawn(source.method_9225(), (class_1657)source.method_9207(), source.method_9207().method_24515().method_10084());
        if (dog != null) {
            respawnStorage.remove(respawnData.getDogId());
            source.method_9226(() -> class_2561.method_43469((String)"commands.dogrespawn.uuid.success", (Object[])new Object[]{respawnData.getDogName()}), false);
            return 1;
        }
        source.method_9226(() -> class_2561.method_43469((String)"commands.dogrespawn.uuid.failure", (Object[])new Object[]{respawnData.getDogName()}), false);
        return 0;
    }

    private static int locate(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        source.method_9207();
        class_3218 world = source.method_9225();
        String uuidStr = (String)ctx.getArgument("dogUUID", String.class);
        UUID uuid = null;
        try {
            uuid = UUID.fromString(uuidStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uuid == null) {
            throw BAD_UUID_STRING.create((Object)"null");
        }
        DogLocationStorage locationStorage = DogLocationStorage.get((class_1937)world);
        DogLocationData locationData = locationStorage.getData(uuid);
        if (locationData == null) {
            throw NOTFOUND_EXCEPTION.create((Object)uuid.toString());
        }
        return DoggyCommands.locate(locationStorage, locationData, source);
    }

    private static int locate2(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        source.method_9207();
        class_3218 world = source.method_9225();
        String ownerName = (String)ctx.getArgument("ownerName", String.class);
        String dogName = (String)ctx.getArgument("dogName", String.class);
        DogLocationStorage locationStorage = DogLocationStorage.get((class_1937)world);
        List locationData = locationStorage.getAll().stream().filter(data -> ownerName.equals(data.getOwnerName())).filter(data -> data.getDogName().equals(dogName)).collect(Collectors.toList());
        if (locationData.isEmpty()) {
            throw NOTFOUND_EXCEPTION.create((Object)dogName);
        }
        if (locationData.size() > 1) {
            StringJoiner joiner = new StringJoiner(", ");
            for (DogLocationData data2 : locationData) {
                joiner.add(Objects.toString(data2.getDogId()));
            }
            throw AMBIGUOUS_NAME_EXCEPTION.create((Object)dogName);
        }
        return DoggyCommands.locate(locationStorage, (DogLocationData)locationData.get(0), source);
    }

    private static int locate(DogLocationStorage respawnStorage, DogLocationData locationData, class_2168 source) throws CommandSyntaxException {
        source.method_9226(() -> DoggyCommands.getLocationInfo(locationData), false);
        return 1;
    }

    public static class_2561 getLocationInfo(DogLocationData loc) {
        class_2960 dim_loc;
        class_243 pos = loc.getPos();
        class_2338 bpos = null;
        if (pos != null) {
            bpos = class_2338.method_49638((class_2374)pos);
        }
        String posStr = bpos == null ? "[???]" : "[ " + bpos.method_10263() + ", " + bpos.method_10264() + ", " + bpos.method_10260() + " ]";
        class_5321<class_1937> dim = loc.getDimension();
        class_2960 class_29602 = dim_loc = dim == null ? null : dim.method_29177();
        String dimStr = dim == null ? "[???]" : "[ " + (Comparable)((Object)(dim_loc == null ? "" : dim_loc)) + " ]";
        String dogName = loc.getDogName();
        if (dogName == null) {
            dogName = "noname";
        }
        return class_2561.method_43469((String)"command.doglocate.info", (Object[])new Object[]{dogName, posStr, dimStr});
    }
}

