/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.DoggyAdvancementTriggers;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.feature.EnumMode;
import doggytalents.client.screen.DogNewInfoScreen.screen.DogCannotInteractWithScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogBounceAction;
import doggytalents.common.entity.ai.triggerable.DogFaintStandAction;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.DogUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_5134;
import net.minecraft.class_6862;

public class DogIncapacitatedMananger {
    private final Dog dog;
    private int recoveryMultiplier = 1;
    private static final UUID INCAP_MOVEMENT = UUID.fromString("9576c796-c7c7-4995-90d5-f60eafc58805");
    private boolean appliedIncapChanges = false;
    private static final int MAX_BANDAID_COUNT = 8;
    private float partialRecoverVal = 0.0f;
    private int bandagesCount = 0;
    private int bandageCooldown = 0;
    private int drownPoseTick = 0;
    private class_2680 atBlockState = null;
    public static final int MAX_INCAP_MSG_LEN = 256;
    private String incapMsg = "";

    public DogIncapacitatedMananger(Dog dog) {
        this.dog = dog;
    }

    public void onModeUpdate(EnumMode mode) {
        if (mode != EnumMode.INJURED && this.appliedIncapChanges) {
            this.appliedIncapChanges = false;
            this.onExitingIncapMode();
        } else if (mode == EnumMode.INJURED && !this.appliedIncapChanges) {
            this.appliedIncapChanges = true;
            this.onEnteringIncapMode();
        }
    }

    private void onEnteringIncapMode() {
        this.recoveryMultiplier = 1;
        this.bandagesCount = 0;
        this.dog.setAttributeModifier(class_5134.field_23719, INCAP_MOVEMENT, (d, u) -> new class_1322(u, "Defeated Slowness", -0.5, class_1322.class_1323.field_6331));
        this.dog.setDrunkTicks(0);
    }

    private void onExitingIncapMode() {
        this.recoveryMultiplier = 1;
        this.bandagesCount = 0;
        this.dog.removeAttributeModifier(class_5134.field_23719, INCAP_MOVEMENT);
        this.incapMsg = "";
    }

    public void tick() {
        if (this.dog.method_37908().field_9236) {
            this.incapacitatedClientTick();
        } else {
            this.incapacitatedTick();
        }
    }

    public class_1269 interact(class_1799 stack, class_1657 player, class_1268 hand) {
        if (this.proccessBandage(stack, player).method_23666()) {
            return class_1269.field_5812;
        }
        class_1792 item = stack.method_7909();
        if (item == class_1802.field_8288) {
            this.useTotem(stack, player);
            return class_1269.field_5812;
        }
        if (this.handleOwnerRide(stack, player).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.proccessSitStandOrder(player).method_23666()) {
            return class_1269.field_5812;
        }
        if (this.dog.method_37908().field_9236 && player == this.dog.method_35057()) {
            DogCannotInteractWithScreen.open(this.dog);
        }
        return class_1269.field_5812;
    }

    private class_1269 proccessBandage(class_1799 stack, class_1657 player) {
        boolean isBandage;
        boolean wagyu = this.needWagyu();
        boolean bl = isBandage = wagyu && stack.method_7909() == DoggyItems.GOLDEN_A_FIVE_WAGYU.get() || !wagyu && stack.method_7909() == DoggyItems.BANDAID.get();
        if (isBandage) {
            this.useBandage(stack, player);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void useBandage(class_1799 stack, class_1657 player) {
        if (this.dog.method_37908().field_9236) {
            return;
        }
        if ((float)this.bandageCooldown > 0.0f) {
            return;
        }
        if (this.bandagesCount >= 8) {
            return;
        }
        this.bandageCooldown = 10;
        player.method_7357().method_7906(stack.method_7909(), 11);
        ++this.bandagesCount;
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        if (this.bandagesCount >= 8) {
            this.dog.triggerAnimationAction(new DogFaintStandAction(this.dog, this.getFaintStandAnim()));
        }
        if (player instanceof class_3222) {
            class_3222 sP = (class_3222)player;
            DoggyAdvancementTriggers.DOG_BANDAID_APPLY_TRIGGER.trigger(this.dog, sP);
        }
    }

    private void useTotem(class_1799 stack, class_1657 player) {
        if (this.dog.method_37908().field_9236) {
            return;
        }
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        List<Dog> defeatedDogs = DogUtil.getOtherIncapacitatedDogNearby(this.dog);
        for (Dog d : defeatedDogs) {
            d.setDogIncapValue(0);
            this.incapacitatedExit();
            d.method_6092(new class_1293(class_1294.field_5924, 900, 1));
            d.method_6092(new class_1293(class_1294.field_5898, 100, 1));
            d.method_6092(new class_1293(class_1294.field_5918, 800, 0));
        }
        this.dog.method_37908().method_8421((class_1297)this.dog, (byte)35);
    }

    private class_1269 handleOwnerRide(class_1799 stack, class_1657 player) {
        if (player.method_5626((class_1297)this.dog)) {
            if (!this.dog.method_37908().field_9236) {
                this.dog.method_18375();
            }
            return class_1269.field_5812;
        }
        class_1792 item = stack.method_7909();
        if (item != class_1802.field_8606) {
            return class_1269.field_5811;
        }
        if (this.dog.method_5782()) {
            return class_1269.field_5811;
        }
        if (this.dog.method_35057() != player) {
            return class_1269.field_5811;
        }
        if (!this.dog.method_37908().field_9236 && this.dog.method_5804((class_1297)player)) {
            player.method_7353((class_2561)class_2561.method_43469((String)"talent.doggytalents.bed_finder.dog_mount", (Object[])new Object[]{this.dog.getGenderPronoun()}), true);
        }
        return class_1269.field_5812;
    }

    private class_1269 proccessSitStandOrder(class_1657 player) {
        if (!this.canMove()) {
            return class_1269.field_5811;
        }
        UUID owner_uuid = this.dog.method_6139();
        if (owner_uuid == null) {
            return class_1269.field_5811;
        }
        if (!owner_uuid.equals(player.method_5667())) {
            return class_1269.field_5811;
        }
        this.dog.method_24346(!this.dog.method_24345());
        this.dog.method_5942().method_6340();
        return class_1269.field_5812;
    }

    public void onHurt() {
        if (((Boolean)ConfigHandler.SERVER.INCAP_VAL_RESET_WHEN_HURT.get()).booleanValue()) {
            this.dropBandages();
            int currentIncapVal = this.dog.getDogIncapValue();
            if (currentIncapVal < this.dog.getDefaultInitIncapVal()) {
                this.dog.setDogIncapValue(this.dog.getDefaultInitIncapVal());
            }
        }
    }

    private void dropBandages() {
        if (this.needWagyu()) {
            return;
        }
        float keep_precentage = 0.8f - (float)this.dog.method_6051().method_43048(4) * 0.1f;
        int keep_amount = class_3532.method_15375((float)(keep_precentage * (float)this.bandagesCount));
        for (int i = 0; i < keep_amount; ++i) {
            class_1264.method_5449((class_1937)this.dog.method_37908(), (double)this.dog.method_23317(), (double)this.dog.method_23318(), (double)this.dog.method_23321(), (class_1799)new class_1799((class_1935)DoggyItems.BANDAID.get(), 1));
        }
        this.bandageCooldown = 200;
        this.bandagesCount = 0;
        IncapacitatedSyncState incap_state = this.dog.getIncapSyncState();
        IncapacitatedSyncState new_incap_state = incap_state.updateBandaid(this.bandagesCount);
        if (new_incap_state != incap_state) {
            this.dog.setIncapSyncState(new_incap_state);
        }
    }

    private void displayToastIncapacitated(class_1657 player) {
        player.method_7353((class_2561)class_2561.method_43471((String)"doggui.invalid_dog.incapacitated.title").method_27692(class_124.field_1061), true);
    }

    public void incapacitatedClientTick() {
        this.drownPoseTick = this.isDogDeepInFluid() ? ++this.drownPoseTick : 0;
        if (this.dog.isDogVariantRenderEffective() && this.dog.dogVariant().customInjuredTexture().isPresent()) {
            return;
        }
        IncapacitatedSyncState sync_state = this.dog.getIncapSyncState();
        DefeatedType type = sync_state.type;
        switch (type) {
            case BURN: {
                if (this.dog.getDogIncapValue() < this.dog.getDefaultInitIncapVal() - 10) break;
                for (int i = 0; i < 2; ++i) {
                    float f1 = (this.dog.method_6051().method_43057() * 2.0f - 1.0f) * this.dog.method_17681() * 0.8f;
                    float f2 = (this.dog.method_6051().method_43057() * 2.0f - 1.0f) * this.dog.method_17681() * 0.8f;
                    this.dog.method_37908().method_8406((class_2394)class_2398.field_22247, this.dog.method_23317() + (double)f1, this.dog.method_23318() + 0.4, this.dog.method_23321() + (double)f2, 0.0, -0.05, 0.0);
                }
                if (this.dog.method_6051().method_43048(3) != 0) break;
                float f1 = (this.dog.method_6051().method_43057() * 2.0f - 1.0f) * this.dog.method_17681() * 0.5f;
                float f2 = (this.dog.method_6051().method_43057() * 2.0f - 1.0f) * this.dog.method_17681() * 0.5f;
                this.dog.method_37908().method_8406((class_2394)class_2398.field_11251, this.dog.method_23317() + (double)f1, this.dog.method_23318() + (double)this.dog.method_5751(), this.dog.method_23321() + (double)f2, 0.0, 0.05, 0.0);
                break;
            }
            case BLOOD: {
                if (this.dog.getDogIncapValue() < this.dog.getDefaultInitIncapVal() - 10 || this.dog.field_6012 % 8 != 0) break;
                for (int i = 0; i < 2; ++i) {
                    float f1 = (this.dog.method_6051().method_43057() * 2.0f - 1.0f) * this.dog.method_17681() * 0.8f;
                    float f2 = (this.dog.method_6051().method_43057() * 2.0f - 1.0f) * this.dog.method_17681() * 0.8f;
                    this.dog.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8790)), this.dog.method_23317() + (double)f1, this.dog.method_23318() + 0.4, this.dog.method_23321() + (double)f2, 0.0, -0.05, 0.0);
                }
                break;
            }
            case DROWN: {
                if (this.dog.getDogIncapValue() < this.dog.getDefaultInitIncapVal() - 10 || this.dog.field_6012 % 8 != 0) break;
                for (int i = 0; i < 2; ++i) {
                    float f1 = (this.dog.method_6051().method_43057() * 2.0f - 1.0f) * this.dog.method_17681() * 0.8f;
                    float f2 = (this.dog.method_6051().method_43057() * 2.0f - 1.0f) * this.dog.method_17681() * 0.8f;
                    this.dog.method_37908().method_8406((class_2394)class_2398.field_11202, this.dog.method_23317() + (double)f1, this.dog.method_23318() + 0.4, this.dog.method_23321() + (double)f2, 0.0, -0.05, 0.0);
                }
                break;
            }
        }
    }

    public void incapacitatedTick() {
        IncapacitatedSyncState incap_state;
        IncapacitatedSyncState new_incap_state;
        if (this.dog.getDogIncapValue() <= 0) {
            this.incapacitatedExit();
            return;
        }
        if (this.partialRecoverVal >= 1.0f) {
            this.dog.setDogIncapValue(this.dog.getDogIncapValue() - 1);
            this.partialRecoverVal = 0.0f;
        }
        if (this.bandageCooldown > 0) {
            --this.bandageCooldown;
        }
        if ((new_incap_state = (incap_state = this.dog.getIncapSyncState()).updateBandaid(this.bandagesCount)) != incap_state) {
            this.dog.setIncapSyncState(new_incap_state);
        }
        if (!((Boolean)ConfigHandler.SERVER.INCAP_VAL_RESET_WHEN_HURT.get()).booleanValue() && this.bandagesCount > 0 && this.isConditionDestroyBandages(this.dog)) {
            this.dropBandages();
            return;
        }
        this.healWithBandaid(new_incap_state.bandaid);
        class_1309 owner = this.dog.method_35057();
        class_2680 dog_b0_state = this.dog.method_37908().method_8320(this.dog.method_24515());
        class_2248 dog_b0_block = dog_b0_state.method_26204();
        if (dog_b0_block == class_2246.field_10124) {
            this.partialRecoverVal += 0.001f * (float)this.recoveryMultiplier;
        } else if (dog_b0_block == DoggyBlocks.DOG_BED.get() || dog_b0_state.method_26164(class_3481.field_16443)) {
            this.incapacitatedHealWithBed(owner);
        }
    }

    private boolean isConditionDestroyBandages(Dog dog) {
        if (!dog.method_5753() && dog.method_5809()) {
            return true;
        }
        if (!dog.canSwimUnderwater() && dog.method_5799()) {
            return true;
        }
        return !dog.dogFallImmune() && dog.field_6017 > 3.0f;
    }

    private void incapacitatedExit() {
        int bandaid_count0 = this.bandagesCount;
        this.dog.maxHealth();
        this.dog.setMode(EnumMode.DOCILE);
        this.dog.setDogHunger(this.dog.getMaxHunger());
        this.dog.setDogIncapValue(0);
        this.dog.method_24346(true);
        this.dog.setIncapSyncState(IncapacitatedSyncState.NONE);
        this.dog.triggerAnimationAction(new DogBounceAction(this.dog));
        this.dog.method_6012();
        class_1937 class_19372 = this.dog.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 sL = (class_3218)class_19372;
            sL.method_14199((class_2394)class_2398.field_11201, this.dog.method_23317(), this.dog.method_23318(), this.dog.method_23321(), 24, (double)this.dog.method_17681(), (double)0.8f, (double)this.dog.method_17681(), 0.1);
        }
        if (bandaid_count0 > 0) {
            class_1309 owner = this.dog.method_35057();
            this.triggerAdvancement(owner, bandaid_count0);
        }
    }

    private void triggerAdvancement(class_1309 player, int bandages_count0) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 sP = (class_3222)player;
        DoggyAdvancementTriggers.DOG_RECOVERED_TRIGGER.trigger(this.dog, sP, false);
        if (this.isBestRecoveryCondition(bandages_count0)) {
            DoggyAdvancementTriggers.DOG_RECOVERED_TRIGGER.trigger(this.dog, sP, true);
        }
    }

    private boolean isBestRecoveryCondition(int bandaid_count0) {
        if (bandaid_count0 < 8) {
            return false;
        }
        class_2680 dog_b0_state = this.dog.method_37908().method_8320(this.dog.method_24515());
        class_2248 dog_b0_block = dog_b0_state.method_26204();
        boolean is_laying_bed = dog_b0_block == DoggyBlocks.DOG_BED.get() || dog_b0_state.method_26164(class_3481.field_16443);
        return is_laying_bed;
    }

    private void incapacitatedHealWithBed(class_1309 owner) {
        this.partialRecoverVal += 0.002f * (float)this.recoveryMultiplier;
        if (owner == null) {
            return;
        }
        if (this.dog.method_5858((class_1297)owner) > 100.0) {
            return;
        }
        this.partialRecoverVal += 0.02f * (float)this.recoveryMultiplier;
        if (!(this.dog.method_37908() instanceof class_3218)) {
            return;
        }
        if (this.dog.field_6012 % 10 != 0) {
            return;
        }
        ((class_3218)this.dog.method_37908()).method_14199((class_2394)class_2398.field_11201, this.dog.method_23317(), this.dog.method_23318(), this.dog.method_23321(), 1, (double)this.dog.method_17681(), (double)0.8f, (double)this.dog.method_17681(), 0.1);
    }

    private void healWithBandaid(BandaidState state) {
        switch (state) {
            case FULL: {
                this.partialRecoverVal += 0.02f * (float)this.recoveryMultiplier;
                break;
            }
            case HALF: {
                this.partialRecoverVal += 0.01f * (float)this.recoveryMultiplier;
                break;
            }
        }
    }

    public boolean canMove() {
        return this.dog.getIncapSyncState().bandaid == BandaidState.FULL;
    }

    public void save(class_2487 tag) {
        class_2487 tg0 = new class_2487();
        IncapacitatedSyncState syncState = this.dog.getIncapSyncState();
        tg0.method_10569("type", syncState.type.getId());
        tg0.method_10569("bandaid", this.bandagesCount);
        tg0.method_10569("poseid", syncState.poseId);
        tg0.method_10582("incapMsg", this.incapMsg);
        tag.method_10566("doggyIncapacitated", (class_2520)tg0);
    }

    public void load(class_2487 tag) {
        class_2487 tg0 = tag.method_10562("doggyIncapacitated");
        DefeatedType type = DefeatedType.byId(tg0.method_10550("type"));
        int bandaid_count = tg0.method_10550("bandaid");
        int poseId = tg0.method_10550("poseid");
        this.incapMsg = tg0.method_10558("incapMsg");
        this.bandagesCount = bandaid_count;
        this.dog.setIncapSyncState(new IncapacitatedSyncState(type, BandaidState.getState(bandaid_count), poseId));
    }

    public DogPose getPose() {
        int id = this.dog.getIncapSyncState().poseId;
        if (this.showDrownPose()) {
            return DogPose.DROWN;
        }
        switch (id) {
            default: {
                return DogPose.FAINTED;
            }
            case 1: 
        }
        return DogPose.FAINTED_2;
    }

    public DogAnimation getAnim() {
        int id = this.dog.getIncapSyncState().poseId;
        if (this.showDrownPose()) {
            return DogAnimation.DROWN;
        }
        switch (id) {
            default: {
                return DogAnimation.FAINT;
            }
            case 1: 
        }
        return DogAnimation.FAINT_2;
    }

    private boolean isDogDeepInFluid() {
        Optional<class_6862<class_3611>> type = this.dog.getMaxFluidHeight();
        if (!type.isPresent()) {
            return false;
        }
        if (type.get().equals((Object)class_3486.field_15518) && this.dog.method_5753()) {
            return false;
        }
        double height = this.dog.method_5861(type.get());
        return height > 0.5;
    }

    private boolean showDrownPose() {
        return this.drownPoseTick > 20;
    }

    public DogAnimation getFaintStandAnim() {
        int id = this.dog.getIncapSyncState().poseId;
        if (this.dog.method_5799() || this.dog.method_5771()) {
            return DogAnimation.NONE;
        }
        switch (id) {
            default: {
                return DogAnimation.FAINT_STAND_1;
            }
            case 1: 
        }
        return DogAnimation.FAINT_STAND_2;
    }

    public void setIncapMsg(String s) {
        if (s == null) {
            return;
        }
        if (((String)s).isEmpty()) {
            return;
        }
        if (((String)s).length() > 256) {
            s = ((String)s).substring(0, 250) + "..";
        }
        this.incapMsg = s;
    }

    public String getIncapMsg() {
        return this.incapMsg;
    }

    private boolean needWagyu() {
        return this.dog.getIncapSyncState().type == DefeatedType.STARVE;
    }

    public static class IncapacitatedSyncState {
        public static IncapacitatedSyncState NONE = new IncapacitatedSyncState(DefeatedType.NONE);
        public DefeatedType type = DefeatedType.NONE;
        public BandaidState bandaid = BandaidState.NONE;
        public int poseId = 0;

        public IncapacitatedSyncState(DefeatedType type) {
            this.type = type;
        }

        public IncapacitatedSyncState(DefeatedType type, BandaidState bandaid) {
            this.type = type;
            this.bandaid = bandaid;
        }

        public IncapacitatedSyncState(DefeatedType type, BandaidState bandaid, int poseId) {
            this.type = type;
            this.bandaid = bandaid;
            this.poseId = poseId;
        }

        public IncapacitatedSyncState copy() {
            return new IncapacitatedSyncState(this.type, this.bandaid, this.poseId);
        }

        public IncapacitatedSyncState updateBandaid(int bandaid_count) {
            BandaidState new_state = BandaidState.getState(bandaid_count);
            if (new_state == this.bandaid) {
                return this;
            }
            return new IncapacitatedSyncState(this.type, new_state, this.poseId);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IncapacitatedSyncState)) {
                return false;
            }
            IncapacitatedSyncState state = (IncapacitatedSyncState)obj;
            if (this.type != state.type) {
                return false;
            }
            if (this.bandaid != state.bandaid) {
                return false;
            }
            return this.poseId == state.poseId;
        }
    }

    public static enum DefeatedType {
        NONE(0),
        BLOOD(1),
        BURN(2),
        POISON(3),
        DROWN(4),
        STARVE(5);

        private final int id;

        private DefeatedType(int id) {
            this.id = id;
        }

        public static DefeatedType byId(int i) {
            DefeatedType[] values = DefeatedType.values();
            if (i < 0) {
                return NONE;
            }
            if (i >= values.length) {
                return NONE;
            }
            return values[i];
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum BandaidState {
        NONE(0),
        HALF(1),
        FULL(2);

        private final int id;

        private BandaidState(int id) {
            this.id = id;
        }

        public static BandaidState byId(int i) {
            BandaidState[] values = BandaidState.values();
            if (i < 0) {
                return NONE;
            }
            if (i >= values.length) {
                return NONE;
            }
            return values[i];
        }

        public static BandaidState getState(int bandaid_count) {
            if (bandaid_count <= 3) {
                return NONE;
            }
            if (bandaid_count <= 7) {
                return HALF;
            }
            return FULL;
        }

        public int getId() {
            return this.id;
        }
    }
}

