/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogGreetOwnerAction;
import doggytalents.common.storage.DogLocationStorage;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class DogOwnerDistanceManager {
    private static final int OWNER_FAR_AWAY_DISTANCE_SQR = 400;
    private static final int OWNER_START_GREET_DISTANCE_SQR = 144;
    private static final long START_MISSING_OWNER_TIME = 96000L;
    private static final int UPDATE_INTERVAL = 5;
    private final Dog dog;
    private long lastWithOwnerTime;
    private boolean willGreet;
    private int tickTillUpdate;
    private long lastOwnerLeftInteval;

    public DogOwnerDistanceManager(Dog dog) {
        this.dog = dog;
        this.lastWithOwnerTime = dog.method_37908().method_8532();
    }

    public void tick() {
        if (--this.tickTillUpdate <= 0) {
            this.tickTillUpdate = 5;
            class_1309 owner = this.dog.method_35057();
            if (owner != null) {
                this.updateGreetingCondition(this.dog, owner);
            }
        }
    }

    private void updateGreetingCondition(Dog dog, @Nonnull class_1309 owner) {
        if (this.isOwnerReturned(dog, owner)) {
            long gtime = dog.method_37908().method_8532();
            long dtime = gtime - this.lastWithOwnerTime;
            if (dtime >= 96000L) {
                this.willGreet = true;
                this.lastOwnerLeftInteval = dtime;
            }
            this.lastWithOwnerTime = gtime;
        }
        if (this.canStartGreeting(dog, owner)) {
            this.triggerGreetingAction(dog, owner, this.lastOwnerLeftInteval);
            this.lastOwnerLeftInteval = 0L;
        }
    }

    private boolean isOwnerReturned(Dog dog, class_1309 owner) {
        return dog.method_5858((class_1297)owner) < 400.0;
    }

    private boolean canStartGreeting(Dog dog, class_1309 owner) {
        return this.willGreet && dog.method_5858((class_1297)owner) <= 144.0 && !owner.method_7325() && !dog.isBusy();
    }

    public void save(class_2487 tag) {
        class_2487 tg0 = new class_2487();
        tg0.method_10544("lastWithOwnerTime", this.lastWithOwnerTime);
        tg0.method_10556("willGreet", this.willGreet);
        tag.method_10566("ownerDistanceManager", (class_2520)tg0);
    }

    public void load(class_2487 tag) {
        if (tag.method_10573("ownerDistanceManager", 10)) {
            class_2487 tg0 = tag.method_10562("ownerDistanceManager");
            this.lastWithOwnerTime = tg0.method_10537("lastWithOwnerTime");
            this.willGreet = tg0.method_10577("willGreet");
        } else {
            this.lastWithOwnerTime = this.dog.method_37908().method_8532();
            this.willGreet = false;
        }
    }

    public void triggerGreetingAction(Dog dog, @Nonnull class_1309 owner, long ownerLeftInterval) {
        this.willGreet = false;
        boolean greetOwnerEnabled = (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DOG_GREET_OWNER);
        int greetOwnerLimit = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DOG_GREET_OWNER_LIMIT);
        if (!greetOwnerEnabled) {
            return;
        }
        if (greetOwnerLimit > 0 && DogOwnerDistanceManager.getGreetCountForOwner(owner) >= greetOwnerLimit) {
            return;
        }
        dog.triggerAction(new DogGreetOwnerAction(dog, owner, ownerLeftInterval));
    }

    public static int getGreetCountForOwner(class_1309 owner) {
        DogLocationStorage storage = DogLocationStorage.get(owner.method_5682());
        return storage.GREETING_DOG_LIMIT_MAP.getOrDefault(owner.method_5667(), 0);
    }

    public static void incGreetCountForOwner(class_1309 owner) {
        DogLocationStorage storage = DogLocationStorage.get(owner.method_5682());
        storage.GREETING_DOG_LIMIT_MAP.compute(owner.method_5667(), (uuid, old_val) -> {
            if (old_val == null) {
                return 1;
            }
            return old_val + 1;
        });
    }

    public static void decGreetCountForOwner(class_1309 owner) {
        DogLocationStorage storage = DogLocationStorage.get(owner.method_5682());
        storage.GREETING_DOG_LIMIT_MAP.computeIfPresent(owner.method_5667(), (uuid, old_val) -> {
            if (old_val == null) {
                return null;
            }
            int new_val = old_val - 1;
            if (new_val <= 0) {
                return null;
            }
            return new_val;
        });
    }
}

