/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DoggyTags;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.feature.FoodHandler;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1799;

public class DogBegGoal
extends class_1352 {
    private final Dog dog;
    private final float minPlayerDistance;
    private class_1309 owner;
    private int timeoutCounter;

    public DogBegGoal(Dog wolf, float minDistance) {
        this.dog = wolf;
        this.minPlayerDistance = minDistance;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.dog.isDogResting()) {
            return false;
        }
        if (!this.dog.getAnim().freeHead() && this.dog.getAnim() != DogAnimation.NONE) {
            return false;
        }
        class_1309 owner = this.dog.method_35057();
        if (owner == null) {
            return false;
        }
        if (!owner.method_5805() || owner.method_7325()) {
            return false;
        }
        if (owner.method_5858((class_1297)this.dog) > (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            return false;
        }
        if (!this.hasTemptationItemInHand(owner)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean method_6266() {
        if (!this.owner.method_5805() || this.owner.method_7325()) {
            return false;
        }
        if (this.dog.method_5858((class_1297)this.owner) > (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            return false;
        }
        return this.timeoutCounter > 0 && this.hasTemptationItemInHand(this.owner);
    }

    public void method_6269() {
        this.dog.setBegging(true);
        this.timeoutCounter = 40 + this.dog.method_6051().method_43048(40);
    }

    public void method_6270() {
        this.dog.setBegging(false);
        this.owner = null;
    }

    public void method_6268() {
        this.dog.method_5988().method_6230(this.owner.method_23317(), this.owner.method_23320(), this.owner.method_23321(), 10.0f, (float)this.dog.method_5978());
        --this.timeoutCounter;
    }

    private boolean hasTemptationItemInHand(class_1309 player) {
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemstack = player.method_5998(hand);
            if (itemstack.method_31573(this.dog.method_6181() ? DoggyTags.BEG_ITEMS_TAMED : DoggyTags.BEG_ITEMS_UNTAMED)) {
                return true;
            }
            if (itemstack.method_31573(DoggyTags.TREATS)) {
                return true;
            }
            if (!FoodHandler.isFood(itemstack, this.dog).isPresent()) continue;
            return true;
        }
        return false;
    }
}

