/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.inferface.InferTypeContext;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogFlyingNavigation;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;

public class DogMeleeAttackGoal
extends class_1352 {
    protected final Dog dog;
    private final double speedModifier;
    private int ticksUntilPathRecalc = 10;
    private int ticksUntilNextAttack;
    private final int timeOutTick = 40;
    private int waitingTick;
    private class_2338.class_2339 dogPos0;
    private int detectReachPenalty = 0;
    private final float START_LEAPING_AT_DIS_SQR = 2.0f;
    private final float DONT_LEAP_AT_DIS_SQR = 1.0f;
    private final float LEAP_YD = 0.4f;

    public DogMeleeAttackGoal(Dog dog) {
        this.dog = dog;
        this.speedModifier = 1.0;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target;
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (this.dog.isDogLowHealth() && this.dog.getLowHealthStrategy() == Dog.LowHealthStrategy.RUN_AWAY) {
            return false;
        }
        if (this.dog.field_6017 > 7.0f) {
            return false;
        }
        boolean restriction = false;
        if (this.dog.getMode().shouldFollowOwner() && this.dog.getCombatReturnStrategy() != Dog.CombatReturnStrategy.NONE) {
            class_1309 owner = this.dog.method_35057();
            if (owner != null && this.dog.method_5858((class_1297)owner) > this.getMaxDistanceAwayFromOwner()) {
                return false;
            }
        } else {
            restriction = !this.dog.patrolTargetLock();
        }
        if ((target = this.dog.method_5968()) == null) {
            return false;
        }
        if (!target.method_5805()) {
            this.dog.method_5980(null);
            return false;
        }
        if (this.dog.getDogRangedAttack().isApplicable(this.dog)) {
            return false;
        }
        if (restriction && !this.dog.method_18407(target.method_24515())) {
            return false;
        }
        if (--this.detectReachPenalty > 0) {
            return false;
        }
        double d0 = this.dog.method_5858((class_1297)target);
        this.detectReachPenalty = 5;
        this.detectReachPenalty += d0 > 256.0 ? 10 : 5;
        class_11 p = this.dog.method_5942().method_6349((class_1297)target, 1);
        if (p == null) {
            return false;
        }
        if (!DogUtil.canPathReachTargetBlock(this.dog, p, target.method_24515(), 1, this.dog.method_5850())) {
            this.dog.method_5980(null);
            return false;
        }
        return true;
    }

    public boolean method_6266() {
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (this.dog.field_6017 > 7.0f) {
            return false;
        }
        boolean restriction = false;
        if (this.dog.getMode().shouldFollowOwner() && this.dog.getCombatReturnStrategy() != Dog.CombatReturnStrategy.NONE) {
            class_1309 owner = this.dog.method_35057();
            if (owner != null && this.dog.method_5858((class_1297)owner) > this.getMaxDistanceAwayFromOwner()) {
                return false;
            }
        } else {
            boolean bl = restriction = !this.dog.patrolTargetLock();
        }
        if (this.waitingTick > this.timeOutTick) {
            return false;
        }
        class_1309 livingentity = this.dog.method_5968();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.method_5805()) {
            return false;
        }
        if (restriction && !this.dog.method_18407(livingentity.method_24515())) {
            return false;
        }
        return !(livingentity instanceof class_1657) || !livingentity.method_7325() && !((class_1657)livingentity).method_7337();
    }

    public void method_6269() {
        this.dog.method_5942().method_6335((class_1297)this.dog.method_5968(), this.speedModifier);
        this.dog.method_19540(true);
        this.ticksUntilPathRecalc = 0;
        this.ticksUntilNextAttack = 0;
        this.waitingTick = 0;
        this.dogPos0 = this.dog.method_24515().method_25503();
    }

    public void method_6270() {
        class_1309 livingentity = this.dog.method_5968();
        this.dog.method_5980(null);
        this.dog.method_19540(false);
        this.dog.method_5942().method_6340();
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_1309 e = this.dog.method_5968();
        if (e == null) {
            return;
        }
        class_1408 n = this.dog.method_5942();
        class_2338 dog_bp = this.dog.method_24515();
        class_2338 target_bp = e.method_24515();
        if (this.dog.isDogFlying() && this.flyingDogDashToTargetIfNeeded(e)) {
            return;
        }
        if (dog_bp.equals((Object)this.dogPos0)) {
            ++this.waitingTick;
        } else {
            this.waitingTick = 0;
            this.dogPos0.method_10103(dog_bp.method_10263(), dog_bp.method_10264(), dog_bp.method_10260());
        }
        this.dog.method_5988().method_6226((class_1297)e, 30.0f, 30.0f);
        double d0 = this.dog.method_5649(e.method_23317(), e.method_23318(), e.method_23321());
        if (this.ticksUntilPathRecalc <= 0) {
            this.ticksUntilPathRecalc = 10;
            n.method_6335((class_1297)e, this.speedModifier);
        }
        --this.ticksUntilPathRecalc;
        --this.ticksUntilNextAttack;
        if (n.method_6357() && dog_bp.method_10262((class_2382)target_bp) <= 2.25 && !this.canReachTarget(e, d0) && this.isTargetInSafeArea(this.dog, e, target_bp)) {
            this.dog.method_5962().method_6239(e.method_23317(), e.method_23318(), e.method_23321(), this.speedModifier);
        }
        if (n.method_6357() && this.dog.field_6012 % 2 != 0 && !this.canReachTarget(e, d0)) {
            this.ticksUntilPathRecalc = 0;
        }
        if (this.checkAndPerformAttack(e, d0)) {
            this.waitingTick = 0;
        }
        this.checkAndLeapAtTarget(e);
    }

    protected void checkAndLeapAtTarget(class_1309 target) {
        if (!this.canLeapAtTarget(target)) {
            return;
        }
        class_243 vec3 = this.dog.method_18798();
        class_243 vec31 = new class_243(target.method_23317() - this.dog.method_23317(), 0.0, target.method_23321() - this.dog.method_23321());
        if (vec31.method_1027() > 1.0E-7) {
            vec31 = vec31.method_1029().method_1021(0.4);
        }
        double d = vec31.field_1352;
        Objects.requireNonNull(this);
        this.dog.method_18800(d, 0.4f, vec31.field_1350);
    }

    private boolean flyingDogDashToTargetIfNeeded(class_1309 target) {
        double d_sqr = this.dog.method_5858((class_1297)target);
        if (d_sqr > 16.0) {
            return false;
        }
        if (this.dog.field_6012 % 5 != 0) {
            return false;
        }
        class_1408 class_14082 = this.dog.method_5942();
        if (!(class_14082 instanceof DogFlyingNavigation)) {
            return false;
        }
        DogFlyingNavigation flyNav = (DogFlyingNavigation)class_14082;
        if (!flyNav.canDashToTarget(target)) {
            return false;
        }
        flyNav.method_6340();
        this.dog.method_5962().method_6239(target.method_19538().field_1352, target.method_19538().field_1351, target.method_19538().field_1350, 2.0);
        this.ticksUntilPathRecalc = 10;
        return true;
    }

    protected boolean canLeapAtTarget(@NotNull class_1309 target) {
        if (this.dog.method_5782()) {
            return false;
        }
        if (!this.dog.method_24828()) {
            return false;
        }
        if (!target.method_24828()) {
            return false;
        }
        double d0 = this.dog.method_5858((class_1297)target);
        if (!(d0 >= 1.0) || !(d0 <= 2.0)) {
            return false;
        }
        if (this.dog.method_6051().method_43048(3) != 0) {
            return false;
        }
        class_2338 tpos = target.method_24515();
        if (class_14.method_23476((class_1922)this.dog.method_37908(), (class_2338.class_2339)tpos.method_25503()) != class_7.field_12) {
            return false;
        }
        class_243 v_offset = new class_243(target.method_23317() - this.dog.method_23317(), 0.0, target.method_23321() - this.dog.method_23321()).method_1029();
        class_243 v_dog = this.dog.method_19538();
        for (int i = 1; i <= 3; ++i) {
            v_dog = v_dog.method_1019(v_offset);
            if (class_14.method_23476((class_1922)this.dog.method_37908(), (class_2338.class_2339)class_2338.method_49638((class_2374)v_dog).method_25503()) == class_7.field_12) continue;
            return false;
        }
        return true;
    }

    protected boolean checkAndPerformAttack(class_1309 target, double distanceToTargetSqr) {
        if (this.canReachTarget(target, distanceToTargetSqr) && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.dog.method_6104(class_1268.field_5808);
            this.dog.method_6121((class_1297)target);
            return true;
        }
        return false;
    }

    protected boolean isTargetInSafeArea(Dog dog, class_1309 target, class_2338 target_bp) {
        class_7 type = class_14.method_23476((class_1922)dog.method_37908(), (class_2338.class_2339)target_bp.method_25503());
        if (type == class_7.field_7) {
            return false;
        }
        return !DogUtil.isDangerPathType(type = dog.inferType(type, InferTypeContext.getDefault()));
    }

    protected boolean canReachTarget(class_1309 target, double distanceToTargetSqr) {
        return this.getAttackReachSqr(target) >= distanceToTargetSqr;
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.method_38847(20);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.method_38847(20);
    }

    protected double getAttackReachSqr(class_1309 target) {
        return this.dog.method_17681() * 2.0f * this.dog.method_17681() * 2.0f + target.method_17681();
    }

    protected double getMaxDistanceAwayFromOwner() {
        if (this.dog.getCombatReturnStrategy() == Dog.CombatReturnStrategy.FAR) {
            return 1024.0;
        }
        return 400.0;
    }
}

