/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.util.EntityUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3486;
import net.minecraft.class_3532;

public class FindWaterGoal
extends class_1352 {
    private final class_1314 creature;
    private final class_1408 navigator;
    private final class_1937 world;
    private final int waterSearchRange = 12;
    private final int safeSearchRange = 6;
    @Nullable
    private class_2338 waterPos;
    private int timeToRecalcPath;

    public FindWaterGoal(class_1314 creatureIn) {
        this.creature = creatureIn;
        this.navigator = creatureIn.method_5942();
        this.world = creatureIn.method_37908();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (!this.creature.method_24828() || this.creature.field_6012 % 5 != 0) {
            return false;
        }
        if (this.creature.method_5753()) {
            return false;
        }
        boolean isInFire = this.isInDangerSpot((class_1297)this.creature);
        boolean isOnFire = this.creature.method_5809();
        if (!isInFire && !isOnFire) {
            return false;
        }
        class_2338 entityPos = this.creature.method_24515();
        for (class_2338 pos : class_2338.method_10097((class_2338)entityPos.method_10069(-this.waterSearchRange, -4, -this.waterSearchRange), (class_2338)entityPos.method_10069(this.waterSearchRange, 4, this.waterSearchRange))) {
            if (this.getBlockType(pos) != BlockType.WATER) continue;
            this.waterPos = pos;
            break;
        }
        boolean waterBlockNearBy = this.waterPos != null;
        return waterBlockNearBy || isInFire;
    }

    public boolean method_6266() {
        if (this.waterPos != null) {
            BlockType safety = this.getBlockType(this.waterPos);
            if (safety != BlockType.WATER) {
                return false;
            }
            if (this.creature.method_5809()) {
                return true;
            }
        }
        return this.isInDangerSpot((class_1297)this.creature);
    }

    public void method_6269() {
        this.timeToRecalcPath = 0;
    }

    public void method_6268() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            class_2338 targetPos = null;
            if (this.waterPos != null) {
                targetPos = this.waterPos;
            } else if (!this.creature.method_6150()) {
                class_2338.class_2339 mutablePos = new class_2338.class_2339();
                for (int i = 0; i < 10; ++i) {
                    int j = EntityUtil.getRandomNumber((class_1309)this.creature, -this.safeSearchRange, this.safeSearchRange);
                    int k = EntityUtil.getRandomNumber((class_1309)this.creature, -4, 4);
                    int l = EntityUtil.getRandomNumber((class_1309)this.creature, -this.safeSearchRange, this.safeSearchRange);
                    mutablePos.method_10102(this.creature.method_23317() + (double)j, this.creature.method_23318() + (double)k, this.creature.method_23321() + (double)l);
                    boolean flag = this.getBlockType((class_2338)mutablePos).isSafe();
                    if (!flag) continue;
                    targetPos = mutablePos;
                    break;
                }
            }
            if (targetPos != null) {
                this.navigator.method_6337((double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260(), 1.5);
            }
        }
    }

    public void method_6270() {
        this.navigator.method_6340();
        this.waterPos = null;
    }

    public boolean isInDangerSpot(class_1297 entityIn) {
        class_238 bb = entityIn.method_5829();
        int minX = class_3532.method_15357((double)bb.field_1323);
        int minY = class_3532.method_15357((double)bb.field_1322);
        int minZ = class_3532.method_15357((double)bb.field_1321);
        int maxX = class_3532.method_15384((double)bb.field_1320);
        int maxY = class_3532.method_15384((double)bb.field_1325);
        int maxZ = class_3532.method_15384((double)bb.field_1324);
        for (class_2338 pos : class_2338.method_10094((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            BlockType safety = this.getBlockType(pos);
            if (safety != BlockType.FIRE) continue;
            return true;
        }
        return false;
    }

    public BlockType getBlockType(class_2338 posIn) {
        if (this.world.method_8316(posIn).method_15767(class_3486.field_15517)) {
            return BlockType.WATER;
        }
        if (this.world.method_8520(posIn)) {
            return BlockType.WATER;
        }
        return BlockType.SAFE;
    }

    public static enum BlockType {
        SAFE,
        FIRE,
        WATER;


        public boolean isSafe() {
            return this == SAFE || this == WATER;
        }
    }
}

