/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.IDogNavLock;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_11;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1409;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_7;
import net.minecraft.class_9;

public class DogPathNavigation
extends class_1409
implements IDogNavLock {
    private Dog dog;
    private boolean locked;

    public DogPathNavigation(Dog dog, class_1937 level) {
        super((class_1308)dog, level);
        this.dog = dog;
    }

    public void method_6360() {
        super.method_6360();
        if (this.method_6357() && this.field_6681 != null && this.field_6681.method_46()) {
            this.method_6340();
        }
    }

    protected void method_6339() {
        boolean isCloseEnough;
        if (this.invalidateIfNextNodeIsTooHigh()) {
            return;
        }
        class_243 currentPos = this.method_6347();
        this.field_6683 = 0.45f;
        class_2338 nextPos = this.field_6681.method_31032();
        double dx = Math.abs(this.field_6684.method_23317() - ((double)nextPos.method_10263() + 0.5));
        double dy = Math.abs(this.field_6684.method_23318() - (double)nextPos.method_10264());
        double dz = Math.abs(this.field_6684.method_23321() - ((double)nextPos.method_10260() + 0.5));
        boolean bl = isCloseEnough = dx <= (double)this.field_6683 && dy < 1.0 && dz <= (double)this.field_6683;
        if (isCloseEnough) {
            this.field_6681.method_44();
        }
        this.method_6346(currentPos);
        this.dogCheckIfMissedFirstNodeAndMaybeSkip();
    }

    private void dogCheckIfMissedFirstNodeAndMaybeSkip() {
        boolean kinda_far_from_first_node;
        boolean missed_first_node;
        if (this.method_6357()) {
            return;
        }
        class_11 path = this.method_6345();
        if (path == null || path.method_38() < 2) {
            return;
        }
        boolean bl = missed_first_node = path.method_39() == 0;
        if (!missed_first_node) {
            return;
        }
        class_9 first_node = path.method_40(0);
        class_9 second_node = path.method_40(1);
        if (second_node.field_41 != class_7.field_12) {
            return;
        }
        double min_bb_clip = 0.1;
        double max_dist_from_first_node = 0.5 + (double)(this.dog.method_17681() / 2.0f) - 0.1;
        double dog_dist_from_first_node_sqr = this.dog.method_5707(new class_243((double)first_node.field_40 + 0.5, this.dog.method_23318(), (double)first_node.field_38 + 0.5));
        boolean bl2 = kinda_far_from_first_node = dog_dist_from_first_node_sqr > max_dist_from_first_node * max_dist_from_first_node;
        if (kinda_far_from_first_node) {
            return;
        }
        class_2338 bpos = this.dog.method_24515();
        int y_diff = second_node.field_39 - bpos.method_10264();
        if (y_diff > 0 || y_diff < -1) {
            return;
        }
        class_243 pos = this.dog.method_19538();
        class_243 second_node_pos = class_243.method_24955((class_2382)second_node.method_22879());
        class_243 dist_vec = pos.method_1020(second_node_pos);
        double len_xz_sqr = dist_vec.field_1352 * dist_vec.field_1352 + dist_vec.field_1350 * dist_vec.field_1350;
        if (len_xz_sqr > 2.0) {
            return;
        }
        path.method_44();
    }

    protected boolean invalidateIfNextNodeIsTooHigh() {
        boolean is_first_fence_node;
        class_11 path = this.field_6681;
        if (path == null) {
            return true;
        }
        class_2338 nextPos = path.method_31032();
        double dy = this.dog.method_23318() - (double)nextPos.method_10264();
        if (dy < -1.75) {
            this.method_6340();
            return true;
        }
        class_9 nextNode = path.method_29301();
        boolean bl = is_first_fence_node = nextNode.field_41 == class_7.field_10 && path.method_39() == 0;
        if (!is_first_fence_node && this.dog.method_5944(nextNode.field_41) < 0.0f) {
            this.method_6340();
            return true;
        }
        return false;
    }

    protected boolean method_6358() {
        return super.method_6358() && !this.dog.isOnSwitchNavCooldown() && !this.locked;
    }

    public void method_6356() {
        boolean prevLock = this.locked;
        this.locked = false;
        super.method_6356();
        this.locked = prevLock;
    }

    protected boolean method_26338(class_7 type) {
        if (this.dog.method_5753()) {
            if (type == class_7.field_14) {
                return true;
            }
            if (type == class_7.field_3) {
                return true;
            }
            if (type == class_7.field_9) {
                return true;
            }
        }
        return super.method_26338(type);
    }

    public boolean method_6333(class_2338 pos) {
        if (this.dog.method_5753() && this.field_6677.method_8316(pos).method_15767(class_3486.field_15518)) {
            return true;
        }
        return super.method_6333(pos);
    }

    protected class_13 method_6336(int p_26453_) {
        this.field_6678 = new class_14(){

            protected double method_37003(class_2338 pos) {
                if (DogPathNavigation.this.dog.method_5753() && this.field_20622.method_8316(pos).method_15767(class_3486.field_15518)) {
                    return pos.method_10264();
                }
                return super.method_37003(pos);
            }

            @Nullable
            protected class_9 method_62(int x, int y, int z, int floorLevel, double maxUpStep, class_2350 dir, class_7 centerType) {
                if (centerType == class_7.field_23 && DogPathNavigation.this.dog.canDogPassGate()) {
                    centerType = class_7.field_12;
                }
                return super.method_62(x, y, z, floorLevel, maxUpStep, dir, centerType);
            }

            public class_7 method_17(class_1922 getter, int x, int y, int z) {
                class_2680 state;
                class_7 retType = super.method_17(getter, x, y, z);
                if (retType == class_7.field_10 && DogPathNavigation.this.dog.canDogPassGate() && (state = getter.method_8320(new class_2338(x, y, z))).method_26204() instanceof class_2349) {
                    retType = class_7.field_12;
                }
                return retType;
            }
        };
        this.field_6678.method_15(true);
        return new class_13(this.field_6678, p_26453_);
    }

    @Override
    public void lockDogNavigation() {
        this.locked = true;
    }

    @Override
    public void unlockDogNavigation() {
        this.locked = false;
    }

    @Nullable
    protected class_11 method_18416(@Nonnull Set<class_2338> pos, int p_148224_, boolean p_148225_, int p_148226_, float p_148227_) {
        this.dogThrowIfLockAndDebug();
        return super.method_18416(pos, p_148224_, p_148225_, p_148226_, p_148227_);
    }

    private void dogThrowIfLockAndDebug() {
    }
}

