/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class DogPlayTagAction
extends TriggerableAction {
    private boolean ownerBeenTagged = false;
    private static final int RUN_AWAY_RADIUS = 20;
    private static final int RUN_AWAY_RADIUS_MIN = 16;
    private static final int RUN_AWAY_PATH_INTERVAL = 10;
    private static final int RUN_AWAY_LOOKBACK_INTERVAL = 20;
    private static final int RUN_AWAY_LOOKBACK_TIME = 20;
    private static final int TIME_LIMIT_PER_TURN = 400;
    private int tickTillPathRecalc;
    private int cooldownChase;
    private int timeLeft;
    private int tickTillLook;
    private class_1309 owner;

    public DogPlayTagAction(Dog dog, class_1309 owner) {
        super(dog, true, true);
        this.owner = owner;
    }

    @Override
    public void onStart() {
        this.timeLeft = 400;
        this.cooldownChase = 10;
    }

    @Override
    public void tick() {
        if (!this.owner.method_5805() || this.owner.method_7325()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        --this.timeLeft;
        if (this.dog.method_5858((class_1297)this.owner) > 400.0 || this.timeLeft <= 0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            if (this.ownerBeenTagged) {
                this.owner.method_43496((class_2561)class_2561.method_43469((String)"dog.msg.play_tag.dog_win", (Object[])new Object[]{this.dog.method_5477().getString()}));
                this.dog.method_6092(new class_1293(class_1294.field_5924, 100, 1));
            } else {
                this.owner.method_43496((class_2561)class_2561.method_43469((String)"dog.msg.play_tag.you_win", (Object[])new Object[]{this.dog.method_5477().getString()}));
                this.owner.method_6092(new class_1293(class_1294.field_5924, 100, 1));
            }
            return;
        }
        if (!this.ownerBeenTagged) {
            if (this.cooldownChase <= 0) {
                this.chaseOwner(this.dog, this.owner);
            } else {
                --this.cooldownChase;
            }
        } else {
            this.runAway(this.dog, this.owner);
        }
    }

    private void chaseOwner(Dog dog, class_1309 owner) {
        class_1408 n = dog.method_5942();
        class_2338 dog_b0 = dog.method_24515();
        class_2338 owner_b0 = owner.method_24515();
        double d0 = dog.method_5858((class_1297)owner);
        this.dog.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.dog.method_5978());
        if (--this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 10;
            if (d0 > 256.0) {
                this.tickTillPathRecalc += 5;
            }
            n.method_6335((class_1297)owner, 1.0);
        }
        if (n.method_6357() && dog_b0.method_10262((class_2382)owner_b0) <= 4.0 && !this.canReachTarget(owner, d0)) {
            dog.method_5962().method_6239(owner.method_23317(), owner.method_23318(), owner.method_23321(), 1.0);
        }
        if (n.method_6357() && dog.field_6012 % 2 != 0 && !this.canReachTarget(owner, d0)) {
            this.tickTillPathRecalc = 0;
        }
        if (this.checkAndTag(dog, owner)) {
            n.method_6340();
            owner.method_43496((class_2561)class_2561.method_43469((String)"dog.msg.play_tag.gotcha", (Object[])new Object[]{dog.method_5477().getString()}));
            this.dog.method_5783(class_3417.field_14724, 1.0f, 1.0f);
            this.ownerBeenTagged = true;
            this.cooldownChase = 30;
            this.timeLeft = 400;
            return;
        }
    }

    private boolean checkAndTag(Dog dog, class_1309 owner) {
        if (this.canReachTarget(owner, dog.method_5858((class_1297)owner))) {
            dog.method_5783(class_3417.field_14627, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private void runAway(Dog dog, class_1309 owner) {
        class_1408 n = dog.method_5942();
        double d = dog.method_5858((class_1297)owner);
        if (--this.tickTillLook <= 0) {
            this.dog.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.dog.method_5978());
            if (this.tickTillLook <= -20) {
                this.tickTillLook = 20;
            }
        }
        if (n.method_6357() && dog.field_6012 % 2 != 0) {
            class_2338 b0 = this.getRandomPosAwayFromOwner(dog, owner);
            n.method_6337((double)b0.method_10263(), (double)b0.method_10264(), (double)b0.method_10260(), 1.0);
        }
        if (d < 9.0 && dog.field_6012 % 10 == 0) {
            n.method_6340();
        }
        if (this.cooldownChase > 0) {
            --this.cooldownChase;
        }
        if (this.canReachTarget(owner, d) && this.cooldownChase <= 0) {
            n.method_6340();
            dog.method_5783(class_3417.field_14627, 1.0f, 1.0f);
            this.ownerBeenTagged = false;
            this.cooldownChase = 30;
            this.timeLeft = 400;
        }
    }

    private class_2338 getRandomPosAwayFromOwner(Dog dog, class_1309 owner) {
        class_2338 owner_b0 = owner.method_24515();
        class_5819 r = dog.method_6051();
        int offSmall = 4;
        int offLarge = 20;
        int r1 = r.method_39332(-offLarge, offLarge);
        int r2 = r.method_39332(-offSmall, offSmall);
        r2 += class_3532.method_17822((double)r2) * 16;
        int dy = r.method_39332(-2, 2);
        int dx = r1;
        int dz = r2;
        if (dog.method_6051().method_43056()) {
            dx = r2;
            dz = r1;
        }
        return owner_b0.method_10069(dx, dy, dz);
    }

    @Override
    public void onStop() {
    }

    protected boolean canReachTarget(class_1309 target, double distanceToTargetSqr) {
        return this.getTagReachSqr(target) >= distanceToTargetSqr;
    }

    protected double getTagReachSqr(class_1309 target) {
        return this.dog.method_17681() * 2.0f * this.dog.method_17681() * 2.0f + target.method_17681();
    }
}

