/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.anim;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationState;
import net.minecraft.class_3532;

public class DogAnimationManager {
    private static final int SYNC_INTERVAL_TICK = 7;
    private static final int MIN_VAL_MAX_LATENCY = 7;
    public final DogAnimationState animationState = new DogAnimationState();
    public boolean needRefresh = false;
    private boolean started = false;
    private int animationTime;
    private final Dog dog;
    private boolean looping = false;
    private boolean holdOnLastTick = false;
    private boolean isHolding = false;
    private int tickTillSync = 0;

    public DogAnimationManager(Dog dog) {
        this.dog = dog;
    }

    public void onAnimationChange(DogAnimation anim) {
        this.animationTime = 0;
        this.isHolding = false;
        if (anim != DogAnimation.NONE) {
            this.started = true;
            this.looping = anim.looping();
            this.holdOnLastTick = anim.holdOnLastTick();
            this.animationTime = anim.getLengthTicks();
            this.animationState.start(this.dog.field_6012);
            this.tickTillSync = 7;
        } else {
            this.started = false;
            this.looping = false;
            this.animationState.stop();
            if (this.dog.method_37908().field_9236) {
                this.needRefresh = true;
            }
        }
    }

    public void tick() {
        if (this.started && !this.dog.getAnim().freeHead()) {
            this.dog.field_6283 = this.dog.field_6241;
            this.dog.resetBeggingRotation();
            if (!this.dog.getAnim().freeHeadXRotOnly()) {
                this.dog.method_36457(0.0f);
                this.dog.field_6004 = 0.0f;
            }
        }
        if (this.started && !this.dog.method_37908().field_9236 && !this.looping) {
            if (this.animationTime <= 0) {
                this.animationTime = 0;
                if (this.holdOnLastTick) {
                    this.isHolding = true;
                } else {
                    this.dog.setAnim(DogAnimation.NONE);
                }
            } else {
                if (--this.tickTillSync <= 0) {
                    this.tickTillSync = 7;
                    this.dog.setAnimSyncTime(this.animationTime);
                }
                --this.animationTime;
            }
        }
        if (this.started && this.dog.method_37908().field_9236 && !this.looping) {
            if (this.animationTime <= 0) {
                this.animationTime = 0;
                if (this.holdOnLastTick) {
                    this.isHolding = true;
                }
            } else {
                --this.animationTime;
            }
        }
    }

    public void onSyncTimeUpdated() {
        if (this.dog.method_37908().field_9236) {
            this.resolveLatencyIfNeeded();
        }
    }

    private void resolveLatencyIfNeeded() {
        int currentTime;
        int correctTime;
        int latencyAbs;
        if (!this.started || this.looping) {
            return;
        }
        int configMaxLatency = (Integer)ConfigHandler.CLIENT.MAX_ANIMATION_LATENCY_ALLOWED.get();
        if (configMaxLatency < 0) {
            return;
        }
        int maxLatencyAllowed = 7;
        if (configMaxLatency > 7) {
            maxLatencyAllowed = configMaxLatency;
        }
        if ((latencyAbs = class_3532.method_15382((int)((correctTime = this.dog.getAnimSyncTime()) - (currentTime = this.animationTime)))) <= maxLatencyAllowed) {
            return;
        }
        DogAnimation anim = this.dog.getAnim();
        this.animationTime = class_3532.method_15340((int)correctTime, (int)0, (int)anim.getLengthTicks());
        int correctPassedTime = anim.getLengthTicks() - this.animationTime;
        this.animationState.resolveLatency(this.dog.field_6012, correctPassedTime, anim.getSpeedModifier());
    }

    public boolean started() {
        return this.started;
    }

    public boolean isHolding() {
        return this.isHolding;
    }
}

