/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.ParticlePackets;
import doggytalents.common.talent.OokamiKazeTalent;
import doggytalents.common.util.DogUtil;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;

public class DogGunpowderProjectile
extends class_1682 {
    private int tickTillScan = 0;

    public DogGunpowderProjectile(class_1299<? extends class_1682> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    public DogGunpowderProjectile(class_1937 worldIn, class_1309 livingEntityIn) {
        super(DoggyEntityTypes.DOG_GUNPOWDER_PROJ.get(), livingEntityIn, worldIn);
    }

    protected void method_5693() {
    }

    protected void method_7488(class_239 hitResult) {
        if (this.method_37908().field_9236) {
            return;
        }
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        if (!this.method_37908().field_9236) {
            this.method_5775(new class_1799((class_1935)class_1802.field_8054));
        }
        if (!this.method_37908().field_9236) {
            this.method_31472();
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.scanDogAroundAndTrigger();
        }
    }

    private void scanDogAroundAndTrigger() {
        if (this.tickTillScan > 0) {
            --this.tickTillScan;
            return;
        }
        if (this.method_24921() == null) {
            return;
        }
        class_243 pos = this.method_19538();
        class_238 aabb = new class_238(pos.method_1031(-5.0, -5.0, -5.0), pos.method_1031(5.0, 0.0, 5.0));
        class_243 moveVec = this.method_18798();
        class_243 moveVecXZ = new class_243(moveVec.field_1352, 0.0, moveVec.field_1350).method_1029();
        if (moveVecXZ.method_1033() < 1.0) {
            return;
        }
        List dogs = this.method_37908().method_8390(Dog.class, aabb, filter_dog -> this.isValidDog((Dog)filter_dog, moveVecXZ));
        if (dogs.isEmpty()) {
            return;
        }
        this.tickTillScan = 3;
        Dog nearestDog = (Dog)dogs.get(0);
        double minDist = nearestDog.method_5858((class_1297)this);
        for (Dog dog : dogs) {
            double dist = dog.method_5858((class_1297)this);
            if (!(dist < minDist)) continue;
            nearestDog = dog;
            minDist = dist;
        }
        OokamiKazeTalent talentInst = nearestDog.getTalent(DoggyTalents.OOKAMIKAZE).map(inst -> inst.cast(OokamiKazeTalent.class)).orElse(null);
        if (talentInst == null) {
            return;
        }
        if (!talentInst.canExplode()) {
            return;
        }
        double dy = this.method_19538().field_1351 - nearestDog.method_19538().field_1351;
        double minDistXZ = new class_243(this.method_19538().field_1352 - nearestDog.method_19538().field_1352, 0.0, this.method_19538().field_1350 - nearestDog.method_19538().field_1350).method_1027();
        if (minDist < 4.0) {
            nearestDog.triggerAction(talentInst.actionCreator(nearestDog, null));
            this.feedDog(nearestDog);
        } else if (dy >= 1.5 && minDistXZ >= 10.0) {
            nearestDog.triggerAction(talentInst.actionCreator(nearestDog, this));
        }
    }

    private boolean isValidDog(Dog dog, class_243 lookVecXZ) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (dog.method_24345()) {
            return false;
        }
        if (dog.method_35057() != this.method_24921()) {
            return false;
        }
        if (!this.checkIfDogCanCatch(dog, lookVecXZ) && dog.method_5858((class_1297)this) >= 4.0) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        return dog.getDogLevel(DoggyTalents.OOKAMIKAZE.get()) > 0;
    }

    private boolean checkIfDogCanCatch(Dog dog, class_243 lookVecXZ) {
        class_243 dogPosXZ = new class_243(dog.method_19538().field_1352, 0.0, dog.method_19538().field_1350);
        class_243 posXZ = new class_243(this.method_19538().field_1352, 0.0, this.method_19538().field_1350);
        double dist = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(dogPosXZ, posXZ, lookVecXZ);
        if (dist < 0.0) {
            return false;
        }
        return dist < 2.25;
    }

    public void feedDog(Dog dog) {
        if (dog.method_37908() instanceof class_3218) {
            ParticlePackets.DogEatingParticlePacket.sendDogEatingParticlePacketToNearby(dog, new class_1799((class_1935)class_1802.field_8054));
        }
        dog.method_5783(class_3417.field_20614, dog.method_6107(), (dog.method_6051().method_43057() - dog.method_6051().method_43057()) * 0.2f + 1.0f);
        this.method_31472();
    }
}

