/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.stats;

import com.google.common.collect.Maps;
import doggytalents.common.util.Cache;
import doggytalents.common.util.NBTUtil;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class StatsTracker {
    private Map<class_1299<?>, Integer> ENTITY_KILLS = Maps.newHashMap();
    private float damageDealt = 0.0f;
    private int distanceOnWater = 0;
    private int distanceInWater = 0;
    private int distanceSprinting = 0;
    private int distanceSneaking = 0;
    private int distanceWalking = 0;
    private int distanceRidden = 0;
    private final Cache<Integer> killCount = Cache.make(this::getTotalKillCountInternal);

    public void writeAdditional(class_2487 compound) {
        class_2499 killList = new class_2499();
        for (Map.Entry<class_1299<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            class_2487 stats = new class_2487();
            NBTUtil.putRegistryValue(stats, "type", class_7923.field_41177.method_10221(entry.getKey()));
            stats.method_10569("count", entry.getValue().intValue());
            killList.add((Object)stats);
        }
        compound.method_10566("entityKills", (class_2520)killList);
        compound.method_10549("damageDealt", (double)this.damageDealt);
        compound.method_10569("distanceOnWater", this.distanceOnWater);
        compound.method_10569("distanceInWater", this.distanceInWater);
        compound.method_10569("distanceSprinting", this.distanceSprinting);
        compound.method_10569("distanceSneaking", this.distanceSneaking);
        compound.method_10569("distanceWalking", this.distanceWalking);
        compound.method_10569("distanceRidden", this.distanceRidden);
    }

    public void readAdditional(class_2487 compound) {
        class_2499 killList = compound.method_10554("entityKills", 10);
        for (int i = 0; i < killList.size(); ++i) {
            class_2487 stats = killList.method_10602(i);
            class_1299 type = (class_1299)NBTUtil.getRegistryValue(stats, "type", class_7923.field_41177);
            this.ENTITY_KILLS.put(type, stats.method_10550("count"));
        }
        this.damageDealt = compound.method_10583("damageDealt");
        this.distanceOnWater = compound.method_10550("distanceOnWater");
        this.distanceInWater = compound.method_10550("distanceInWater");
        this.distanceSprinting = compound.method_10550("distanceSprinting");
        this.distanceSneaking = compound.method_10550("distanceSneaking");
        this.distanceWalking = compound.method_10550("distanceWalking");
        this.distanceRidden = compound.method_10550("distanceRidden");
    }

    public int getKillCountFor(class_1299<?> type) {
        return this.ENTITY_KILLS.getOrDefault(type, 0);
    }

    public int getKillCountFor(Predicate<class_1311> classification) {
        int total = 0;
        for (Map.Entry<class_1299<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            if (!classification.test(entry.getKey().method_5891())) continue;
            total += entry.getValue().intValue();
        }
        return total;
    }

    private int getTotalKillCountInternal() {
        int total = 0;
        for (Map.Entry<class_1299<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    public Map<class_1299<?>, Integer> getAllKillCount() {
        return Collections.unmodifiableMap(this.ENTITY_KILLS);
    }

    public int getTotalKillCount() {
        return this.killCount.get();
    }

    public void incrementKillCount(class_1297 entity) {
        this.incrementKillCount(entity.method_5864());
    }

    private void incrementKillCount(class_1299<?> type) {
        this.ENTITY_KILLS.compute(type, (k, v) -> (v == null ? 0 : v) + 1);
    }

    public void increaseDamageDealt(float damage) {
        this.damageDealt += damage;
    }

    public void increaseDistanceOnWater(int distance) {
        this.distanceOnWater += distance;
    }

    public void increaseDistanceInWater(int distance) {
        this.distanceInWater += distance;
    }

    public void increaseDistanceSprint(int distance) {
        this.distanceSprinting += distance;
    }

    public void increaseDistanceSneaking(int distance) {
        this.distanceSneaking += distance;
    }

    public void increaseDistanceWalk(int distance) {
        this.distanceWalking += distance;
    }

    public void increaseDistanceRidden(int distance) {
        this.distanceRidden += distance;
    }

    public float getDamageDealt() {
        return this.damageDealt;
    }

    public int getDistanceOnWater() {
        return this.distanceOnWater;
    }

    public int getDistanceInWater() {
        return this.distanceInWater;
    }

    public int getDistanceSprint() {
        return this.distanceSprinting;
    }

    public int getDistanceSneaking() {
        return this.distanceSneaking;
    }

    public int getDistanceWalk() {
        return this.distanceWalking;
    }

    public int getDistanceRidden() {
        return this.distanceRidden;
    }

    public void serializeToBuf(class_2540 buf) {
        buf.writeFloat(this.damageDealt);
        buf.writeInt(this.distanceOnWater);
        buf.writeInt(this.distanceInWater);
        buf.writeInt(this.distanceSprinting);
        buf.writeInt(this.distanceSneaking);
        buf.writeInt(this.distanceWalking);
        buf.writeInt(this.distanceRidden);
        int mapSize = this.ENTITY_KILLS.size();
        buf.writeInt(mapSize);
        for (Map.Entry<class_1299<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            class_2960 typeId = class_7923.field_41177.method_10221(entry.getKey());
            Integer killCount = entry.getValue();
            buf.method_10812(typeId);
            buf.writeInt(killCount.intValue());
        }
    }

    public void deserializeFromBuf(class_2540 buf) {
        this.damageDealt = buf.readFloat();
        this.distanceOnWater = buf.readInt();
        this.distanceInWater = buf.readInt();
        this.distanceSprinting = buf.readInt();
        this.distanceSneaking = buf.readInt();
        this.distanceWalking = buf.readInt();
        this.distanceRidden = buf.readInt();
        this.ENTITY_KILLS.clear();
        int mapSize = buf.readInt();
        for (int i = 0; i < mapSize; ++i) {
            class_2960 typeId = buf.method_10810();
            int killCount = buf.readInt();
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(typeId);
            this.ENTITY_KILLS.put(type, killCount);
        }
    }

    public void shallowCopyFrom(StatsTracker stats) {
        this.ENTITY_KILLS = stats.ENTITY_KILLS;
        this.damageDealt = stats.damageDealt;
        this.distanceOnWater = stats.distanceOnWater;
        this.distanceInWater = stats.distanceInWater;
        this.distanceSprinting = stats.distanceSprinting;
        this.distanceSneaking = stats.distanceSneaking;
        this.distanceWalking = stats.distanceWalking;
        this.distanceRidden = stats.distanceRidden;
    }
}

