/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.fabric_helper.entity;

import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.DogSize;
import doggytalents.api.feature.EnumGender;
import doggytalents.api.feature.EnumMode;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.entity.DogPettingManager;
import doggytalents.common.entity.serializers.DimensionDependantArg;
import doggytalents.common.entity.texture.DogSkinData;
import doggytalents.common.fabric_helper.entity.network.FabricSyncAllData;
import doggytalents.common.fabric_helper.entity.network.SyncTypes;
import doggytalents.common.item.DoggyArtifactItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2943;
import net.minecraft.class_3222;

public class DogFabricHelper {
    private final Dog dog;
    private DogLevel dogLevel = new DogLevel(0, 0);
    private DogVariant dogVariant = DogVariantUtil.getDefault();
    private EnumGender dogGender = EnumGender.MALE;
    private EnumMode dogMode = EnumMode.DOCILE;
    private DimensionDependantArg<Optional<class_2338>> bowlPos = new DimensionDependantArg(() -> class_2943.field_13315);
    private DimensionDependantArg<Optional<class_2338>> bedPos = new DimensionDependantArg(() -> class_2943.field_13315);
    private DogIncapacitatedMananger.IncapacitatedSyncState incapSyncState = DogIncapacitatedMananger.IncapacitatedSyncState.NONE;
    private List<DoggyArtifactItem> artifacts = new ArrayList<DoggyArtifactItem>();
    private DogSize dogSize = DogSize.MODERATO;
    private DogSkinData dogSkin = DogSkinData.NULL;
    private DogPettingManager.DogPettingState dogPettingState = DogPettingManager.DogPettingState.NULL;
    private final ArrayList<SyncTypes.SyncType<?>> dirtyEntries = new ArrayList();

    public DogFabricHelper(Dog dog) {
        this.dog = dog;
    }

    private void setDirty(SyncTypes.SyncType<?> type) {
        if (this.dirtyEntries.contains(type)) {
            return;
        }
        this.dirtyEntries.add(type);
    }

    public void tick() {
        if (this.dog.method_37908().field_9236) {
            return;
        }
        if (this.dirtyEntries.isEmpty()) {
            return;
        }
        this.broadcastChangesToClients(this.dirtyEntries);
        this.dirtyEntries.clear();
    }

    private void broadcastChangesToClients(List<SyncTypes.SyncType<?>> dirty) {
        FabricSyncAllData data = new FabricSyncAllData(this.dog.method_5628());
        for (SyncTypes.SyncType<?> type : dirty) {
            data.putVal(type, this);
        }
        PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.dog), data);
    }

    public DogLevel getDogLevel() {
        return this.dogLevel;
    }

    public void setDogLevel(DogLevel dogLevel) {
        if (dogLevel == this.dogLevel) {
            return;
        }
        if (!this.dog.method_37908().field_9236) {
            this.setDirty(SyncTypes.DOG_LEVEL);
        }
        this.dogLevel = dogLevel;
        this.dog.onFabricDataUpdated(SyncTypes.DOG_LEVEL);
    }

    public DogVariant getDogVariant() {
        return this.dogVariant;
    }

    public void setDogVariant(DogVariant val) {
        if (val == this.dogVariant) {
            return;
        }
        if (!this.dog.method_37908().field_9236) {
            this.setDirty(SyncTypes.DOG_VARIANT);
        }
        this.dogVariant = val;
        this.dog.onFabricDataUpdated(SyncTypes.DOG_VARIANT);
    }

    public EnumGender getDogGender() {
        return this.dogGender;
    }

    public void setDogGender(EnumGender dogGender) {
        if (dogGender == this.dogGender) {
            return;
        }
        if (!this.dog.method_37908().field_9236) {
            this.setDirty(SyncTypes.DOG_GENDER);
        }
        this.dogGender = dogGender;
    }

    public EnumMode getDogMode() {
        return this.dogMode;
    }

    public void setDogMode(EnumMode dogMode) {
        if (dogMode == this.dogMode) {
            return;
        }
        if (!this.dog.method_37908().field_9236) {
            this.setDirty(SyncTypes.DOG_MODE);
        }
        this.dogMode = dogMode;
        this.dog.onFabricDataUpdated(SyncTypes.DOG_MODE);
    }

    public DimensionDependantArg<Optional<class_2338>> getBowlPos() {
        return this.bowlPos;
    }

    public void setBowlPos(DimensionDependantArg<Optional<class_2338>> bowlPos) {
        this.bowlPos = bowlPos;
    }

    public DimensionDependantArg<Optional<class_2338>> getBedPos() {
        return this.bedPos;
    }

    public void setBedPos(DimensionDependantArg<Optional<class_2338>> bedPos) {
        this.bedPos = bedPos;
    }

    public DogIncapacitatedMananger.IncapacitatedSyncState getIncapSyncState() {
        return this.incapSyncState;
    }

    public void setIncapSyncState(DogIncapacitatedMananger.IncapacitatedSyncState incapSyncState) {
        if (this.incapSyncState.equals(incapSyncState)) {
            return;
        }
        if (!this.dog.method_37908().field_9236) {
            this.setDirty(SyncTypes.INCAP_SYNC_STATE);
        }
        this.incapSyncState = incapSyncState;
    }

    public List<DoggyArtifactItem> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<DoggyArtifactItem> artifacts) {
        if (this.artifacts == artifacts) {
            return;
        }
        if (!this.dog.method_37908().field_9236) {
            this.setDirty(SyncTypes.ARTIFACTS);
        }
        this.artifacts = artifacts;
        this.dog.onFabricDataUpdated(SyncTypes.ARTIFACTS);
    }

    public DogSize getDogSize() {
        return this.dogSize;
    }

    public void setDogSize(DogSize dogSize) {
        if (this.dogSize == dogSize) {
            return;
        }
        if (!this.dog.method_37908().field_9236) {
            this.setDirty(SyncTypes.DOG_SIZE);
        }
        this.dogSize = dogSize;
        this.dog.onFabricDataUpdated(SyncTypes.DOG_SIZE);
    }

    public DogSkinData getDogSkin() {
        return this.dogSkin;
    }

    public void setDogSkin(DogSkinData data) {
        if (this.dogSkin == data) {
            return;
        }
        if (!this.dog.method_37908().field_9236) {
            this.setDirty(SyncTypes.DOG_SKIN);
        }
        this.dogSkin = data;
        this.dog.onFabricDataUpdated(SyncTypes.DOG_SKIN);
    }

    public DogPettingManager.DogPettingState getDogPettingState() {
        return this.dogPettingState;
    }

    public void setDogPettingState(DogPettingManager.DogPettingState data) {
        if (this.dogPettingState.equals(data)) {
            return;
        }
        if (!this.dog.method_37908().field_9236) {
            this.setDirty(SyncTypes.DOG_PETTING_STATE);
        }
        this.dogPettingState = data;
        this.dog.onFabricDataUpdated(SyncTypes.DOG_PETTING_STATE);
    }

    public void onStartBeingSeenBy(class_3222 player) {
        this.sendAllDataTo(player);
    }

    private void sendAllDataTo(class_3222 player) {
        FabricSyncAllData data = new FabricSyncAllData(this.dog.method_5628());
        for (SyncTypes.SyncType<?> type : SyncTypes.getAll()) {
            data.putVal(type, this);
        }
        PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), data);
    }
}

