/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.feature.FoodHandler;
import doggytalents.api.forge_imitate.inventory.ItemStackHandler;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.Screens;
import doggytalents.common.entity.misc.DogFoodProjectile;
import doggytalents.common.entity.misc.DogGunpowderProjectile;
import doggytalents.common.inventory.TreatBagItemHandler;
import doggytalents.common.util.Cache;
import doggytalents.common.util.DogFoodUtil;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class TreatBagItem
extends class_1792
implements IDogFoodHandler {
    private Cache<String> contentsTranslationKey = Cache.make(() -> this.method_7876() + ".contents");

    public TreatBagItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 stack = playerIn.method_5998(handIn);
        if (worldIn.field_9236) {
            return new class_1271(class_1269.field_5812, (Object)stack);
        }
        if (!playerIn.method_5715()) {
            if (playerIn instanceof class_3222) {
                class_3222 sP = (class_3222)playerIn;
                this.findFoodAndShootOut(sP, stack);
            }
            return new class_1271(class_1269.field_5812, (Object)stack);
        }
        if (playerIn instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)playerIn;
            Screens.openTreatBagScreen(serverPlayer, stack, playerIn.method_31548().field_7545);
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    private void findFoodAndShootOut(class_3222 player, class_1799 stack) {
        TreatBagItemHandler itemHandler = new TreatBagItemHandler(stack);
        int foodStackId = this.findThrowableInItemHandler(itemHandler);
        if (foodStackId < 0) {
            return;
        }
        class_1799 foodStack = itemHandler.getStackInSlot(foodStackId);
        if (foodStack.method_7960()) {
            return;
        }
        if (foodStack.method_31574(class_1802.field_8054)) {
            this.throwGunpowder((class_1657)player);
        } else {
            this.throwFood((class_1657)player, foodStack.method_7909());
        }
        foodStack = foodStack.method_7972();
        foodStack.method_7934(1);
        itemHandler.setStackInSlot(foodStackId, foodStack);
        player.method_7357().method_7906((class_1792)this, 20);
    }

    private void throwFood(class_1657 player, class_1792 item) {
        DogFoodProjectile dogFoodProj = new DogFoodProjectile(player.method_37908(), (class_1309)player);
        dogFoodProj.setDogFoodStack(new class_1799((class_1935)item));
        dogFoodProj.method_7432((class_1297)player);
        dogFoodProj.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 0.8f, 1.0f);
        player.method_37908().method_8649((class_1297)dogFoodProj);
    }

    private void throwGunpowder(class_1657 player) {
        DogGunpowderProjectile dogGunpowderProj = new DogGunpowderProjectile(player.method_37908(), (class_1309)player);
        dogGunpowderProj.method_7432((class_1297)player);
        dogGunpowderProj.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 0.8f, 1.0f);
        player.method_37908().method_8649((class_1297)dogGunpowderProj);
    }

    private int findThrowableInItemHandler(ItemStackHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            class_1799 stack = itemHandler.getStackInSlot(i);
            if (stack.method_7960()) continue;
            if (FoodHandler.isFood(stack).isPresent()) {
                return i;
            }
            if (!stack.method_31574(class_1802.field_8054)) continue;
            return i;
        }
        return -1;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.doggytalents.treat_bag.help").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
        this.displayContents(stack, tooltip, flagIn);
    }

    private void displayContents(class_1799 stack, List<class_2561> tooltip, class_1836 flagIn) {
        TreatBagItemHandler inv = new TreatBagItemHandler(stack);
        ItemUtil.ContentOverview contentsOverview = ItemUtil.getContentOverview(inv);
        Map<class_1792, Integer> contentsMap = contentsOverview.contents();
        if (contentsMap.isEmpty()) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"item.doggytalents.treat_bag.contents"));
        for (Map.Entry<class_1792, Integer> entry : contentsMap.entrySet()) {
            class_5250 c1 = class_2561.method_43469((String)"item.doggytalents.starter_bundle.contains", (Object[])new Object[]{entry.getValue(), entry.getKey().method_7848()}).method_27696(class_2583.field_24360.method_36139(-6052957));
            tooltip.add((class_2561)c1);
        }
        if (contentsOverview.isMore() > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.doggytalents.treat_bag.contents.more", (Object[])new Object[]{contentsOverview.isMore()}).method_27696(class_2583.field_24360.method_36139(-6052957)));
        }
    }

    @Override
    public boolean isFood(class_1799 stackIn) {
        return false;
    }

    @Override
    public boolean canConsume(AbstractDog dogIn, class_1799 stackIn, class_1297 entityIn) {
        if (dogIn.isDefeated()) {
            return false;
        }
        return entityIn instanceof class_1309 ? dogIn.canInteract((class_1309)entityIn) : false;
    }

    @Override
    public class_1269 consume(AbstractDog dogIn, class_1799 stackIn, class_1297 entityIn) {
        if (dogIn.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        TreatBagItemHandler treatBag = new TreatBagItemHandler(stackIn);
        return DogFoodUtil.tryFeedAny(dogIn, entityIn, treatBag);
    }
}

