/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.client.entity.render.world.CanineTrackerLocateRenderer;
import doggytalents.client.screen.CanineTrackerScreen;
import doggytalents.common.item.CanineTrackerItem;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CanineTrackerData;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.forge_imitate.network.ForgeNetworkHandler;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import org.apache.commons.lang3.tuple.Triple;

public class CanineTrackerPackets {

    public static class ResponsePosUpdatePacket
    implements IPacket<CanineTrackerData.ResponsePosUpdateData> {
        @Override
        public void encode(CanineTrackerData.ResponsePosUpdateData data, class_2540 buf) {
            buf.method_10797(data.uuid);
            buf.method_10807(data.correctPos);
        }

        @Override
        public CanineTrackerData.ResponsePosUpdateData decode(class_2540 buf) {
            UUID uuid = buf.method_10790();
            class_2338 pos = buf.method_10811();
            return new CanineTrackerData.ResponsePosUpdateData(uuid, pos);
        }

        @Override
        public void handle(CanineTrackerData.ResponsePosUpdateData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    return;
                }
                CanineTrackerLocateRenderer.correctPos(data.uuid, data.correctPos);
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class RequestPosUpdatePacket
    implements IPacket<CanineTrackerData.RequestPosUpdateData> {
        @Override
        public void encode(CanineTrackerData.RequestPosUpdateData data, class_2540 buf) {
            buf.method_10797(data.uuid);
            buf.method_10807(data.pos);
        }

        @Override
        public CanineTrackerData.RequestPosUpdateData decode(class_2540 buf) {
            return new CanineTrackerData.RequestPosUpdateData(buf.method_10790(), buf.method_10811());
        }

        @Override
        public void handle(CanineTrackerData.RequestPosUpdateData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    return;
                }
                class_3222 sender = ((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                class_1799 stack = sender.method_6047();
                if (!(stack.method_7909() instanceof CanineTrackerItem)) {
                    return;
                }
                DogLocationStorage storage = DogLocationStorage.get(sender.method_37908());
                DogLocationData entry = storage.getData(data.uuid);
                if (entry == null) {
                    return;
                }
                UUID owner_id = entry.getOwnerId();
                if (owner_id == null) {
                    return;
                }
                if (!owner_id.equals(sender.method_5667())) {
                    return;
                }
                class_243 correct_pos = entry.getPos();
                if (correct_pos == null) {
                    return;
                }
                class_2338 correct_blockpos = new class_2338(class_3532.method_15357((double)correct_pos.field_1352), class_3532.method_15357((double)correct_pos.field_1351), class_3532.method_15357((double)correct_pos.field_1350));
                if (correct_blockpos.method_10262((class_2382)data.pos) < 4.0) {
                    return;
                }
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new CanineTrackerData.ResponsePosUpdateData(data.uuid, correct_blockpos));
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class StartLocatingPacket
    implements IPacket<CanineTrackerData.StartLocatingData> {
        @Override
        public void encode(CanineTrackerData.StartLocatingData data, class_2540 buf) {
            buf.method_10797(data.uuid);
        }

        @Override
        public CanineTrackerData.StartLocatingData decode(class_2540 buf) {
            UUID uuid = buf.method_10790();
            return new CanineTrackerData.StartLocatingData(uuid);
        }

        @Override
        public void handle(CanineTrackerData.StartLocatingData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                class_2487 tag;
                if (!((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    return;
                }
                class_3222 player = ((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                class_1799 stack = player.method_6047();
                if (!(stack.method_7909() instanceof CanineTrackerItem)) {
                    return;
                }
                DogLocationStorage storage = DogLocationStorage.get(player.method_37908());
                DogLocationData dogData = storage.getData(data.uuid);
                if (dogData == null) {
                    return;
                }
                if (!stack.method_7985()) {
                    stack.method_7980(new class_2487());
                }
                if ((tag = stack.method_7969()) == null) {
                    return;
                }
                class_2338 pos = class_2338.method_49638((class_2374)dogData.getPos());
                tag.method_25927("uuid", data.uuid);
                tag.method_10582("name", dogData.getDogName());
                tag.method_10569("posX", pos.method_10263());
                tag.method_10569("posY", pos.method_10264());
                tag.method_10569("posZ", pos.method_10260());
                tag.method_10569("locateColor", dogData.getLocateColor());
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class ResponseDogsPackets
    implements IPacket<CanineTrackerData.ResponseDogsData> {
        @Override
        public void encode(CanineTrackerData.ResponseDogsData data, class_2540 buf) {
            int size = data.entries.size();
            buf.writeInt(size);
            for (int i = 0; i < size; ++i) {
                Triple<UUID, String, class_2338> payload = data.entries.get(i);
                UUID uuid = (UUID)payload.getLeft();
                String name = (String)payload.getMiddle();
                class_2338 pos = (class_2338)payload.getRight();
                if (uuid == null) {
                    uuid = class_156.field_25140;
                }
                if (name == null) {
                    name = "noname";
                }
                if (pos == null) {
                    pos = class_2338.field_10980;
                }
                buf.method_10797(uuid);
                buf.method_10814(name);
                buf.method_10807(pos);
            }
        }

        @Override
        public CanineTrackerData.ResponseDogsData decode(class_2540 buf) {
            int size = buf.readInt();
            ArrayList<Triple<UUID, String, class_2338>> newDogsLs = new ArrayList<Triple<UUID, String, class_2338>>(size);
            for (int i = 0; i < size; ++i) {
                UUID id = buf.method_10790();
                String name = buf.method_19772();
                class_2338 pos = buf.method_10811();
                Triple payload = Triple.of((Object)id, (Object)name, (Object)pos);
                newDogsLs.add((Triple<UUID, String, class_2338>)payload);
            }
            return new CanineTrackerData.ResponseDogsData(newDogsLs);
        }

        @Override
        public void handle(CanineTrackerData.ResponseDogsData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    class_437 patt4993$temp;
                    class_310 mc = class_310.method_1551();
                    if (mc.field_1755 != null && (patt4993$temp = mc.field_1755) instanceof CanineTrackerScreen) {
                        CanineTrackerScreen scr = (CanineTrackerScreen)patt4993$temp;
                        scr.assignResponse(data.entries);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class RequestDogsPacket
    implements IPacket<CanineTrackerData.RequestDogsData> {
        @Override
        public void encode(CanineTrackerData.RequestDogsData data, class_2540 buf) {
        }

        @Override
        public CanineTrackerData.RequestDogsData decode(class_2540 buf) {
            return new CanineTrackerData.RequestDogsData();
        }

        @Override
        public void handle(CanineTrackerData.RequestDogsData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    return;
                }
                class_3222 sender = ((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                DogLocationStorage storage = DogLocationStorage.get(sender.method_37908());
                List<Triple<UUID, String, class_2338>> dogLs = storage.getDogs((class_1309)sender, (class_5321<class_1937>)sender.method_37908().method_27983()).filter(dogLoc -> dogLoc.shouldDisplay(sender.method_37908(), (class_1657)sender, class_1268.field_5808)).map(dogLoc -> Triple.of((Object)dogLoc.getDogId(), (Object)dogLoc.getDogName(), (Object)new class_2338(class_3532.method_15357((double)dogLoc.getPos().field_1352), class_3532.method_15357((double)dogLoc.getPos().field_1351), class_3532.method_15357((double)dogLoc.getPos().field_1350)))).collect(Collectors.toList());
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new CanineTrackerData.ResponseDogsData(dogLs));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

