/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Talent;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogDeTrainData;
import doggytalents.forge_imitate.network.ForgeNetworkHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class DogDeTrainPacket
extends DogPacket<DogDeTrainData> {
    @Override
    public void encode(DogDeTrainData data, class_2540 buf) {
        super.encode(data, buf);
        buf.method_42065((class_2359)DoggyTalentsAPI.TALENTS.get(), (Object)data.talent);
    }

    @Override
    public DogDeTrainData decode(class_2540 buf) {
        int entityId = buf.readInt();
        Talent talent = (Talent)buf.method_42064((class_2359)DoggyTalentsAPI.TALENTS.get());
        return new DogDeTrainData(entityId, talent);
    }

    @Override
    public void handleDog(Dog dog, DogDeTrainData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
        class_3222 sender = ctx.get().getSender();
        class_1799 stack = sender.method_6047();
        if (stack.method_7909() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        if (sender.method_7357().method_7904(DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID ownerUUID = dog.method_6139();
        if (ownerUUID == null) {
            return;
        }
        if (!ownerUUID.equals(sender.method_5667())) {
            return;
        }
        Talent talent = data.talent;
        int dog_level = dog.getDogLevel(talent);
        if (dog_level <= 0) {
            return;
        }
        int xp_cost = talent.getDeTrainXPCost(dog_level);
        if (sender.field_7520 < xp_cost) {
            return;
        }
        dog.setTalentLevel(talent, 0);
        dog.clearTriggerableAction();
        sender.method_7357().method_7906(DoggyItems.AMNESIA_BONE.get(), 20);
        sender.method_7316(-xp_cost);
    }
}

